/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.research;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hexvane.strangematter.research.ResearchNode;
import com.hexvane.strangematter.research.ResearchNodeRegistry;
import com.mojang.logging.LogUtils;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ResearchNodePositionManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int GRID_SIZE = 80;
    private static final String CONFIG_DIR = "config/strangematter";
    private static final String POSITIONS_FILE = "research_node_positions.json";
    private static ResearchNodePositionManager instance;
    private final Map<String, NodePosition> positionOverrides = new HashMap<String, NodePosition>();
    private boolean positionsLoaded = false;

    private ResearchNodePositionManager() {
    }

    public static ResearchNodePositionManager getInstance() {
        if (instance == null) {
            instance = new ResearchNodePositionManager();
        }
        return instance;
    }

    public int getEffectiveX(ResearchNode node) {
        if (node == null) {
            return 0;
        }
        NodePosition override = this.positionOverrides.get(node.getId());
        return override != null ? override.x : node.getX();
    }

    public int getEffectiveY(ResearchNode node) {
        if (node == null) {
            return 0;
        }
        NodePosition override = this.positionOverrides.get(node.getId());
        return override != null ? override.y : node.getY();
    }

    public int getEffectiveX(String nodeId) {
        ResearchNode node = ResearchNodeRegistry.getNode(nodeId);
        if (node == null) {
            return 0;
        }
        return this.getEffectiveX(node);
    }

    public int getEffectiveY(String nodeId) {
        ResearchNode node = ResearchNodeRegistry.getNode(nodeId);
        if (node == null) {
            return 0;
        }
        return this.getEffectiveY(node);
    }

    public void setPosition(String nodeId, int x, int y) {
        int snappedX = ResearchNodePositionManager.snapToGrid(x);
        int snappedY = ResearchNodePositionManager.snapToGrid(y);
        this.positionOverrides.put(nodeId, new NodePosition(snappedX, snappedY));
    }

    public void clearPosition(String nodeId) {
        this.positionOverrides.remove(nodeId);
    }

    public boolean hasOverride(String nodeId) {
        return this.positionOverrides.containsKey(nodeId);
    }

    public static int snapToGrid(int value) {
        return (int)Math.round((double)value / 80.0) * 80;
    }

    public static int getGridSize() {
        return 80;
    }

    public void loadPositions() {
        if (this.positionsLoaded) {
            return;
        }
        Path configPath = Paths.get(CONFIG_DIR, new String[0]);
        Path filePath = configPath.resolve(POSITIONS_FILE);
        if (!Files.exists(filePath, new LinkOption[0])) {
            LOGGER.debug("[Research Debug] No saved positions file found at {}", (Object)filePath);
            this.positionsLoaded = true;
            return;
        }
        try (FileReader reader = new FileReader(filePath.toFile());){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (json.has("nodes") && json.get("nodes").isJsonObject()) {
                JsonObject nodesObj = json.getAsJsonObject("nodes");
                int loadedCount = 0;
                for (String nodeId : nodesObj.keySet()) {
                    JsonObject nodePos = nodesObj.getAsJsonObject(nodeId);
                    if (!nodePos.has("x") || !nodePos.has("y")) continue;
                    int x = nodePos.get("x").getAsInt();
                    int y = nodePos.get("y").getAsInt();
                    if (ResearchNodeRegistry.getNode(nodeId) != null) {
                        this.positionOverrides.put(nodeId, new NodePosition(x, y));
                        ++loadedCount;
                        continue;
                    }
                    LOGGER.debug("[Research Debug] Skipping position for unknown node: {}", (Object)nodeId);
                }
                LOGGER.info("[Research Debug] Loaded {} node position overrides from {}", (Object)loadedCount, (Object)filePath);
            }
        }
        catch (Exception e) {
            LOGGER.error("[Research Debug] Failed to load positions from {}", (Object)filePath, (Object)e);
        }
        this.positionsLoaded = true;
    }

    public void savePositions() {
        Path configPath = Paths.get(CONFIG_DIR, new String[0]);
        Path filePath = configPath.resolve(POSITIONS_FILE);
        try {
            Files.createDirectories(configPath, new FileAttribute[0]);
            JsonObject root = new JsonObject();
            JsonObject nodesObj = new JsonObject();
            for (Map.Entry<String, NodePosition> entry : this.positionOverrides.entrySet()) {
                JsonObject nodePos = new JsonObject();
                nodePos.addProperty("x", (Number)entry.getValue().x);
                nodePos.addProperty("y", (Number)entry.getValue().y);
                nodesObj.add(entry.getKey(), (JsonElement)nodePos);
            }
            root.add("nodes", (JsonElement)nodesObj);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (FileWriter writer = new FileWriter(filePath.toFile());){
                gson.toJson((JsonElement)root, (Appendable)writer);
            }
            LOGGER.info("[Research Debug] Saved {} node position overrides to {}", (Object)this.positionOverrides.size(), (Object)filePath);
        }
        catch (IOException e) {
            LOGGER.error("[Research Debug] Failed to save positions to {}", (Object)filePath, (Object)e);
        }
    }

    public void clearAll() {
        this.positionOverrides.clear();
    }

    private static class NodePosition {
        final int x;
        final int y;

        NodePosition(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

