/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.renderer;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.block.LevitationPadBlock;
import com.hexvane.strangematter.block.LevitationPadBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class LevitationPadRenderer
implements BlockEntityRenderer<LevitationPadBlockEntity> {
    private static final ResourceLocation LEVITATION_FIELD_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/block/levitation_field.png");

    public LevitationPadRenderer(BlockEntityRendererProvider.Context context) {
    }

    public int m_142163_() {
        return 256;
    }

    public boolean shouldRender(LevitationPadBlockEntity blockEntity, Vec3 cameraPos) {
        return true;
    }

    public boolean shouldRenderOffScreen(LevitationPadBlockEntity blockEntity) {
        return true;
    }

    public void render(LevitationPadBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockPos pos;
        if (blockEntity == null || blockEntity.m_58904_() == null) {
            return;
        }
        Level level = blockEntity.m_58904_();
        BlockState state = level.m_8055_(pos = blockEntity.m_58899_());
        if (!(state.m_60734_() instanceof LevitationPadBlock)) {
            return;
        }
        boolean levitateUp = (Boolean)state.m_61143_((Property)LevitationPadBlock.LEVITATE_UP);
        int maxHeight = this.calculateMaxHeight(level, pos);
        if (maxHeight > 0) {
            this.renderLevitationBeam(poseStack, buffer, maxHeight, levitateUp, partialTicks, packedLight);
        }
    }

    private float normalizeUV(float uv) {
        while (uv < 0.0f) {
            uv += 1.0f;
        }
        while (uv > 1.0f) {
            uv -= 1.0f;
        }
        return uv;
    }

    private int calculateMaxHeight(Level level, BlockPos pos) {
        BlockPos currentPos = pos.m_7494_();
        int height = 0;
        int maxRange = Config.levitationPadMaxHeight;
        while (height < maxRange) {
            BlockState blockState = level.m_8055_(currentPos);
            if (blockState.m_60734_() == Blocks.f_50016_ || blockState.m_60734_() == Blocks.f_50627_ || blockState.m_60734_() == Blocks.f_50626_ || blockState.m_60795_()) {
                ++height;
                currentPos = currentPos.m_7494_();
                continue;
            }
            if (!(blockState.m_60734_() instanceof TrapDoorBlock) || !((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue()) break;
            ++height;
            currentPos = currentPos.m_7494_();
        }
        return ++height;
    }

    private void renderLevitationBeam(PoseStack poseStack, MultiBufferSource buffer, int height, boolean goingUp, float partialTicks, int packedLight) {
        poseStack.m_85836_();
        RenderType renderType = RenderType.m_234338_((ResourceLocation)LEVITATION_FIELD_TEXTURE);
        VertexConsumer vertexConsumer = buffer.m_6299_(renderType);
        float textureHeight = 1.0f;
        long gameTime = Minecraft.m_91087_().f_91073_.m_46467_();
        float animationTime = ((float)gameTime + partialTicks) * 0.01f;
        float uvOffset = animationTime % 1.0f;
        if (goingUp) {
            uvOffset = -uvOffset;
        }
        float uMin = 0.0f;
        float uMax = 0.75f;
        float vMin = 0.0f;
        float vMax = 1.0f;
        float beamSize = 0.75f;
        float beamOffset = (1.0f - beamSize) / 2.0f;
        float y1 = 0.0f;
        float y2 = height;
        float beamVMin = vMin * (float)height + uvOffset;
        float beamVMax = vMax * (float)height + uvOffset;
        this.renderBeamSegment(poseStack, vertexConsumer, beamOffset, 1.0f - beamOffset, y1, y2, beamOffset, 1.0f - beamOffset, uMin, uMax, beamVMin, beamVMax, packedLight, goingUp);
        poseStack.m_85849_();
    }

    private void renderBeamSegment(PoseStack poseStack, VertexConsumer vertexConsumer, float x1, float x2, float y1, float y2, float z1, float z2, float u1, float u2, float v1, float v2, int packedLight, boolean goingUp) {
        float v1Flipped = goingUp ? v1 : 1.0f - v1;
        float v2Flipped = goingUp ? v2 : 1.0f - v2;
        this.addVertex(vertexConsumer, poseStack, x1, y1, z1, u1, v1Flipped, packedLight, 0);
        this.addVertex(vertexConsumer, poseStack, x1, y2, z1, u1, v2Flipped, packedLight, 0);
        this.addVertex(vertexConsumer, poseStack, x2, y2, z1, u2, v2Flipped, packedLight, 0);
        this.addVertex(vertexConsumer, poseStack, x2, y1, z1, u2, v1Flipped, packedLight, 0);
        this.addVertex(vertexConsumer, poseStack, x2, y1, z2, u1, v1Flipped, packedLight, 0);
        this.addVertex(vertexConsumer, poseStack, x2, y2, z2, u1, v2Flipped, packedLight, 0);
        this.addVertex(vertexConsumer, poseStack, x1, y2, z2, u2, v2Flipped, packedLight, 0);
        this.addVertex(vertexConsumer, poseStack, x1, y1, z2, u2, v1Flipped, packedLight, 0);
        this.addVertex(vertexConsumer, poseStack, x1, y1, z2, u1, v1Flipped, packedLight, 0);
        this.addVertex(vertexConsumer, poseStack, x1, y2, z2, u1, v2Flipped, packedLight, 0);
        this.addVertex(vertexConsumer, poseStack, x1, y2, z1, u2, v2Flipped, packedLight, 0);
        this.addVertex(vertexConsumer, poseStack, x1, y1, z1, u2, v1Flipped, packedLight, 0);
        this.addVertex(vertexConsumer, poseStack, x2, y1, z1, u1, v1Flipped, packedLight, 0);
        this.addVertex(vertexConsumer, poseStack, x2, y2, z1, u1, v2Flipped, packedLight, 0);
        this.addVertex(vertexConsumer, poseStack, x2, y2, z2, u2, v2Flipped, packedLight, 0);
        this.addVertex(vertexConsumer, poseStack, x2, y1, z2, u2, v1Flipped, packedLight, 0);
    }

    private void addVertex(VertexConsumer buffer, PoseStack poseStack, float x, float y, float z, float u, float v, int combinedLight, int combinedOverlay) {
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_7421_(u, v).m_86008_(combinedOverlay).m_85969_(combinedLight).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

