/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.obj;

import com.hexvane.strangematter.client.render.TriangleRenderType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class OBJLoader {
    private static Map<String, ResourceLocation> loadMTL(ResourceLocation mtlLocation) {
        HashMap<String, ResourceLocation> materials = new HashMap<String, ResourceLocation>();
        try (InputStream stream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(mtlLocation).get()).m_215507_();){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String currentMaterial = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("newmtl ")) {
                    currentMaterial = line.substring(7);
                    continue;
                }
                if (!line.startsWith("map_Kd ") || currentMaterial == null) continue;
                String texturePath = line.substring(7);
                ResourceLocation texture = new ResourceLocation(mtlLocation.m_135827_(), "textures/block/" + texturePath);
                materials.put(currentMaterial, texture);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load MTL file: " + e.getMessage());
        }
        return materials;
    }

    public static OBJModel loadModel(ResourceLocation location) {
        return OBJLoader.loadModel(location, false);
    }

    public static OBJModel loadModel(ResourceLocation location, boolean flipUVs) {
        OBJModel model = new OBJModel();
        String currentMaterial = "default";
        String objPath = location.m_135815_();
        String mtlPath = objPath.replace(".obj", ".mtl");
        ResourceLocation mtlLocation = new ResourceLocation(location.m_135827_(), mtlPath);
        model.materials = OBJLoader.loadMTL(mtlLocation);
        try (InputStream stream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(location).get()).m_215507_();){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                float z;
                String[] parts;
                if ((line = line.trim()).startsWith("mtllib ")) continue;
                if (line.startsWith("usemtl ")) {
                    currentMaterial = line.substring(7);
                    continue;
                }
                if (line.startsWith("v ")) {
                    parts = line.substring(2).split("\\s+");
                    float x = Float.parseFloat(parts[0]);
                    float y = Float.parseFloat(parts[1]);
                    z = Float.parseFloat(parts[2]);
                    model.vertices.add(new float[]{x, y, z});
                    continue;
                }
                if (line.startsWith("vn ")) {
                    parts = line.substring(3).split("\\s+");
                    float x = Float.parseFloat(parts[0]);
                    float y = Float.parseFloat(parts[1]);
                    z = Float.parseFloat(parts[2]);
                    model.normals.add(new float[]{x, y, z});
                    continue;
                }
                if (line.startsWith("vt ")) {
                    parts = line.substring(3).split("\\s+");
                    float u = Float.parseFloat(parts[0]);
                    float v = Float.parseFloat(parts[1]);
                    if (flipUVs) {
                        v = 1.0f - v;
                    }
                    model.texCoords.add(new float[]{u, v});
                    continue;
                }
                if (!line.startsWith("f ")) continue;
                parts = line.substring(2).split("\\s+");
                int[] face = new int[9];
                for (int i = 0; i < 3; ++i) {
                    String[] vertexData = parts[i].split("/");
                    face[i * 3] = Integer.parseInt(vertexData[0]);
                    face[i * 3 + 1] = Integer.parseInt(vertexData[1]);
                    face[i * 3 + 2] = Integer.parseInt(vertexData[2]);
                }
                model.faces.add(face);
                model.faceMaterials.add(currentMaterial);
            }
            System.out.println("Loaded OBJ model: " + model.vertices.size() + " vertices, " + model.texCoords.size() + " tex coords, " + model.normals.size() + " normals, " + model.faces.size() + " faces");
        }
        catch (IOException e) {
            System.err.println("Failed to load OBJ model: " + location);
            e.printStackTrace();
        }
        return model;
    }

    public static class OBJModel {
        public List<float[]> vertices = new ArrayList<float[]>();
        public List<float[]> normals = new ArrayList<float[]>();
        public List<float[]> texCoords = new ArrayList<float[]>();
        public List<int[]> faces = new ArrayList<int[]>();
        public List<String> faceMaterials = new ArrayList<String>();
        public Map<String, ResourceLocation> materials = new HashMap<String, ResourceLocation>();

        public void render(PoseStack poseStack, MultiBufferSource buffer, ResourceLocation defaultTexture, int packedLight, float r, float g, float b, float a) {
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
            HashMap materialGroups = new HashMap();
            for (int i = 0; i < this.faces.size(); ++i) {
                String material;
                String string = material = i < this.faceMaterials.size() ? this.faceMaterials.get(i) : "default";
                if (!materialGroups.containsKey(material)) {
                    materialGroups.put(material, new ArrayList());
                }
                ((List)materialGroups.get(material)).add(i);
            }
            for (Map.Entry entry : materialGroups.entrySet()) {
                String materialName = (String)entry.getKey();
                List faceIndices = (List)entry.getValue();
                ResourceLocation texture = this.materials.getOrDefault(materialName, defaultTexture);
                RenderType renderType = a < 1.0f ? TriangleRenderType.createTranslucentTriangles(texture) : TriangleRenderType.createTriangles(texture);
                VertexConsumer vertexConsumer = buffer.m_6299_(renderType);
                for (Integer faceIndex : faceIndices) {
                    int[] face = this.faces.get(faceIndex);
                    for (int i = 0; i < 3; ++i) {
                        int vertexIndex = face[i * 3] - 1;
                        int texIndex = face[i * 3 + 1] - 1;
                        int normalIndex = face[i * 3 + 2] - 1;
                        if (vertexIndex < 0 || vertexIndex >= this.vertices.size() || texIndex < 0 || texIndex >= this.texCoords.size() || normalIndex < 0 || normalIndex >= this.normals.size()) continue;
                        float[] vertex = this.vertices.get(vertexIndex);
                        float[] texCoord = this.texCoords.get(texIndex);
                        float[] normal = this.normals.get(normalIndex);
                        vertexConsumer.m_252986_(matrix4f, vertex[0], vertex[1], vertex[2]).m_85950_(r, g, b, a).m_7421_(texCoord[0], texCoord[1]).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, normal[0], normal[1], normal[2]).m_5752_();
                    }
                }
            }
        }

        public void renderWithDistortion(PoseStack poseStack, MultiBufferSource buffer, ResourceLocation defaultTexture, int packedLight, float r, float g, float b, float a, float time) {
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
            RenderType renderType = a < 1.0f ? TriangleRenderType.createTranslucentTriangles(defaultTexture) : TriangleRenderType.createTriangles(defaultTexture);
            VertexConsumer vertexConsumer = buffer.m_6299_(renderType);
            for (int faceIndex = 0; faceIndex < this.faces.size(); ++faceIndex) {
                int[] face = this.faces.get(faceIndex);
                for (int i = 0; i < 3; ++i) {
                    int vertexIndex = face[i * 3] - 1;
                    int texIndex = face[i * 3 + 1] - 1;
                    int normalIndex = face[i * 3 + 2] - 1;
                    if (vertexIndex < 0 || vertexIndex >= this.vertices.size() || texIndex < 0 || texIndex >= this.texCoords.size() || normalIndex < 0 || normalIndex >= this.normals.size()) continue;
                    float[] originalVertex = this.vertices.get(vertexIndex);
                    float[] distortedVertex = this.applyVertexDistortion(originalVertex, vertexIndex, time);
                    float[] texCoord = this.texCoords.get(texIndex);
                    float[] normal = this.normals.get(normalIndex);
                    vertexConsumer.m_252986_(matrix4f, distortedVertex[0], distortedVertex[1], distortedVertex[2]).m_85950_(r, g, b, a).m_7421_(texCoord[0], texCoord[1]).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, normal[0], normal[1], normal[2]).m_5752_();
                }
            }
        }

        private float[] applyVertexDistortion(float[] originalVertex, int vertexIndex, float time) {
            float vertexTime = time + (float)vertexIndex * 0.2f;
            float distortion1 = (float)(Math.sin((double)vertexTime * 1.5) * 0.08);
            float distortion2 = (float)(Math.sin((double)vertexTime * 2.3 + (double)vertexIndex * 0.3) * 0.05);
            float distortion3 = (float)(Math.sin((double)vertexTime * 0.8 + (double)vertexIndex * 0.6) * 0.03);
            float totalDistortion = distortion1 + distortion2 + distortion3;
            float[] result = new float[3];
            float magnitude = (float)Math.sqrt(originalVertex[0] * originalVertex[0] + originalVertex[1] * originalVertex[1] + originalVertex[2] * originalVertex[2]);
            if (magnitude > 0.0f) {
                float nx = originalVertex[0] / magnitude;
                float ny = originalVertex[1] / magnitude;
                float nz = originalVertex[2] / magnitude;
                result[0] = originalVertex[0] + nx * totalDistortion;
                result[1] = originalVertex[1] + ny * totalDistortion;
                result[2] = originalVertex[2] + nz * totalDistortion;
            } else {
                result[0] = originalVertex[0];
                result[1] = originalVertex[1];
                result[2] = originalVertex[2];
            }
            return result;
        }
    }
}

