/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client.network;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.TimeDilationData;
import com.hexvane.strangematter.block.ResearchMachineBlockEntity;
import com.hexvane.strangematter.client.CognitiveDisguiseRenderer;
import com.hexvane.strangematter.client.PlayerMorphRenderer;
import com.hexvane.strangematter.client.ResearchOverlay;
import com.hexvane.strangematter.client.screen.ResearchMachineScreen;
import com.hexvane.strangematter.client.screen.ResearchTabletScreen;
import com.hexvane.strangematter.entity.ThoughtwellEntity;
import com.hexvane.strangematter.research.ResearchData;
import com.hexvane.strangematter.research.ResearchType;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class ClientPacketHandlers {
    private static ResearchData clientResearchData = new ResearchData();

    private ClientPacketHandlers() {
    }

    public static void handleResearchSync(ResearchData data) {
        clientResearchData = data;
    }

    public static void handleResearchGain(ResearchType type, int amount) {
        clientResearchData.addResearchPoints(type, amount);
        ResearchOverlay.showResearchGain(type, amount);
    }

    public static ResearchData getClientResearchData() {
        return clientResearchData;
    }

    public static void handleEchoVacuumBeam(int playerId, boolean isActive) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return;
        }
        Entity entity = minecraft.f_91073_.m_6815_(playerId);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            StrangeMatterMod.setPlayerBeamState(player, isActive);
        }
    }

    public static void handleResearchMachineSync(BlockPos pos, ResearchMachineBlockEntity.MachineState state, String researchId, Set<ResearchType> activeTypes, float instabilityLevel, int researchTicks) {
        Screen screen;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return;
        }
        BlockEntity blockEntity = minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof ResearchMachineBlockEntity) {
            ResearchMachineBlockEntity researchMachine = (ResearchMachineBlockEntity)blockEntity;
            researchMachine.setClientState(state, researchId, activeTypes, instabilityLevel, researchTicks);
        }
        if ((screen = minecraft.f_91080_) instanceof ResearchMachineScreen) {
            ResearchMachineScreen screen2 = (ResearchMachineScreen)screen;
            screen2.handleStateSync(state, researchId, activeTypes, instabilityLevel, researchTicks);
        }
    }

    public static void handleTimeDilationSync(double slowdownFactor) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        player.getPersistentData().m_128347_("strangematter.time_dilation_factor", slowdownFactor);
        TimeDilationData.setPlayerSlowdownFactor(player.m_20148_(), slowdownFactor);
    }

    public static void handleGravitySync(double gravityForce) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        player.getPersistentData().m_128347_("strangematter.gravity_force", gravityForce);
    }

    public static void handleMobDisguiseSync(UUID mobUUID, boolean clearDisguise, String disguiseType, int disguiseDuration) {
        if (clearDisguise) {
            ThoughtwellEntity.removeDisguise(mobUUID);
            CognitiveDisguiseRenderer.cleanupDisguise(mobUUID);
        } else {
            ThoughtwellEntity.setDisguise(mobUUID, disguiseType, disguiseDuration);
        }
    }

    public static void cleanupMorphEntity(UUID playerUUID) {
        PlayerMorphRenderer.cleanupMorphEntity(playerUUID);
    }

    public static void openResearchTabletScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new ResearchTabletScreen());
    }
}

