/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.entity.WarpGateAnomalyEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class WarpGateAnomalyRenderer
extends EntityRenderer<WarpGateAnomalyEntity> {
    private static final ResourceLocation WARP_GATE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/entity/warp_gate_anomaly.png");
    private static final ResourceLocation VORTEX_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/entity/warp_gate_vortex.png");

    public WarpGateAnomalyRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(WarpGateAnomalyEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float baseSize;
        poseStack.m_85836_();
        float rotation = entity.getRotation();
        boolean isActive = entity.isActive();
        float size = baseSize = 2.0f;
        poseStack.m_85837_(0.0, 1.0, 0.0);
        poseStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
        this.renderWarpGatePortal(entity, poseStack, bufferSource, packedLight, size, rotation, isActive);
        this.renderVortexEffect(poseStack, bufferSource, packedLight, size, rotation);
        this.renderParticleCylinder(poseStack, bufferSource, packedLight, size);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    private void renderWarpGatePortal(WarpGateAnomalyEntity entity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float size, float rotation, boolean isActive) {
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation * 0.5f));
        poseStack.m_85837_(0.0, 0.0, (double)-0.01f);
        float baseAlpha = 0.8f;
        this.renderQuadWithWarbling(poseStack, vertexConsumer, size, size, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, baseAlpha);
        poseStack.m_85849_();
        if (isActive) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252403_.m_252977_(-rotation * 0.3f));
            poseStack.m_85837_(0.0, 0.0, (double)-0.05f);
            float innerAlpha = 0.6f;
            this.renderQuadWithWarbling(poseStack, vertexConsumer, size * 0.6f, size * 0.6f, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, innerAlpha);
            poseStack.m_85849_();
        }
    }

    private void renderVortexEffect(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float size, float rotation) {
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)VORTEX_TEXTURE));
        for (int i = 0; i < 3; ++i) {
            poseStack.m_85836_();
            float layerRotation = rotation + (float)i * 120.0f;
            float layerSize = size * (0.8f - (float)i * 0.2f);
            float baseLayerAlpha = 0.7f - (float)i * 0.15f;
            poseStack.m_85837_(0.0, 0.0, (double)(-0.02f - (float)i * 0.01f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(layerRotation));
            this.renderQuadWithWarbling(poseStack, vertexConsumer, layerSize, layerSize, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, baseLayerAlpha);
            poseStack.m_85849_();
        }
    }

    private void renderParticleCylinder(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float size) {
        int particleCount = 24;
        float cylinderRadius = size * 0.8f;
        float cylinderHeight = size * 2.0f;
        float time = (float)(System.currentTimeMillis() % 360000L) / 1000.0f;
        for (int i = 0; i < particleCount; ++i) {
            poseStack.m_85836_();
            float angle = (float)i * 360.0f / (float)particleCount + time * 10.0f;
            float x = (float)(Math.cos(Math.toRadians(angle)) * (double)cylinderRadius);
            float z = (float)(Math.sin(Math.toRadians(angle)) * (double)cylinderRadius);
            float heightPhase = (time * 2.0f + (float)i * 0.3f) % (cylinderHeight * 2.0f);
            float y = (heightPhase - cylinderHeight) * 0.5f;
            float fadeProgress = heightPhase / (cylinderHeight * 2.0f);
            float particleAlpha = (float)Math.sin((double)fadeProgress * Math.PI) * 0.6f;
            if (particleAlpha > 0.1f && y > -cylinderHeight * 0.5f) {
                poseStack.m_252880_(x, y, z);
                float rotation = time * 20.0f + (float)i * 15.0f;
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
                float particleSize = 0.08f + (float)(i % 4) * 0.03f;
                poseStack.m_85841_(particleSize, particleSize, particleSize);
                this.renderColoredParticle(poseStack, bufferSource, packedLight, 9055202, particleAlpha);
            }
            poseStack.m_85849_();
        }
    }

    private void renderColoredParticle(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int color, float alpha) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)new ResourceLocation("minecraft", "textures/block/white_wool.png")));
        float halfSize = 0.5f;
        vertexConsumer.m_252986_(matrix, -halfSize, -halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfSize, -halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfSize, halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -halfSize, halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -halfSize, halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfSize, halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfSize, -halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -halfSize, -halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
    }

    private void renderQuadWithWarbling(PoseStack poseStack, VertexConsumer vertexConsumer, float width, float height, float u0, float v0, float u1, float v1, int packedLight, float alpha) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float time = (float)(System.currentTimeMillis() % 360000L) / 1000.0f;
        float halfWidth = width / 2.0f;
        float halfHeight = height / 2.0f;
        float warblingStrength = 0.15f;
        float warbling1 = (float)Math.sin(time * 3.0f) * warblingStrength;
        float warbling2 = (float)Math.sin(time * 3.0f + 1.57f) * warblingStrength;
        float warbling3 = (float)Math.sin(time * 3.0f + 3.14f) * warblingStrength;
        float warbling4 = (float)Math.sin(time * 3.0f + 4.71f) * warblingStrength;
        vertexConsumer.m_252986_(matrix, -halfWidth + warbling1, -halfHeight + warbling1, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfWidth + warbling2, -halfHeight + warbling2, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfWidth + warbling3, halfHeight + warbling3, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -halfWidth + warbling4, halfHeight + warbling4, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    private void renderQuad(PoseStack poseStack, VertexConsumer vertexConsumer, float width, float height, float u0, float v0, float u1, float v1, int packedLight, float alpha) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float halfWidth = width / 2.0f;
        float halfHeight = height / 2.0f;
        vertexConsumer.m_252986_(matrix, -halfWidth, -halfHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfWidth, -halfHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfWidth, halfHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -halfWidth, halfHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(WarpGateAnomalyEntity entity) {
        return WARP_GATE_TEXTURE;
    }
}

