/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.client.obj.OBJLoader;
import com.hexvane.strangematter.entity.ThoughtwellEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class ThoughtwellRenderer
extends EntityRenderer<ThoughtwellEntity> {
    private static final ResourceLocation THOUGHTWELL_OBJ = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"models/entity/thoughtwell.obj");
    private static final ResourceLocation AURA_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/entity/thoughtwell_aura.png");
    private OBJLoader.OBJModel thoughtwellModel;

    public ThoughtwellRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
        try {
            this.thoughtwellModel = OBJLoader.loadModel(THOUGHTWELL_OBJ);
            System.out.println("Thoughtwell OBJ model loaded successfully with " + this.thoughtwellModel.faces.size() + " faces");
        }
        catch (Exception e) {
            System.err.println("Failed to load Thoughtwell OBJ model: " + e.getMessage());
            System.err.println("Make sure thoughtwell.obj and thoughtwell.mtl are in assets/strangematter/models/entity/");
            e.printStackTrace();
        }
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull ThoughtwellEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/entity/thoughtwell.png");
    }

    public void render(@Nonnull ThoughtwellEntity entity, float entityYaw, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        float rotation = entity.getRotation() + partialTicks * 0.2f;
        float pulseIntensity = entity.getPulseIntensity();
        this.renderThoughtwell(poseStack, buffer, packedLight, rotation, pulseIntensity, entity);
        this.renderCyanParticles(poseStack, buffer, packedLight, pulseIntensity, partialTicks, entity);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void renderThoughtwell(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float rotation, float pulseIntensity, ThoughtwellEntity entity) {
        if (this.thoughtwellModel == null) {
            this.renderFallbackModel(poseStack, buffer, packedLight, rotation, pulseIntensity, entity);
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        float scale = 2.2f + pulseIntensity * 0.2f;
        poseStack.m_85841_(scale, scale, scale);
        this.thoughtwellModel.render(poseStack, buffer, this.getTextureLocation(entity), packedLight, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    private void renderFallbackModel(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float rotation, float pulseIntensity, ThoughtwellEntity entity) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        float scale = 0.7f + pulseIntensity * 0.3f;
        poseStack.m_85841_(scale, scale, scale);
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        float size = 1.0f;
        float alpha = 0.8f;
        consumer.m_252986_(matrix4f, -size, -size, 0.0f).m_85950_(0.6f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix4f, size, -size, 0.0f).m_85950_(0.6f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix4f, size, size, 0.0f).m_85950_(0.6f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix4f, -size, size, 0.0f).m_85950_(0.6f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        poseStack.m_85849_();
    }

    private void renderCyanParticles(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float pulseIntensity, float partialTicks, ThoughtwellEntity entity) {
        float time = (float)(System.currentTimeMillis() % 360000L) / 1000.0f;
        int particleCount = 8;
        for (int i = 0; i < particleCount; ++i) {
            poseStack.m_85836_();
            float baseAngle = (float)i * 360.0f / (float)particleCount;
            float rotationOffset = time * 10.0f;
            float angle = (baseAngle + rotationOffset) % 360.0f;
            float radius = 1.5f;
            float height = (float)Math.sin(time * 1.0f + (float)i * 0.3f) * 0.4f;
            float x = (float)Math.cos(Math.toRadians(angle)) * radius;
            float z = (float)Math.sin(Math.toRadians(angle)) * radius;
            float y = height;
            poseStack.m_252880_(x, y, z);
            float particleScale = 1.0f;
            poseStack.m_85841_(particleScale, particleScale, particleScale);
            poseStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
            VertexConsumer consumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)AURA_TEXTURE));
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            float size = 0.3f;
            float alpha = 1.0f;
            float r = 0.0f;
            float g = 1.0f;
            float b = 1.0f;
            consumer.m_252986_(matrix4f, -size, -size, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix4f, size, -size, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix4f, size, size, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix4f, -size, size, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            poseStack.m_85849_();
        }
    }
}

