/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.client.obj.OBJLoader;
import com.hexvane.strangematter.entity.TemporalBloomEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class TemporalBloomRenderer
extends EntityRenderer<TemporalBloomEntity> {
    private static final ResourceLocation TEMPORAL_BLOOM_OBJ = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"models/entity/temporal_bloom.obj");
    private static final ResourceLocation AURA_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/entity/temporal_bloom_aura.png");
    private OBJLoader.OBJModel temporalBloomModel;

    public TemporalBloomRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
        try {
            this.temporalBloomModel = OBJLoader.loadModel(TEMPORAL_BLOOM_OBJ);
            System.out.println("Temporal Bloom OBJ model loaded successfully with " + this.temporalBloomModel.faces.size() + " faces");
        }
        catch (Exception e) {
            System.err.println("Failed to load Temporal Bloom OBJ model: " + e.getMessage());
            System.err.println("Make sure temporal_bloom.obj and temporal_bloom.mtl are in assets/strangematter/models/entity/");
            e.printStackTrace();
        }
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull TemporalBloomEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/entity/temporal_bloom.png");
    }

    public void render(@Nonnull TemporalBloomEntity entity, float entityYaw, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        float rotation = entity.getRotation() + partialTicks * 0.3f;
        float pulseIntensity = entity.getPulseIntensity();
        this.renderTemporalBloom(poseStack, buffer, packedLight, rotation, pulseIntensity, entity);
        this.renderFloatingParticles(poseStack, buffer, packedLight, pulseIntensity, partialTicks, entity);
        this.renderFloatingCrystals(poseStack, buffer, packedLight, pulseIntensity, partialTicks, entity);
        this.renderEnergyRipples(poseStack, buffer, packedLight, partialTicks, entity);
        this.renderGlowEffect(poseStack, buffer, packedLight, rotation, pulseIntensity, entity);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void renderTemporalBloom(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float rotation, float pulseIntensity, TemporalBloomEntity entity) {
        if (this.temporalBloomModel == null) {
            this.renderFallbackModel(poseStack, buffer, packedLight, rotation, pulseIntensity, entity);
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        float scale = 0.6f + pulseIntensity * 0.1f;
        poseStack.m_85841_(scale, scale, scale);
        float time = (float)(System.currentTimeMillis() % 10000L) / 1000.0f;
        this.temporalBloomModel.renderWithDistortion(poseStack, buffer, this.getTextureLocation(entity), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, time);
        poseStack.m_85849_();
    }

    private void renderFallbackModel(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float rotation, float pulseIntensity, TemporalBloomEntity entity) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        float scale = 0.6f + pulseIntensity * 0.3f;
        poseStack.m_85841_(scale, scale, scale);
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        float size = 1.0f;
        float alpha = 0.8f;
        consumer.m_252986_(matrix4f, -size, -size, 0.0f).m_85950_(1.0f, 0.8f, 1.0f, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix4f, size, -size, 0.0f).m_85950_(1.0f, 0.8f, 1.0f, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix4f, size, size, 0.0f).m_85950_(1.0f, 0.8f, 1.0f, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix4f, -size, size, 0.0f).m_85950_(1.0f, 0.8f, 1.0f, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        poseStack.m_85849_();
    }

    private void renderFloatingParticles(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float pulseIntensity, float partialTicks, TemporalBloomEntity entity) {
        poseStack.m_85836_();
        float time = (float)(System.currentTimeMillis() % 12000L) / 1000.0f;
        for (int i = 0; i < 8; ++i) {
            poseStack.m_85836_();
            float angle1 = (float)((double)i * Math.PI * 2.0 / 8.0 + (double)(time * 0.5f));
            float angle2 = (float)i * 0.7f + time * 0.3f;
            float radius = 2.0f + (float)Math.sin(time + (float)i) * 0.5f;
            float x = (float)(Math.cos(angle1) * Math.cos(angle2) * (double)radius);
            float y = (float)(Math.sin(angle2) * (double)radius) + (float)Math.sin(time * 2.0f + (float)i) * 0.3f;
            float z = (float)(Math.sin(angle1) * Math.cos(angle2) * (double)radius);
            poseStack.m_252880_(x, y, z);
            float particleScale = 0.3f + pulseIntensity * 0.2f;
            poseStack.m_85841_(particleScale, particleScale, particleScale);
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            float cameraYaw = camera.m_90590_();
            float cameraPitch = camera.m_90589_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-cameraYaw));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(cameraPitch));
            VertexConsumer consumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)AURA_TEXTURE));
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            float size = 0.5f;
            float alpha = 0.6f + (float)Math.sin(time * 3.0f + (float)i) * 0.3f;
            float r = 0.6f + (float)Math.sin(time + (float)i) * 0.2f;
            float g = 0.8f + (float)Math.cos(time + (float)i) * 0.1f;
            float b = 1.0f;
            consumer.m_252986_(matrix4f, -size, -size, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix4f, size, -size, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix4f, size, size, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix4f, -size, size, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private void renderFloatingCrystals(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float pulseIntensity, float partialTicks, TemporalBloomEntity entity) {
        poseStack.m_85836_();
        float time = ((float)System.currentTimeMillis() + partialTicks * 50.0f) * 0.001f;
        int crystalCount = 8;
        for (int i = 0; i < crystalCount; ++i) {
            poseStack.m_85836_();
            float angle = (float)(i * 2) * (float)Math.PI / (float)crystalCount + time * 0.5f;
            float radius = 2.0f + pulseIntensity * 0.5f;
            float height = (float)Math.sin(time * 2.0f + (float)i) * 0.5f;
            float x = (float)Math.cos(angle) * radius;
            float z = (float)Math.sin(angle) * radius;
            float y = height;
            poseStack.m_252880_(x, y, z);
            float crystalScale = 0.1f + pulseIntensity * 0.05f;
            poseStack.m_85841_(crystalScale, crystalScale, crystalScale);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private void renderEnergyRipples(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTicks, TemporalBloomEntity entity) {
        poseStack.m_85836_();
        float time = ((float)System.currentTimeMillis() + partialTicks * 50.0f) * 0.002f;
        int rippleCount = 3;
        for (int i = 0; i < rippleCount; ++i) {
            poseStack.m_85836_();
            float rippleTime = (time + (float)i * 0.5f) % 2.0f;
            float rippleScale = rippleTime * 3.0f;
            float alpha = (1.0f - rippleTime) * 0.4f;
            if (alpha > 0.0f) {
                poseStack.m_85841_(rippleScale, 0.1f, rippleScale);
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private void renderGlowEffect(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float rotation, float pulseIntensity, TemporalBloomEntity entity) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation * 0.5f));
        float glowScale = 0.8f + pulseIntensity * 0.4f;
        poseStack.m_85841_(glowScale, glowScale, glowScale);
        poseStack.m_85849_();
    }
}

