/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.block.StasisProjectorBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class StasisProjectorRenderer
implements BlockEntityRenderer<StasisProjectorBlockEntity> {
    private static final ResourceLocation FIELD_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/block/stasis_field.png");

    public StasisProjectorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(StasisProjectorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!blockEntity.isPowered()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.125, 0.5);
        this.renderStasisField(poseStack, bufferSource, packedLight, partialTick, blockEntity);
        poseStack.m_85849_();
    }

    private void renderStasisField(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float partialTick, StasisProjectorBlockEntity blockEntity) {
        float size = 1.0f;
        float time = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
        float pulse = (float)(0.5 + 0.5 * Math.sin((double)time * Math.PI * 2.0));
        float alpha = 0.5f + 0.3f * pulse;
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)FIELD_TEXTURE));
        poseStack.m_85836_();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        Vec3 blockPos = blockEntity.m_58899_().m_252807_();
        double dx = cameraPos.f_82479_ - blockPos.f_82479_;
        double dz = cameraPos.f_82481_ - blockPos.f_82481_;
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-yaw));
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        this.renderQuad(consumer, matrix, normal, size, packedLight, alpha, false, blockEntity);
        this.renderQuad(consumer, matrix, normal, size, packedLight, alpha, true, blockEntity);
        poseStack.m_85849_();
    }

    private void renderQuad(VertexConsumer consumer, Matrix4f matrix, Matrix3f normal, float size, int packedLight, float alpha, boolean reversed, StasisProjectorBlockEntity blockEntity) {
        int color = blockEntity.getFieldColor();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        if (!reversed) {
            consumer.m_252986_(matrix, -size, -size, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix, size, -size, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix, size, size, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix, -size, size, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        } else {
            consumer.m_252986_(matrix, -size, size, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
            consumer.m_252986_(matrix, size, size, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
            consumer.m_252986_(matrix, size, -size, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
            consumer.m_252986_(matrix, -size, -size, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        }
    }
}

