/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.block.RiftStabilizerBlockEntity;
import com.hexvane.strangematter.entity.EnergeticRiftEntity;
import com.hexvane.strangematter.util.AnomalyUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class RiftStabilizerRenderer
implements BlockEntityRenderer<RiftStabilizerBlockEntity> {
    public RiftStabilizerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(RiftStabilizerBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (!blockEntity.isGenerating()) {
            return;
        }
        EnergeticRiftEntity rift = AnomalyUtil.findNearestEnergeticRift(blockEntity.m_58904_(), blockEntity.m_58899_(), Config.riftStabilizerRadius).orElse(null);
        if (rift == null) {
            return;
        }
        Vec3 riftPos = rift.m_20182_().m_82520_(0.0, 0.5, 0.0);
        Vec3 stabilizerPos = blockEntity.getBeamTargetPos();
        double startX = 0.0;
        double startY = 0.0;
        double startZ = 0.0;
        double endX = riftPos.f_82479_ - stabilizerPos.f_82479_;
        double endY = riftPos.f_82480_ - stabilizerPos.f_82480_;
        double endZ = riftPos.f_82481_ - stabilizerPos.f_82481_;
        poseStack.m_85836_();
        poseStack.m_85837_(stabilizerPos.f_82479_ - (double)blockEntity.m_58899_().m_123341_(), stabilizerPos.f_82480_ - (double)blockEntity.m_58899_().m_123342_(), stabilizerPos.f_82481_ - (double)blockEntity.m_58899_().m_123343_());
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110502_());
        this.renderElectricityBeam(poseStack, consumer, packedLight, startX, startY, startZ, endX, endY, endZ);
        poseStack.m_85849_();
    }

    private void renderElectricityBeam(PoseStack poseStack, VertexConsumer consumer, int packedLight, double startX, double startY, double startZ, double endX, double endY, double endZ) {
        int segments = 16;
        double x = startX;
        double y = startY;
        double z = startZ;
        double dx = endX - startX;
        double dy = endY - startY;
        double dz = endZ - startZ;
        double totalDistance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (totalDistance < 0.1) {
            return;
        }
        dx /= totalDistance;
        dy /= totalDistance;
        dz /= totalDistance;
        float time = (float)(System.currentTimeMillis() % 2000L) / 2000.0f;
        for (int i = 0; i < segments; ++i) {
            float t = (float)i / (float)segments;
            float nextT = (float)(i + 1) / (float)segments;
            double nextX = startX + dx * ((double)nextT * totalDistance);
            double nextY = startY + dy * ((double)nextT * totalDistance);
            double nextZ = startZ + dz * ((double)nextT * totalDistance);
            if (i > 0) {
                float zigzagIntensity = 0.15f;
                double perpX = -dz;
                double perpY = 1.0;
                double perpZ = dx;
                double perpLength = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
                if (perpLength > 0.0) {
                    perpX /= perpLength;
                    perpY /= perpLength;
                    perpZ /= perpLength;
                }
                float zigzag1 = (float)Math.sin((double)(time * 30.0f) + (double)i * 2.5) * zigzagIntensity;
                float zigzag2 = (float)Math.sin((double)(time * 35.0f) + (double)i * 3.0) * zigzagIntensity * 0.8f;
                nextX += perpX * (double)zigzag1;
                nextY += perpY * (double)zigzag2;
                nextZ += perpZ * (double)zigzag1;
            }
            if (i > 0) {
                int color = 65535;
                float alpha = 0.8f;
                float thickness = 0.08f;
                this.renderSparkQuad3D(poseStack, consumer, packedLight, x, y, z, nextX, nextY, nextZ, color, alpha, thickness);
            }
            x = nextX;
            y = nextY;
            z = nextZ;
        }
    }

    private void renderSparkQuad3D(PoseStack poseStack, VertexConsumer consumer, int packedLight, double x1, double y1, double z1, double x2, double y2, double z2, int color, float alpha, float thickness) {
        double perpZ1;
        double perpY1;
        double perpX1;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = alpha;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (length < 0.001) {
            return;
        }
        dx /= length;
        dy /= length;
        dz /= length;
        if (Math.abs(dy) > 0.9) {
            perpX1 = thickness;
            perpY1 = 0.0;
            perpZ1 = 0.0;
        } else {
            perpX1 = -dz * (double)thickness;
            perpY1 = 0.0;
            perpZ1 = dx * (double)thickness;
        }
        double perpX2 = -perpX1;
        double perpY2 = -perpY1;
        double perpZ2 = -perpZ1;
        consumer.m_252986_(matrix, (float)(x1 + perpX1), (float)(y1 + perpY1), (float)(z1 + perpZ1)).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)dx, (float)dy, (float)dz).m_5752_();
        consumer.m_252986_(matrix, (float)(x2 + perpX1), (float)(y2 + perpY1), (float)(z2 + perpZ1)).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)dx, (float)dy, (float)dz).m_5752_();
        consumer.m_252986_(matrix, (float)(x2 + perpX2), (float)(y2 + perpY2), (float)(z2 + perpZ2)).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)dx, (float)dy, (float)dz).m_5752_();
        consumer.m_252986_(matrix, (float)(x1 + perpX2), (float)(y1 + perpY2), (float)(z1 + perpZ2)).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)dx, (float)dy, (float)dz).m_5752_();
        consumer.m_252986_(matrix, (float)(x1 + perpX2), (float)(y1 + perpY2), (float)(z1 + perpZ2)).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)(-dx), (float)(-dy), (float)(-dz)).m_5752_();
        consumer.m_252986_(matrix, (float)(x2 + perpX2), (float)(y2 + perpY2), (float)(z2 + perpZ2)).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)(-dx), (float)(-dy), (float)(-dz)).m_5752_();
        consumer.m_252986_(matrix, (float)(x2 + perpX1), (float)(y2 + perpY1), (float)(z2 + perpZ1)).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)(-dx), (float)(-dy), (float)(-dz)).m_5752_();
        consumer.m_252986_(matrix, (float)(x1 + perpX1), (float)(y1 + perpY1), (float)(z1 + perpZ1)).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)(-dx), (float)(-dy), (float)(-dz)).m_5752_();
    }
}

