/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.block.ResonantConduitBlock;
import com.hexvane.strangematter.block.ResonantConduitBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ResonantConduitRenderer
implements BlockEntityRenderer<ResonantConduitBlockEntity> {
    private static final ResourceLocation CONDUIT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/block/resonant_conduit.png");

    public ResonantConduitRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull ResonantConduitBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        if (blockEntity == null || blockEntity.m_58904_() == null) {
            return;
        }
        BlockState blockState = blockEntity.m_58904_().m_8055_(blockEntity.m_58899_());
        Block block = blockState.m_60734_();
        if (!(block instanceof ResonantConduitBlock)) {
            return;
        }
        ResonantConduitBlock conduitBlock = (ResonantConduitBlock)block;
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)CONDUIT_TEXTURE));
        List<Direction> connectedDirections = this.getConnectedDirections(conduitBlock, blockState);
        boolean shouldRenderJoint = this.shouldRenderJoint(connectedDirections);
        if (shouldRenderJoint) {
            this.renderJoint(poseStack, buffer, combinedLight, combinedOverlay);
        }
        for (Direction direction : connectedDirections) {
            this.renderConnectionTube(poseStack, buffer, direction, shouldRenderJoint, combinedLight, combinedOverlay);
        }
    }

    private List<Direction> getConnectedDirections(ResonantConduitBlock conduitBlock, BlockState blockState) {
        ArrayList<Direction> connected = new ArrayList<Direction>();
        for (Direction direction : Direction.values()) {
            if (!conduitBlock.isConnected(blockState, direction)) continue;
            connected.add(direction);
        }
        return connected;
    }

    private boolean shouldRenderJoint(List<Direction> connectedDirections) {
        int connectionCount = connectedDirections.size();
        if (connectionCount == 0 || connectionCount == 1) {
            return true;
        }
        if (connectionCount == 2) {
            Direction dir2;
            Direction dir1 = connectedDirections.get(0);
            return dir1 != (dir2 = connectedDirections.get(1)).m_122424_();
        }
        return true;
    }

    private void renderJoint(PoseStack poseStack, VertexConsumer buffer, int combinedLight, int combinedOverlay) {
        poseStack.m_85836_();
        float jointSize = 0.25f;
        float offset = (1.0f - jointSize) / 2.0f;
        poseStack.m_252880_(offset, offset, offset);
        poseStack.m_85841_(jointSize, jointSize, jointSize);
        this.renderCubeWithUVs(poseStack, buffer, 0.15625f, 0.3125f, 0.21875f, 0.21875f, combinedLight, combinedOverlay, null);
        poseStack.m_85849_();
    }

    private void renderConnectionTube(PoseStack poseStack, VertexConsumer buffer, Direction direction, boolean hasJoint, int combinedLight, int combinedOverlay) {
        float vSize;
        float uSize;
        float vStart;
        float uStart;
        poseStack.m_85836_();
        float tubeWidth = 0.125f;
        float tubeLength = hasJoint ? 0.5f : 1.0f;
        float tubeStart = 0.4375f;
        switch (direction) {
            case NORTH: {
                poseStack.m_252880_(tubeStart, tubeStart, 0.0f);
                poseStack.m_85841_(tubeWidth, tubeWidth, tubeLength);
                break;
            }
            case SOUTH: {
                poseStack.m_252880_(tubeStart, tubeStart, 1.0f - tubeLength);
                poseStack.m_85841_(tubeWidth, tubeWidth, tubeLength);
                break;
            }
            case EAST: {
                poseStack.m_252880_(1.0f - tubeLength, tubeStart, tubeStart);
                poseStack.m_85841_(tubeLength, tubeWidth, tubeWidth);
                break;
            }
            case WEST: {
                poseStack.m_252880_(0.0f, tubeStart, tubeStart);
                poseStack.m_85841_(tubeLength, tubeWidth, tubeWidth);
                break;
            }
            case UP: {
                poseStack.m_252880_(tubeStart, 1.0f - tubeLength, tubeStart);
                poseStack.m_85841_(tubeWidth, tubeLength, tubeWidth);
                break;
            }
            case DOWN: {
                poseStack.m_252880_(tubeStart, 0.0f, tubeStart);
                poseStack.m_85841_(tubeWidth, tubeLength, tubeWidth);
            }
        }
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            uStart = 0.0f;
            vStart = 0.0f;
            uSize = 0.5f;
            vSize = 0.15625f;
        } else if (direction == Direction.UP || direction == Direction.DOWN) {
            uStart = 0.0f;
            vStart = 0.15625f;
            uSize = 0.15625f;
            vSize = 0.5f;
        } else {
            uStart = 0.0f;
            vStart = 0.0f;
            uSize = 0.5f;
            vSize = 0.15625f;
        }
        this.renderCubeWithUVs(poseStack, buffer, uStart, vStart, uSize, vSize, combinedLight, combinedOverlay, direction);
        poseStack.m_85849_();
    }

    private void renderCubeWithUVs(PoseStack poseStack, VertexConsumer buffer, float uStart, float vStart, float uSize, float vSize, int combinedLight, int combinedOverlay, Direction direction) {
        float minU = uStart;
        float maxU = uStart + uSize;
        float minV = vStart;
        float maxV = vStart + vSize;
        float topBottomMinU = 0.0f;
        float topBottomMaxU = 0.15625f;
        float topBottomMinV = 0.15625f;
        float topBottomMaxV = 0.65625f;
        this.addVertex(buffer, poseStack, 0.0f, 0.0f, 1.0f, minU, minV, combinedLight, combinedOverlay);
        this.addVertex(buffer, poseStack, 1.0f, 0.0f, 1.0f, maxU, minV, combinedLight, combinedOverlay);
        this.addVertex(buffer, poseStack, 1.0f, 1.0f, 1.0f, maxU, maxV, combinedLight, combinedOverlay);
        this.addVertex(buffer, poseStack, 0.0f, 1.0f, 1.0f, minU, maxV, combinedLight, combinedOverlay);
        this.addVertex(buffer, poseStack, 1.0f, 0.0f, 0.0f, minU, minV, combinedLight, combinedOverlay);
        this.addVertex(buffer, poseStack, 0.0f, 0.0f, 0.0f, maxU, minV, combinedLight, combinedOverlay);
        this.addVertex(buffer, poseStack, 0.0f, 1.0f, 0.0f, maxU, maxV, combinedLight, combinedOverlay);
        this.addVertex(buffer, poseStack, 1.0f, 1.0f, 0.0f, minU, maxV, combinedLight, combinedOverlay);
        this.addVertex(buffer, poseStack, 0.0f, 0.0f, 0.0f, minU, minV, combinedLight, combinedOverlay);
        this.addVertex(buffer, poseStack, 0.0f, 0.0f, 1.0f, maxU, minV, combinedLight, combinedOverlay);
        this.addVertex(buffer, poseStack, 0.0f, 1.0f, 1.0f, maxU, maxV, combinedLight, combinedOverlay);
        this.addVertex(buffer, poseStack, 0.0f, 1.0f, 0.0f, minU, maxV, combinedLight, combinedOverlay);
        this.addVertex(buffer, poseStack, 1.0f, 0.0f, 1.0f, minU, minV, combinedLight, combinedOverlay);
        this.addVertex(buffer, poseStack, 1.0f, 0.0f, 0.0f, maxU, minV, combinedLight, combinedOverlay);
        this.addVertex(buffer, poseStack, 1.0f, 1.0f, 0.0f, maxU, maxV, combinedLight, combinedOverlay);
        this.addVertex(buffer, poseStack, 1.0f, 1.0f, 1.0f, minU, maxV, combinedLight, combinedOverlay);
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            this.addVertex(buffer, poseStack, 0.0f, 1.0f, 1.0f, topBottomMinU, topBottomMinV, combinedLight, combinedOverlay);
            this.addVertex(buffer, poseStack, 1.0f, 1.0f, 1.0f, topBottomMaxU, topBottomMinV, combinedLight, combinedOverlay);
            this.addVertex(buffer, poseStack, 1.0f, 1.0f, 0.0f, topBottomMaxU, topBottomMaxV, combinedLight, combinedOverlay);
            this.addVertex(buffer, poseStack, 0.0f, 1.0f, 0.0f, topBottomMinU, topBottomMaxV, combinedLight, combinedOverlay);
        } else {
            this.addVertex(buffer, poseStack, 0.0f, 1.0f, 1.0f, minU, minV, combinedLight, combinedOverlay);
            this.addVertex(buffer, poseStack, 1.0f, 1.0f, 1.0f, maxU, minV, combinedLight, combinedOverlay);
            this.addVertex(buffer, poseStack, 1.0f, 1.0f, 0.0f, maxU, maxV, combinedLight, combinedOverlay);
            this.addVertex(buffer, poseStack, 0.0f, 1.0f, 0.0f, minU, maxV, combinedLight, combinedOverlay);
        }
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            this.addVertex(buffer, poseStack, 0.0f, 0.0f, 0.0f, topBottomMinU, topBottomMinV, combinedLight, combinedOverlay);
            this.addVertex(buffer, poseStack, 1.0f, 0.0f, 0.0f, topBottomMaxU, topBottomMinV, combinedLight, combinedOverlay);
            this.addVertex(buffer, poseStack, 1.0f, 0.0f, 1.0f, topBottomMaxU, topBottomMaxV, combinedLight, combinedOverlay);
            this.addVertex(buffer, poseStack, 0.0f, 0.0f, 1.0f, topBottomMinU, topBottomMaxV, combinedLight, combinedOverlay);
        } else {
            this.addVertex(buffer, poseStack, 0.0f, 0.0f, 0.0f, minU, minV, combinedLight, combinedOverlay);
            this.addVertex(buffer, poseStack, 1.0f, 0.0f, 0.0f, maxU, minV, combinedLight, combinedOverlay);
            this.addVertex(buffer, poseStack, 1.0f, 0.0f, 1.0f, maxU, maxV, combinedLight, combinedOverlay);
            this.addVertex(buffer, poseStack, 0.0f, 0.0f, 1.0f, minU, maxV, combinedLight, combinedOverlay);
        }
    }

    private void addVertex(VertexConsumer buffer, PoseStack poseStack, float x, float y, float z, float u, float v, int combinedLight, int combinedOverlay) {
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(combinedOverlay).m_85969_(combinedLight).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public int m_142163_() {
        return 64;
    }
}

