/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.block.ResonantBurnerBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class ResonantBurnerRenderer
implements BlockEntityRenderer<ResonantBurnerBlockEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/block/resonant_burner.png");

    public ResonantBurnerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public ResourceLocation getTextureLocation(ResonantBurnerBlockEntity blockEntity) {
        return TEXTURE;
    }

    public void render(ResonantBurnerBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (blockEntity.getBurnTime() > 0 && blockEntity.m_58904_() != null && blockEntity.m_58904_().f_46443_) {
            this.renderFlameEffects(blockEntity, poseStack, buffer, packedLight, partialTicks);
        }
    }

    private void renderFlameEffects(ResonantBurnerBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110463_());
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.1, 0.5);
        float burnProgress = blockEntity.getBurnProgress();
        float scale = 0.3f + burnProgress * 0.4f;
        poseStack.m_85841_(scale, scale, scale);
        float time = (float)(System.currentTimeMillis() % 1000L) / 1000.0f;
        float animation = (float)Math.sin((double)time * Math.PI * 2.0) * 0.1f;
        poseStack.m_252880_(0.0f, animation, 0.0f);
        poseStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float r = 1.0f;
        float g = 0.5f + burnProgress * 0.3f;
        float b = 0.1f;
        float a = 0.8f;
        consumer.m_252986_(matrix, -0.5f, -0.5f, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, 0.5f, -0.5f, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, 0.5f, 0.5f, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, -0.5f, 0.5f, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        poseStack.m_85849_();
    }
}

