/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.block.ResonanceCondenserBlockEntity;
import com.hexvane.strangematter.entity.BaseAnomalyEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;

public class ResonanceCondenserRenderer
implements BlockEntityRenderer<ResonanceCondenserBlockEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/block/resonance_condenser.png");

    public ResonanceCondenserRenderer(BlockEntityRendererProvider.Context context) {
    }

    public ResourceLocation getTextureLocation(ResonanceCondenserBlockEntity blockEntity) {
        return TEXTURE;
    }

    public void render(ResonanceCondenserBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        this.renderGlassTube(blockEntity, poseStack, buffer, packedLight, packedOverlay);
        if (blockEntity.m_58904_() != null && blockEntity.m_58904_().f_46443_) {
            this.renderEnergyArcs(blockEntity, poseStack, buffer, packedLight, partialTicks);
        }
    }

    private void renderGlassTube(ResonanceCondenserBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_234338_((ResourceLocation)TEXTURE));
        double minX = 0.3125;
        double minY = 1.1875;
        double minZ = 0.3125;
        double maxX = 0.6875;
        double maxY = 1.9375;
        double maxZ = 0.6875;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 0.6f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        consumer.m_252986_(matrix, (float)minX, (float)minY, (float)minZ).m_85950_(r, g, b, a).m_7421_(0.4375f, 0.5f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)maxX, (float)minY, (float)minZ).m_85950_(r, g, b, a).m_7421_(0.53125f, 0.5f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)maxX, (float)maxY, (float)minZ).m_85950_(r, g, b, a).m_7421_(0.53125f, 0.6875f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)minX, (float)maxY, (float)minZ).m_85950_(r, g, b, a).m_7421_(0.4375f, 0.6875f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)maxX, (float)minY, (float)minZ).m_85950_(r, g, b, a).m_7421_(0.53125f, 0.4375f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)maxX, (float)minY, (float)maxZ).m_85950_(r, g, b, a).m_7421_(0.625f, 0.4375f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)maxX, (float)maxY, (float)maxZ).m_85950_(r, g, b, a).m_7421_(0.625f, 0.625f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)maxX, (float)maxY, (float)minZ).m_85950_(r, g, b, a).m_7421_(0.53125f, 0.625f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)maxX, (float)minY, (float)maxZ).m_85950_(r, g, b, a).m_7421_(0.625f, 0.4375f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)minX, (float)minY, (float)maxZ).m_85950_(r, g, b, a).m_7421_(0.71875f, 0.4375f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)minX, (float)maxY, (float)maxZ).m_85950_(r, g, b, a).m_7421_(0.71875f, 0.625f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)maxX, (float)maxY, (float)maxZ).m_85950_(r, g, b, a).m_7421_(0.625f, 0.625f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)minX, (float)minY, (float)maxZ).m_85950_(r, g, b, a).m_7421_(0.53125f, 0.625f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)minX, (float)minY, (float)minZ).m_85950_(r, g, b, a).m_7421_(0.625f, 0.625f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)minX, (float)maxY, (float)minZ).m_85950_(r, g, b, a).m_7421_(0.625f, 0.8125f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)minX, (float)maxY, (float)maxZ).m_85950_(r, g, b, a).m_7421_(0.53125f, 0.8125f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)minX, (float)maxY, (float)minZ).m_85950_(r, g, b, a).m_7421_(0.71875f, 0.71875f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)maxX, (float)maxY, (float)minZ).m_85950_(r, g, b, a).m_7421_(0.625f, 0.71875f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)maxX, (float)maxY, (float)maxZ).m_85950_(r, g, b, a).m_7421_(0.625f, 0.625f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)minX, (float)maxY, (float)maxZ).m_85950_(r, g, b, a).m_7421_(0.71875f, 0.625f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)minX, (float)minY, (float)maxZ).m_85950_(r, g, b, a).m_7421_(0.34375f, 0.6875f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)maxX, (float)minY, (float)maxZ).m_85950_(r, g, b, a).m_7421_(0.25f, 0.6875f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)maxX, (float)minY, (float)minZ).m_85950_(r, g, b, a).m_7421_(0.25f, 0.78125f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)minX, (float)minY, (float)minZ).m_85950_(r, g, b, a).m_7421_(0.34375f, 0.78125f).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    private void renderEnergyArcs(ResonanceCondenserBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110502_());
        BlockPos pos = blockEntity.m_58899_();
        double condenserX = 0.5;
        double condenserY = 1.5;
        double condenserZ = 0.5;
        AABB searchBox = new AABB(pos).m_82400_(10.0);
        List entitiesInRange = blockEntity.m_58904_().m_45933_(null, searchBox);
        for (Entity anomaly : entitiesInRange) {
            if (!(anomaly instanceof BaseAnomalyEntity)) continue;
            double anomalyX = anomaly.m_20185_() - (double)pos.m_123341_();
            double anomalyY = anomaly.m_20186_() + (double)anomaly.m_20206_() / 2.0 - (double)pos.m_123342_() - 1.0;
            double anomalyZ = anomaly.m_20189_() - (double)pos.m_123343_();
            double distance = Math.sqrt(Math.pow(anomalyX - condenserX, 2.0) + Math.pow(anomalyY - condenserY, 2.0) + Math.pow(anomalyZ - condenserZ, 2.0));
            if (!(distance <= 10.0)) continue;
            this.renderSineWaveArc(poseStack, consumer, packedLight, condenserX, condenserY, condenserZ, anomalyX, anomalyY, anomalyZ, partialTicks);
        }
    }

    private void renderSineWaveArc(PoseStack poseStack, VertexConsumer consumer, int packedLight, double startX, double startY, double startZ, double endX, double endY, double endZ, float partialTicks) {
        double perpZ;
        double perpY;
        double perpX;
        double dx = endX - startX;
        double dy = endY - startY;
        double dz = endZ - startZ;
        double totalDistance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (totalDistance < 0.1) {
            return;
        }
        dx /= totalDistance;
        dy /= totalDistance;
        dz /= totalDistance;
        if (Math.abs(dy) > 0.9) {
            perpX = 1.0;
            perpY = 0.0;
            perpZ = 0.0;
        } else {
            perpX = -dz;
            perpY = 0.0;
            perpZ = dx;
        }
        double perpLength = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
        if (perpLength > 0.0) {
            perpX /= perpLength;
            perpY /= perpLength;
            perpZ /= perpLength;
        }
        int segments = 16;
        double amplitude = 1.0;
        double frequency = 2.0;
        float time = (float)(System.currentTimeMillis() % 2000L) / 2000.0f;
        double x = startX;
        double y = startY;
        double z = startZ;
        for (int i = 0; i < segments; ++i) {
            float t = (float)i / (float)segments;
            float nextT = (float)(i + 1) / (float)segments;
            double nextX = startX + dx * ((double)nextT * totalDistance);
            double nextY = startY + dy * ((double)nextT * totalDistance);
            double nextZ = startZ + dz * ((double)nextT * totalDistance);
            if (i > 0) {
                double sineOffset = Math.sin((double)t * frequency * Math.PI + (double)(time * 2.0f) * Math.PI) * amplitude * (1.0 - (double)t * 0.5);
                nextX += perpX * sineOffset;
                nextY += perpY * sineOffset;
                nextZ += perpZ * sineOffset;
            }
            if (i > 0) {
                int color = 65535;
                float alpha = 1.0f * (1.0f - t * 0.2f);
                float thickness = 0.15f * (1.0f - t * 0.3f);
                this.renderArcSegment(poseStack, consumer, packedLight, x, y, z, nextX, nextY, nextZ, color, alpha, thickness);
            }
            x = nextX;
            y = nextY;
            z = nextZ;
        }
    }

    private void renderArcSegment(PoseStack poseStack, VertexConsumer consumer, int packedLight, double x1, double y1, double z1, double x2, double y2, double z2, int color, float alpha, float thickness) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = alpha;
        double distanceFromAnomaly = Math.sqrt(x2 * x2 + y2 * y2 + z2 * z2);
        double maxDistance = 10.0;
        double fadeFactor = Math.max(0.1, 1.0 - distanceFromAnomaly / maxDistance);
        float finalAlpha = a * (float)fadeFactor;
        float finalThickness = thickness * (float)fadeFactor;
        double centerX = (x1 + x2) / 2.0;
        double centerY = (y1 + y2) / 2.0;
        double centerZ = (z1 + z2) / 2.0;
        poseStack.m_85836_();
        poseStack.m_85837_(centerX, centerY, centerZ);
        poseStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        double halfThickness = (double)finalThickness / 2.0;
        consumer.m_252986_(matrix, (float)(-halfThickness), (float)(-halfThickness), 0.0f).m_85950_(r, g, b, finalAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)halfThickness, (float)(-halfThickness), 0.0f).m_85950_(r, g, b, finalAlpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)halfThickness, (float)halfThickness, 0.0f).m_85950_(r, g, b, finalAlpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, (float)(-halfThickness), (float)halfThickness, 0.0f).m_85950_(r, g, b, finalAlpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        poseStack.m_85849_();
    }
}

