/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.research.ResearchType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class ResearchOverlay {
    private static final List<ResearchNotification> notifications = new ArrayList<ResearchNotification>();
    private static final int NOTIFICATION_DURATION = 100;
    private static final int FADE_DURATION = 20;
    private static long lastTickTime = 0L;

    public static void showResearchGain(ResearchType type, int amount) {
        notifications.add(new ResearchNotification(type, amount, 100));
    }

    public static void render(GuiGraphics guiGraphics, float partialTick) {
        if (notifications.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastTickTime >= 50L) {
            lastTickTime = currentTime;
            Iterator<ResearchNotification> iterator = notifications.iterator();
            while (iterator.hasNext()) {
                ResearchNotification notification = iterator.next();
                notification.tick();
                if (!notification.isExpired()) continue;
                iterator.remove();
            }
        }
        Minecraft minecraft = Minecraft.m_91087_();
        int screenWidth = minecraft.m_91268_().m_85445_();
        int startX = screenWidth - 120;
        int startY = 20;
        Iterator<ResearchNotification> renderIterator = notifications.iterator();
        int index = 0;
        while (renderIterator.hasNext()) {
            ResearchNotification notification = renderIterator.next();
            int x = startX;
            int y = startY + index * 25;
            float alpha = notification.getAlpha();
            if (alpha <= 0.0f) continue;
            ResourceLocation icon = notification.getResearchType().getIconResourceLocation();
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
            guiGraphics.m_280163_(icon, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            String text = "+" + notification.getAmount();
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
            guiGraphics.m_280488_(minecraft.f_91062_, text, x + 20, y + 4, 0xFFFFFF);
            ++index;
        }
    }

    private static class ResearchNotification {
        private final ResearchType researchType;
        private final int amount;
        private int ticksRemaining;

        public ResearchNotification(ResearchType researchType, int amount, int duration) {
            this.researchType = researchType;
            this.amount = amount;
            this.ticksRemaining = duration;
        }

        public void tick() {
            --this.ticksRemaining;
        }

        public boolean isExpired() {
            return this.ticksRemaining <= 0;
        }

        public float getAlpha() {
            if (this.ticksRemaining > 20) {
                return 1.0f;
            }
            return (float)this.ticksRemaining / 20.0f;
        }

        public ResearchType getResearchType() {
            return this.researchType;
        }

        public int getAmount() {
            return this.amount;
        }
    }
}

