/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.block.ResearchMachineBlockEntity;
import com.hexvane.strangematter.client.obj.OBJLoader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ResearchMachineRenderer
implements BlockEntityRenderer<ResearchMachineBlockEntity> {
    private static final ResourceLocation MACHINE_OBJ = new ResourceLocation("strangematter", "models/block/research_machine.obj");
    private static final ResourceLocation MACHINE_TEXTURE = new ResourceLocation("strangematter", "textures/block/research_machine.png");
    private OBJLoader.OBJModel machineModel;

    public ResearchMachineRenderer(BlockEntityRendererProvider.Context context) {
        try {
            this.machineModel = OBJLoader.loadModel(MACHINE_OBJ, true);
            System.out.println("Research Machine OBJ model loaded successfully with " + this.machineModel.faces.size() + " faces");
        }
        catch (Exception e) {
            System.err.println("Failed to load Research Machine OBJ model: " + e.getMessage());
            e.printStackTrace();
            this.machineModel = null;
        }
    }

    public void render(ResearchMachineBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (this.machineModel == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        switch (facing) {
            case NORTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
        }
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        this.machineModel.render(poseStack, bufferSource, MACHINE_TEXTURE, packedLight, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

