/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.morph.PlayerMorphData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public class PlayerMorphRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<UUID, Entity> morphEntityCache = new ConcurrentHashMap<UUID, Entity>();
    private static final ThreadLocal<Boolean> isRendering = ThreadLocal.withInitial(() -> false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean renderPlayerAsMorph(Player player, EntityRenderDispatcher dispatcher, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        EntityType<?> morphType;
        try {
            if (isRendering.get().booleanValue()) {
                return false;
            }
            if (!PlayerMorphData.isMorphed(player.m_20148_())) {
                return false;
            }
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn("PlayerMorphData class not available, skipping morph rendering: {}", (Object)e.getMessage());
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error checking morph status, skipping morph rendering", (Throwable)e);
            return false;
        }
        try {
            morphType = PlayerMorphData.getMorphEntityTypeObj(player.m_20148_());
            if (morphType == null) {
                return false;
            }
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn("PlayerMorphData class not available for morph type lookup: {}", (Object)e.getMessage());
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error getting morph type, skipping morph rendering", (Throwable)e);
            return false;
        }
        Entity morphEntity = morphEntityCache.get(player.m_20148_());
        if (morphEntity == null || !morphEntity.m_6095_().equals(morphType)) {
            if (morphEntity != null) {
                morphEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                morphEntityCache.remove(player.m_20148_());
            }
            if ((morphEntity = morphType.m_20615_(player.m_9236_())) == null) {
                try {
                    PlayerMorphData.clearMorph(player.m_20148_());
                }
                catch (NoClassDefFoundError e) {
                    LOGGER.warn("PlayerMorphData class not available for clearing morph: {}", (Object)e.getMessage());
                }
                catch (Exception e) {
                    LOGGER.error("Error clearing morph data", (Throwable)e);
                }
                return false;
            }
            morphEntityCache.put(player.m_20148_(), morphEntity);
        }
        PlayerMorphRenderer.updateMorphEntity(morphEntity, player);
        try {
            isRendering.set(true);
            EntityRenderer morphRenderer = dispatcher.m_114382_(morphEntity);
            if (morphRenderer != null) {
                morphRenderer.m_7392_(morphEntity, player.m_146908_(), partialTicks, poseStack, buffer, packedLight);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to render morph: {}", (Object)e.getMessage());
            try {
                PlayerMorphData.clearMorph(player.m_20148_());
            }
            catch (NoClassDefFoundError classError) {
                LOGGER.warn("PlayerMorphData class not available for clearing morph after error: {}", (Object)classError.getMessage());
            }
            catch (Exception clearError) {
                LOGGER.error("Error clearing morph data after render failure", (Throwable)clearError);
            }
            Entity cachedEntity = morphEntityCache.remove(player.m_20148_());
            if (cachedEntity != null) {
                cachedEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        finally {
            isRendering.set(false);
        }
        return false;
    }

    private static void updateMorphEntity(Entity morphEntity, Player player) {
        morphEntity.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        morphEntity.f_19854_ = player.f_19854_;
        morphEntity.f_19855_ = player.f_19855_;
        morphEntity.f_19856_ = player.f_19856_;
        morphEntity.m_146922_(player.m_146908_());
        morphEntity.m_146926_(player.m_146909_());
        morphEntity.f_19859_ = player.f_19859_;
        morphEntity.f_19860_ = player.f_19860_;
        morphEntity.m_20256_(player.m_20184_());
        if (morphEntity instanceof LivingEntity) {
            LivingEntity morphLiving = (LivingEntity)morphEntity;
            morphLiving.m_7910_(player.m_6113_());
            morphLiving.m_20260_(player.m_6144_());
            morphLiving.m_6858_(player.m_20142_());
            morphLiving.m_6853_(player.m_20096_());
            morphLiving.m_20124_(player.m_20089_());
            morphLiving.f_20883_ = player.f_20883_;
            morphLiving.f_20884_ = player.f_20884_;
            morphLiving.f_20885_ = player.f_20885_;
            morphLiving.f_20886_ = player.f_20886_;
            morphLiving.f_20900_ = player.f_20900_;
            morphLiving.f_20901_ = player.f_20901_;
            morphLiving.f_20902_ = player.f_20902_;
            morphLiving.m_20282_(player.m_6069_());
            morphLiving.f_267362_.m_267771_(player.f_267362_.m_267731_());
            float currentPos = morphLiving.f_267362_.m_267756_();
            float targetPos = player.f_267362_.m_267756_();
            float posDiff = targetPos - currentPos;
            if (Math.abs(posDiff) > 0.001f) {
                morphLiving.f_267362_.m_267566_(morphLiving.f_267362_.m_267731_(), 0.4f);
            }
        }
    }

    public static void cleanupMorphEntity(UUID playerUUID) {
        Entity cachedEntity = morphEntityCache.remove(playerUUID);
        if (cachedEntity != null) {
            cachedEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public static void cleanupAll() {
        for (Entity entity : morphEntityCache.values()) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        morphEntityCache.clear();
    }
}

