/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.entity.MiniWarpGateEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MiniWarpGateRenderer
extends EntityRenderer<MiniWarpGateEntity> {
    private static final ResourceLocation MINI_WARP_GATE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/entity/warp_gate_anomaly.png");
    private static final ResourceLocation VORTEX_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/entity/warp_gate_vortex.png");

    public MiniWarpGateRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(MiniWarpGateEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float baseSize;
        poseStack.m_85836_();
        float rotation = entity.getRotation();
        boolean isActive = entity.isActive();
        boolean isOnCooldown = entity.isOnCooldown();
        float cooldownProgress = entity.getCooldownProgress();
        float size = baseSize = 1.0f;
        if (isOnCooldown) {
            float shrinkFactor = 0.2f + 0.8f * cooldownProgress;
            size *= shrinkFactor;
        }
        poseStack.m_85837_(0.0, 1.0, 0.0);
        poseStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
        this.renderMiniWarpGatePortal(entity, poseStack, bufferSource, packedLight, size, rotation, isActive, isOnCooldown, cooldownProgress);
        this.renderVortexEffect(poseStack, bufferSource, packedLight, size, rotation, isOnCooldown, cooldownProgress);
        this.renderParticleCylinder(entity, poseStack, bufferSource, packedLight, size, isOnCooldown, cooldownProgress);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    private void renderMiniWarpGatePortal(MiniWarpGateEntity entity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float size, float rotation, boolean isActive, boolean isOnCooldown, float cooldownProgress) {
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation * 0.5f));
        poseStack.m_85837_(0.0, 0.0, (double)-0.01f);
        float baseAlpha = 0.8f;
        if (isOnCooldown) {
            baseAlpha *= 0.1f + 0.9f * cooldownProgress;
        }
        this.renderQuadWithWarbling(poseStack, vertexConsumer, size, size, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, baseAlpha);
        poseStack.m_85849_();
        if (isActive) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252403_.m_252977_(-rotation * 0.3f));
            poseStack.m_85837_(0.0, 0.0, (double)-0.05f);
            float innerAlpha = 0.6f;
            if (isOnCooldown) {
                innerAlpha *= 0.05f + 0.95f * cooldownProgress;
            }
            this.renderQuadWithWarbling(poseStack, vertexConsumer, size * 0.6f, size * 0.6f, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, innerAlpha);
            poseStack.m_85849_();
        }
    }

    private void renderVortexEffect(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float size, float rotation, boolean isOnCooldown, float cooldownProgress) {
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)VORTEX_TEXTURE));
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation * 2.0f));
        poseStack.m_85837_(0.0, 0.0, (double)0.01f);
        float vortexAlpha = 0.4f;
        if (isOnCooldown) {
            vortexAlpha *= 0.05f + 0.95f * cooldownProgress;
        }
        this.renderQuad(poseStack, vertexConsumer, size * 0.8f, size * 0.8f, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, vortexAlpha);
        poseStack.m_85849_();
    }

    private void renderParticleCylinder(MiniWarpGateEntity entity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float size, boolean isOnCooldown, float cooldownProgress) {
        float time = (float)(System.currentTimeMillis() % 360000L) / 1000.0f;
        for (int i = 0; i < 8; ++i) {
            float angle = (float)((double)i * Math.PI * 2.0 / 8.0 + (double)time * 0.5);
            float radius = size * 0.6f;
            float x = (float)Math.cos(angle) * radius;
            float z = (float)Math.sin(angle) * radius;
            float y = (float)Math.sin(time * 2.0f + (float)i) * 0.3f;
            poseStack.m_85836_();
            poseStack.m_252880_(x, y, z);
            float alpha = 0.7f;
            float particleSize = 0.05f + (float)Math.sin(time * 3.0f + (float)i) * 0.03f;
            if (isOnCooldown) {
                alpha *= 0.1f + 0.9f * cooldownProgress;
                particleSize *= 0.3f + 0.7f * cooldownProgress;
            }
            this.renderColoredParticle(poseStack, bufferSource, packedLight, entity.isPurplePortal(), alpha, particleSize);
            poseStack.m_85849_();
        }
    }

    private void renderColoredParticle(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, boolean isPurple, float alpha, float size) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        ResourceLocation texture = isPurple ? ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/purple_concrete.png") : ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/cyan_concrete.png");
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)texture));
        float halfSize = size / 2.0f;
        vertexConsumer.m_252986_(matrix, -halfSize, -halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfSize, -halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfSize, halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -halfSize, halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -halfSize, halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfSize, halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfSize, -halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -halfSize, -halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
    }

    private void renderQuadWithWarbling(PoseStack poseStack, VertexConsumer vertexConsumer, float width, float height, float u0, float v0, float u1, float v1, int packedLight, float alpha) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float time = (float)(System.currentTimeMillis() % 360000L) / 1000.0f;
        float halfWidth = width / 2.0f;
        float halfHeight = height / 2.0f;
        float warblingStrength = 0.1f;
        float warbling1 = (float)Math.sin(time * 3.0f) * warblingStrength;
        float warbling2 = (float)Math.sin(time * 3.0f + 1.57f) * warblingStrength;
        float warbling3 = (float)Math.sin(time * 3.0f + 3.14f) * warblingStrength;
        float warbling4 = (float)Math.sin(time * 3.0f + 4.71f) * warblingStrength;
        vertexConsumer.m_252986_(matrix, -halfWidth + warbling1, -halfHeight + warbling1, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfWidth + warbling2, -halfHeight + warbling2, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfWidth + warbling3, halfHeight + warbling3, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -halfWidth + warbling4, halfHeight + warbling4, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    private void renderQuad(PoseStack poseStack, VertexConsumer vertexConsumer, float width, float height, float u0, float v0, float u1, float v1, int packedLight, float alpha) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float halfWidth = width / 2.0f;
        float halfHeight = height / 2.0f;
        vertexConsumer.m_252986_(matrix, -halfWidth, -halfHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfWidth, -halfHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfWidth, halfHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -halfWidth, halfHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(MiniWarpGateEntity entity) {
        return MINI_WARP_GATE_TEXTURE;
    }
}

