/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.client.obj.OBJLoader;
import com.hexvane.strangematter.entity.GravityAnomalyEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class GravityAnomalyRenderer
extends EntityRenderer<GravityAnomalyEntity> {
    private static final ResourceLocation ICOSAHEDRON_OBJ = new ResourceLocation("strangematter", "models/entity/icosahedron.obj");
    private static final ResourceLocation AURA_TEXTURE = new ResourceLocation("strangematter", "textures/entity/gravity_anomaly_aura.png");
    private OBJLoader.OBJModel icosahedronModel;

    public GravityAnomalyRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
        try {
            this.icosahedronModel = OBJLoader.loadModel(ICOSAHEDRON_OBJ);
            System.out.println("Custom OBJ model loaded successfully with " + this.icosahedronModel.faces.size() + " faces");
        }
        catch (Exception e) {
            System.err.println("Failed to load custom OBJ model: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public ResourceLocation getTextureLocation(GravityAnomalyEntity entity) {
        return new ResourceLocation("strangematter", "textures/entity/gravity_anomaly_icosahedron.png");
    }

    public void render(GravityAnomalyEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        float rotation = entity.getRotation() + partialTicks * 0.5f;
        float pulseIntensity = entity.getPulseIntensity();
        this.renderIcosahedron(poseStack, buffer, packedLight, rotation, pulseIntensity);
        this.renderAuraIcosahedron(poseStack, buffer, packedLight, partialTicks);
        this.renderFloatingParticles(poseStack, buffer, packedLight, pulseIntensity, partialTicks);
        this.renderGroundParticleField(poseStack, buffer, packedLight, partialTicks);
        this.renderGlowEffect(poseStack, buffer, packedLight, rotation, pulseIntensity);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void renderIcosahedron(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float rotation, float pulseIntensity) {
        if (this.icosahedronModel == null) {
            System.err.println("Icosahedron model is null, cannot render");
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        float scale = 0.8f + pulseIntensity * 0.2f;
        poseStack.m_85841_(scale, scale, scale);
        this.icosahedronModel.render(poseStack, buffer, this.getTextureLocation(null), packedLight, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    private void renderAuraIcosahedron(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        if (this.icosahedronModel == null) {
            return;
        }
        poseStack.m_85836_();
        float auraRotation = (float)(-(System.currentTimeMillis() % 8000L)) / 8000.0f * 360.0f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(auraRotation));
        float auraScale = 1.5f;
        poseStack.m_85841_(auraScale, auraScale, auraScale);
        this.icosahedronModel.render(poseStack, buffer, AURA_TEXTURE, packedLight, 1.0f, 1.0f, 1.0f, 0.4f);
        poseStack.m_85849_();
    }

    private void renderGlowEffect(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float rotation, float pulseIntensity) {
        poseStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
        float glowRotation = (float)(System.currentTimeMillis() % 6000L) / 6000.0f * 360.0f;
        poseStack.m_252781_(Axis.f_252403_.m_252977_(glowRotation));
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_234338_((ResourceLocation)new ResourceLocation("minecraft", "textures/block/white_wool.png")));
        float glowIntensity = 0.2f + pulseIntensity * 0.3f;
        float glowSize = 1.5f + pulseIntensity * 0.3f;
        int segments = 16;
        float centerAlpha = glowIntensity;
        float edgeAlpha = 0.0f;
        for (int i = 0; i < segments; ++i) {
            float angle1 = (float)i / (float)segments * 2.0f * (float)Math.PI;
            float angle2 = (float)(i + 1) / (float)segments * 2.0f * (float)Math.PI;
            vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_85950_(0.2f, 1.0f, 0.3f, centerAlpha).m_7421_(0.5f, 0.5f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            float x1 = (float)(Math.cos(angle1) * (double)glowSize);
            float y1 = (float)(Math.sin(angle1) * (double)glowSize);
            float x2 = (float)(Math.cos(angle2) * (double)glowSize);
            float y2 = (float)(Math.sin(angle2) * (double)glowSize);
            vertexConsumer.m_252986_(matrix4f, x1, y1, 0.0f).m_85950_(0.2f, 1.0f, 0.3f, edgeAlpha).m_7421_(0.5f + x1 * 0.1f, 0.5f + y1 * 0.1f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, x2, y2, 0.0f).m_85950_(0.2f, 1.0f, 0.3f, edgeAlpha).m_7421_(0.5f + x2 * 0.1f, 0.5f + y2 * 0.1f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        }
    }

    private void renderFloatingParticles(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float pulseIntensity, float partialTicks) {
        float baseDistance;
        int particleCount = 12;
        float pulseDistance = baseDistance = 2.0f;
        for (int i = 0; i < particleCount; ++i) {
            poseStack.m_85836_();
            float phi = (float)Math.acos(1.0f - 2.0f * ((float)i + 0.5f) / (float)particleCount);
            float theta = (float)(Math.PI * (1.0 + Math.sqrt(5.0)) * (double)((float)i + 0.5f));
            float x = (float)(Math.sin(phi) * Math.cos(theta) * (double)pulseDistance);
            float y = (float)(Math.sin(phi) * Math.sin(theta) * (double)pulseDistance);
            float z = (float)(Math.cos(phi) * (double)pulseDistance);
            poseStack.m_252880_(x, y, z);
            float time = (float)(System.currentTimeMillis() % 360000L) / 1000.0f;
            float rotationX = ((float)i * 37.0f + time * (10.0f + (float)(i % 3) * 5.0f)) % 360.0f;
            float rotationY = ((float)i * 73.0f + time * (8.0f + (float)(i % 2) * 7.0f)) % 360.0f;
            float rotationZ = ((float)i * 29.0f + time * (12.0f + (float)(i % 4) * 3.0f)) % 360.0f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(rotationX));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotationY));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rotationZ));
            float size = 0.1f + (float)(i % 5) * 0.08f;
            poseStack.m_85841_(size, size, size);
            this.renderDirtBlock(poseStack, buffer, packedLight);
            poseStack.m_85849_();
        }
    }

    private void renderGroundParticleField(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        int particleCount = 24;
        float effectRadius = 4.0f;
        float time = (float)(System.currentTimeMillis() % 360000L) / 1000.0f;
        for (int i = 0; i < particleCount; ++i) {
            poseStack.m_85836_();
            float angle = (float)i * 360.0f / (float)particleCount + time * 5.0f;
            float distance = (float)(i % 3 + 1) * (effectRadius / 3.0f);
            float x = (float)(Math.cos(Math.toRadians(angle)) * (double)distance);
            float z = (float)(Math.sin(Math.toRadians(angle)) * (double)distance);
            float heightOffset = (float)Math.sin(time * 2.0f + (float)i * 0.5f) * 0.3f + 0.1f;
            float y = -1.0f + heightOffset;
            poseStack.m_252880_(x, y, z);
            float rotation = time * 20.0f + (float)i * 15.0f;
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
            float size = 0.05f + (float)(i % 3) * 0.02f;
            poseStack.m_85841_(size, size, size);
            this.renderColoredParticle(poseStack, buffer, packedLight, 4305536);
            poseStack.m_85849_();
        }
    }

    private void renderColoredParticle(PoseStack poseStack, MultiBufferSource buffer, int packedLight, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110470_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/entity/gravity_anomaly_aura.png")));
        float halfSize = 0.5f;
        vertexConsumer.m_252986_(matrix4f, -halfSize, -halfSize, halfSize).m_85950_(r, g, b, 0.8f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, -halfSize, halfSize).m_85950_(r, g, b, 0.8f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, halfSize, halfSize).m_85950_(r, g, b, 0.8f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, halfSize, halfSize).m_85950_(r, g, b, 0.8f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, -halfSize, -halfSize).m_85950_(r, g, b, 0.8f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, halfSize, -halfSize).m_85950_(r, g, b, 0.8f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, halfSize, -halfSize).m_85950_(r, g, b, 0.8f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, -halfSize, -halfSize).m_85950_(r, g, b, 0.8f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, halfSize, -halfSize).m_85950_(r, g, b, 0.8f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, halfSize, halfSize).m_85950_(r, g, b, 0.8f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, halfSize, halfSize).m_85950_(r, g, b, 0.8f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, halfSize, -halfSize).m_85950_(r, g, b, 0.8f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, -halfSize, -halfSize).m_85950_(r, g, b, 0.8f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, -halfSize, -halfSize).m_85950_(r, g, b, 0.8f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, -halfSize, halfSize).m_85950_(r, g, b, 0.8f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, -halfSize, halfSize).m_85950_(r, g, b, 0.8f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, -halfSize, -halfSize).m_85950_(r, g, b, 0.8f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, halfSize, -halfSize).m_85950_(r, g, b, 0.8f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, halfSize, halfSize).m_85950_(r, g, b, 0.8f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, -halfSize, halfSize).m_85950_(r, g, b, 0.8f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, -halfSize, -halfSize).m_85950_(r, g, b, 0.8f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, -halfSize, halfSize).m_85950_(r, g, b, 0.8f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, halfSize, halfSize).m_85950_(r, g, b, 0.8f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, halfSize, -halfSize).m_85950_(r, g, b, 0.8f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
    }

    private void renderDirtBlock(PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110470_((ResourceLocation)new ResourceLocation("minecraft", "textures/block/dirt.png")));
        float halfSize = 0.5f;
        vertexConsumer.m_252986_(matrix4f, -halfSize, -halfSize, halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, -halfSize, halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, halfSize, halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, halfSize, halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, -halfSize, -halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, halfSize, -halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, halfSize, -halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, -halfSize, -halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, halfSize, -halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, halfSize, halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, halfSize, halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, halfSize, -halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, -halfSize, -halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, -halfSize, -halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, -halfSize, halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, -halfSize, halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, -halfSize, -halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, halfSize, -halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, halfSize, halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, -halfSize, halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, -halfSize, -halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, -halfSize, halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, halfSize, halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, halfSize, -halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
    }
}

