/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class GravitonHammerRenderer
implements IClientItemExtensions {
    public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
        if (this.isCharging(itemInHand)) {
            int chargeLevel = this.getChargeLevel(itemInHand);
            float chargeProgress = this.getChargeProgress(itemInHand);
            float pullBackAmount = this.calculatePullBackAmount(chargeLevel, chargeProgress);
            this.applyChargeTransform(poseStack, pullBackAmount, arm);
            return true;
        }
        return false;
    }

    private boolean isCharging(ItemStack stack) {
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128471_("charging");
        }
        return false;
    }

    private int getChargeLevel(ItemStack stack) {
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128451_("charge_level");
        }
        return 0;
    }

    private float getChargeProgress(ItemStack stack) {
        if (stack.m_41782_()) {
            int chargeTime = stack.m_41783_().m_128451_("charge_time");
            int currentLevel = this.getChargeLevel(stack);
            int levelStartTime = this.getLevelStartTime(currentLevel);
            int levelEndTime = this.getLevelEndTime(currentLevel);
            if (levelEndTime > levelStartTime) {
                return Math.min(1.0f, (float)(chargeTime - levelStartTime) / (float)(levelEndTime - levelStartTime));
            }
        }
        return 0.0f;
    }

    private int getLevelStartTime(int level) {
        switch (level) {
            case 1: {
                return 0;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 40;
            }
        }
        return 0;
    }

    private int getLevelEndTime(int level) {
        switch (level) {
            case 1: {
                return 20;
            }
            case 2: {
                return 40;
            }
            case 3: {
                return 60;
            }
        }
        return 20;
    }

    private float calculatePullBackAmount(int chargeLevel, float chargeProgress) {
        float basePullBack = 0.6f;
        switch (chargeLevel) {
            case 1: {
                basePullBack = 0.5f;
                break;
            }
            case 2: {
                basePullBack = 0.4f;
                break;
            }
            case 3: {
                basePullBack = 0.3f;
                break;
            }
            default: {
                basePullBack = 0.6f;
            }
        }
        return basePullBack * chargeProgress;
    }

    private void applyChargeTransform(PoseStack poseStack, float pullBackAmount, HumanoidArm arm) {
        poseStack.m_252880_(0.0f, 0.0f, -pullBackAmount);
        float rotationAmount = pullBackAmount * 15.0f;
        poseStack.m_252781_(Axis.f_252529_.m_252977_(rotationAmount));
        float outwardRotation = pullBackAmount * 10.0f;
        if (arm == HumanoidArm.RIGHT) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_(outwardRotation));
        } else {
            poseStack.m_252781_(Axis.f_252403_.m_252977_(-outwardRotation));
        }
    }
}

