/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.entity.EnergeticRiftEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;

public class EnergeticRiftRenderer
extends EntityRenderer<EnergeticRiftEntity> {
    private static final ResourceLocation RIFT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/entity/energetic_rift.png");
    private static final int LIGHTNING_ROD_CACHE_TTL_TICKS = 5;
    private static final long LIGHTNING_ROD_CACHE_STALE_TICKS = 200L;
    private static final Map<Integer, CachedLightningRod> LIGHTNING_ROD_CACHE = new HashMap<Integer, CachedLightningRod>();

    public EnergeticRiftRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
    }

    public ResourceLocation getTextureLocation(@Nonnull EnergeticRiftEntity entity) {
        return RIFT_TEXTURE;
    }

    public void render(@Nonnull EnergeticRiftEntity entity, float entityYaw, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5, 0.0);
        poseStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        float rotation = entity.getRotation() + partialTicks * 0.5f;
        float pulseIntensity = entity.getPulseIntensity();
        this.renderSwirlingRift(poseStack, buffer, packedLight, rotation, pulseIntensity);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5, 0.0);
        poseStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        this.renderElectricSparks(poseStack, buffer, packedLight, (float)(System.currentTimeMillis() % 360000L) / 3000.0f + partialTicks * 0.03f);
        poseStack.m_85849_();
        this.renderTargetingSparks(poseStack, buffer, packedLight, entity);
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void renderSwirlingRift(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float rotation, float pulseIntensity) {
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)RIFT_TEXTURE));
        float scale = 1.0f + pulseIntensity * 0.3f;
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        this.renderBillboard(poseStack, consumer, packedLight, 2.0f, 2.0f, 0xFFFFFF, 0.8f);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 0.01);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(-rotation * 1.5f));
        this.renderBillboard(poseStack, consumer, packedLight, 1.2f, 1.2f, 0xFFFFFF, 0.6f);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private void renderElectricSparks(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float time) {
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110502_());
        int sparkCount = 6;
        for (int i = 0; i < sparkCount; ++i) {
            float sparkPhase = (time * 0.8f + (float)i * 0.5f) % 2.5f;
            if (sparkPhase > 2.0f) continue;
            float baseAngle = (float)i * (360.0f / (float)sparkCount);
            float sparkAngle = baseAngle + time * 8.0f;
            float sparkRadius = 0.3f + sparkPhase * 2.2f;
            this.renderLightningSpark(poseStack, consumer, packedLight, time + (float)i, sparkAngle, sparkRadius, sparkPhase, baseAngle);
        }
    }

    private void renderLightningSpark(PoseStack poseStack, VertexConsumer consumer, int packedLight, float time, float angle, float maxRadius, float sparkPhase, float baseAngle) {
        int segments = 8;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double baseDirX = Math.cos(Math.toRadians(angle));
        double baseDirY = 0.0;
        double baseDirZ = Math.sin(Math.toRadians(angle));
        for (int i = 0; i < segments; ++i) {
            float t = (float)i / (float)segments;
            float nextT = (float)(i + 1) / (float)segments;
            double nextX = baseDirX * (double)(nextT * maxRadius);
            double nextY = baseDirY * (double)(nextT * maxRadius);
            double nextZ = baseDirZ * (double)(nextT * maxRadius);
            if (i > 0) {
                float zigzagIntensity = 0.5f * (1.0f - t * 0.3f);
                double perpX = -baseDirZ;
                double perpY = 1.0;
                double perpZ = baseDirX;
                double perpLength = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
                if (perpLength > 0.0) {
                    perpX /= perpLength;
                    perpY /= perpLength;
                    perpZ /= perpLength;
                }
                float zigzag1 = (float)Math.sin((double)time * 1.0 + (double)i * 1.2 + (double)(baseAngle * 0.1f)) * zigzagIntensity;
                float zigzag2 = (float)Math.sin((double)time * 1.3 + (double)i * 1.5 + (double)(baseAngle * 0.15f)) * zigzagIntensity * 0.8f;
                nextX += perpX * (double)zigzag1;
                nextY += perpY * (double)zigzag2;
                nextZ += perpZ * (double)zigzag1;
            }
            if (i > 0) {
                float branchChance;
                float alpha = (1.0f - sparkPhase * 0.8f) * 0.9f;
                int color = 65535;
                float thickness = 0.06f * (1.0f - t * 0.7f);
                this.renderSparkQuad3D(poseStack, consumer, packedLight, x, y, z, nextX, nextY, nextZ, color, alpha, thickness);
                if (i > 2 && i < segments - 2 && t > 0.3f && t < 0.8f && (branchChance = (float)Math.sin((double)t * Math.PI + (double)(baseAngle * 0.1f))) > 0.7f) {
                    float branchAngle = angle + 30.0f + (float)Math.sin(time * 2.0f + (float)i * 0.5f) * 20.0f;
                    float branchLength = maxRadius * 0.4f * (1.0f - t);
                    double branchDirX = Math.cos(Math.toRadians(branchAngle));
                    double branchDirY = 0.0;
                    double branchDirZ = Math.sin(Math.toRadians(branchAngle));
                    double branchEndX = nextX + branchDirX * (double)branchLength;
                    double branchEndY = nextY + branchDirY * (double)branchLength;
                    double branchEndZ = nextZ + branchDirZ * (double)branchLength;
                    float branchAlpha = alpha * 0.7f;
                    float branchThickness = thickness * 0.6f;
                    this.renderSparkQuad3D(poseStack, consumer, packedLight, nextX, nextY, nextZ, branchEndX, branchEndY, branchEndZ, color, branchAlpha, branchThickness);
                }
            }
            x = nextX;
            y = nextY;
            z = nextZ;
        }
    }

    private void renderSparkQuad3D(PoseStack poseStack, VertexConsumer consumer, int packedLight, double x1, double y1, double z1, double x2, double y2, double z2, int color, float alpha, float thickness) {
        double perpZ1;
        double perpY1;
        double perpX1;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = alpha;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (length < 0.001) {
            return;
        }
        dx /= length;
        dy /= length;
        dz /= length;
        if (Math.abs(dy) > 0.9) {
            perpX1 = thickness;
            perpY1 = 0.0;
            perpZ1 = 0.0;
        } else {
            perpX1 = -dz * (double)thickness;
            perpY1 = 0.0;
            perpZ1 = dx * (double)thickness;
        }
        double perpX2 = -perpX1;
        double perpY2 = -perpY1;
        double perpZ2 = -perpZ1;
        consumer.m_252986_(matrix, (float)(x1 + perpX1), (float)(y1 + perpY1), (float)(z1 + perpZ1)).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)dx, (float)dy, (float)dz).m_5752_();
        consumer.m_252986_(matrix, (float)(x2 + perpX1), (float)(y2 + perpY1), (float)(z2 + perpZ1)).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)dx, (float)dy, (float)dz).m_5752_();
        consumer.m_252986_(matrix, (float)(x2 + perpX2), (float)(y2 + perpY2), (float)(z2 + perpZ2)).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)dx, (float)dy, (float)dz).m_5752_();
        consumer.m_252986_(matrix, (float)(x1 + perpX2), (float)(y1 + perpY2), (float)(z1 + perpZ2)).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)dx, (float)dy, (float)dz).m_5752_();
        consumer.m_252986_(matrix, (float)(x1 + perpX2), (float)(y1 + perpY2), (float)(z1 + perpZ2)).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)(-dx), (float)(-dy), (float)(-dz)).m_5752_();
        consumer.m_252986_(matrix, (float)(x2 + perpX2), (float)(y2 + perpY2), (float)(z2 + perpZ2)).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)(-dx), (float)(-dy), (float)(-dz)).m_5752_();
        consumer.m_252986_(matrix, (float)(x2 + perpX1), (float)(y2 + perpY1), (float)(z2 + perpZ1)).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)(-dx), (float)(-dy), (float)(-dz)).m_5752_();
        consumer.m_252986_(matrix, (float)(x1 + perpX1), (float)(y1 + perpY1), (float)(z1 + perpZ1)).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)(-dx), (float)(-dy), (float)(-dz)).m_5752_();
    }

    private void renderBillboard(PoseStack poseStack, VertexConsumer consumer, int packedLight, float width, float height, int color, float alpha) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = alpha;
        float halfWidth = width / 2.0f;
        float halfHeight = height / 2.0f;
        consumer.m_252986_(matrix, -halfWidth, -halfHeight, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, halfWidth, -halfHeight, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, halfWidth, halfHeight, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, -halfWidth, halfHeight, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
    }

    private void renderTargetingSparks(PoseStack poseStack, MultiBufferSource buffer, int packedLight, EnergeticRiftEntity entity) {
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110502_());
        BlockPos rodPos = this.getNearestLightningRodCached(entity);
        if (rodPos != null) {
            int sparkDuration;
            int cycleTime;
            long currentTime = System.currentTimeMillis();
            int sparkTimer = (int)(currentTime % (long)(cycleTime = 2000));
            if (sparkTimer < (sparkDuration = 500)) {
                float progress = (float)sparkTimer / (float)sparkDuration;
                float alpha = progress <= 0.2f ? 1.0f : 1.0f - (progress - 0.2f) / 0.8f;
                this.renderTargetingSparkToRod(poseStack, consumer, packedLight, entity, rodPos, alpha);
            }
            return;
        }
        AABB zapBox = entity.m_20191_().m_82400_(6.0);
        List entitiesInRange = entity.m_9236_().m_45933_((Entity)entity, zapBox);
        for (Entity target : entitiesInRange) {
            int sparkDuration;
            int cycleTime;
            long currentTime;
            int sparkTimer;
            double distance;
            if (!(target instanceof LivingEntity) || target instanceof Player && ((Player)target).m_7500_() || !((distance = (double)entity.m_20270_(target)) <= 6.0) || (sparkTimer = (int)((currentTime = System.currentTimeMillis()) % (long)(cycleTime = 2000))) >= (sparkDuration = 500)) continue;
            float progress = (float)sparkTimer / (float)sparkDuration;
            float alpha = progress <= 0.2f ? 1.0f : 1.0f - (progress - 0.2f) / 0.8f;
            this.renderTargetingSparkToEntity(poseStack, consumer, packedLight, entity, target, alpha);
        }
    }

    private void renderTargetingSparkToEntity(PoseStack poseStack, VertexConsumer consumer, int packedLight, EnergeticRiftEntity entity, Entity target, float alpha) {
        double startX = 0.0;
        double startY = 0.5;
        double startZ = 0.0;
        double endX = target.m_20185_() - entity.m_20185_();
        double endY = target.m_20186_() + (double)(target.m_20206_() / 2.0f) - entity.m_20186_();
        double endZ = target.m_20189_() - entity.m_20189_();
        int segments = 12;
        double x = startX;
        double y = startY;
        double z = startZ;
        double dx = endX - startX;
        double dy = endY - startY;
        double dz = endZ - startZ;
        double totalDistance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        dx /= totalDistance;
        dy /= totalDistance;
        dz /= totalDistance;
        float time = (float)(System.currentTimeMillis() % 1000L) / 1000.0f;
        float sparkAngle = (float)Math.atan2(endZ - startZ, endX - startX) * 180.0f / (float)Math.PI;
        for (int i = 0; i < segments; ++i) {
            float t = (float)i / (float)segments;
            float nextT = (float)(i + 1) / (float)segments;
            double nextX = startX + dx * ((double)nextT * totalDistance);
            double nextY = startY + dy * ((double)nextT * totalDistance);
            double nextZ = startZ + dz * ((double)nextT * totalDistance);
            if (i > 0) {
                float zigzagIntensity = 0.4f * (1.0f - t * 0.6f);
                double perpX = -dz;
                double perpY = 1.0;
                double perpZ = dx;
                double perpLength = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
                if (perpLength > 0.0) {
                    perpX /= perpLength;
                    perpY /= perpLength;
                    perpZ /= perpLength;
                }
                float zigzag1 = (float)Math.sin((double)(time * 20.0f) + (double)i * 2.0 + (double)(sparkAngle * 0.1f)) * zigzagIntensity;
                float zigzag2 = (float)Math.sin((double)(time * 25.0f) + (double)i * 2.5 + (double)(sparkAngle * 0.15f)) * zigzagIntensity * 0.8f;
                nextX += perpX * (double)zigzag1;
                nextY += perpY * (double)zigzag2;
                nextZ += perpZ * (double)zigzag1;
            }
            if (i > 0) {
                int color = 65535;
                float thickness = 0.1f * (1.0f - t * 0.7f);
                this.renderSparkQuad3D(poseStack, consumer, packedLight, x, y, z, nextX, nextY, nextZ, color, alpha, thickness);
            }
            x = nextX;
            y = nextY;
            z = nextZ;
        }
    }

    private void renderTargetingSparkToRod(PoseStack poseStack, VertexConsumer consumer, int packedLight, EnergeticRiftEntity entity, BlockPos rodPos, float alpha) {
        double targetX = (double)rodPos.m_123341_() + 0.5;
        double targetY = (double)rodPos.m_123342_() + 1.0;
        double targetZ = (double)rodPos.m_123343_() + 0.5;
        double startX = 0.0;
        double startY = 0.5;
        double startZ = 0.0;
        double endX = targetX - entity.m_20185_();
        double endY = targetY - entity.m_20186_();
        double endZ = targetZ - entity.m_20189_();
        this.renderTargetingSparkToPoint(poseStack, consumer, packedLight, startX, startY, startZ, endX, endY, endZ, alpha);
    }

    private void renderTargetingSparkToPoint(PoseStack poseStack, VertexConsumer consumer, int packedLight, double startX, double startY, double startZ, double endX, double endY, double endZ, float alpha) {
        int segments = 12;
        double x = startX;
        double y = startY;
        double z = startZ;
        double dx = endX - startX;
        double dy = endY - startY;
        double dz = endZ - startZ;
        double totalDistance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (totalDistance < 1.0E-4) {
            return;
        }
        dx /= totalDistance;
        dy /= totalDistance;
        dz /= totalDistance;
        float time = (float)(System.currentTimeMillis() % 1000L) / 1000.0f;
        for (int i = 0; i < segments; ++i) {
            float t = (float)i / (float)segments;
            float nextT = (float)(i + 1) / (float)segments;
            double nextX = startX + dx * ((double)nextT * totalDistance);
            double nextY = startY + dy * ((double)nextT * totalDistance);
            double nextZ = startZ + dz * ((double)nextT * totalDistance);
            if (i > 0) {
                float zigzagIntensity = 0.4f * (1.0f - t * 0.6f);
                float noise1 = (float)Math.sin((double)(t * 10.0f + time * 8.0f) * Math.PI * 2.0) * zigzagIntensity;
                float noise2 = (float)Math.sin((double)(t * 7.0f + time * 5.0f) * Math.PI * 2.0) * zigzagIntensity * 0.6f;
                float noise3 = (float)Math.sin((double)(t * 13.0f + time * 9.0f) * Math.PI * 2.0) * zigzagIntensity * 0.4f;
                nextX += (double)(noise1 + noise3) * (1.0 - Math.abs(dx));
                nextY += (double)noise2 * (1.0 - Math.abs(dy));
                nextZ += (double)(noise1 - noise3) * (1.0 - Math.abs(dz));
            }
            this.renderSparkQuad3D(poseStack, consumer, packedLight, x, y, z, nextX, nextY, nextZ, 8379391, alpha, 0.06f);
            x = nextX;
            y = nextY;
            z = nextZ;
        }
    }

    private BlockPos getNearestLightningRodCached(EnergeticRiftEntity entity) {
        CachedLightningRod cached;
        long gameTime = entity.m_9236_().m_46467_();
        int id = entity.m_19879_();
        if (gameTime % 100L == 0L && !LIGHTNING_ROD_CACHE.isEmpty()) {
            LIGHTNING_ROD_CACHE.entrySet().removeIf(e -> gameTime - ((CachedLightningRod)e.getValue()).lastSeenTick > 200L);
        }
        if ((cached = LIGHTNING_ROD_CACHE.get(id)) != null) {
            cached.lastSeenTick = gameTime;
            if (gameTime < cached.nextRefreshTick) {
                return cached.rodPos;
            }
        } else {
            cached = new CachedLightningRod();
            cached.lastSeenTick = gameTime;
            LIGHTNING_ROD_CACHE.put(id, cached);
        }
        cached.rodPos = this.findNearestLightningRod(entity);
        cached.nextRefreshTick = gameTime + 5L;
        return cached.rodPos;
    }

    private BlockPos findNearestLightningRod(EnergeticRiftEntity entity) {
        float lightningRadius = (float)Config.energeticLightningRadius;
        if (lightningRadius <= 0.0f) {
            return null;
        }
        int r = (int)lightningRadius;
        double radiusSq = lightningRadius * lightningRadius;
        BlockPos center = entity.m_20183_();
        BlockPos best = null;
        double bestHorizSq = Double.MAX_VALUE;
        for (int x = -r; x <= r; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -r; z <= r; ++z) {
                    double horizSq = (double)x * (double)x + (double)z * (double)z;
                    if (horizSq > radiusSq) continue;
                    BlockPos pos = center.m_7918_(x, y, z);
                    BlockState state = entity.m_9236_().m_8055_(pos);
                    if (!state.m_60713_(Blocks.f_152587_) || !(horizSq < bestHorizSq)) continue;
                    bestHorizSq = horizSq;
                    best = pos;
                }
            }
        }
        return best;
    }

    private static class CachedLightningRod {
        BlockPos rodPos;
        long nextRefreshTick;
        long lastSeenTick;

        private CachedLightningRod() {
        }
    }
}

