/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.client.obj.OBJLoader;
import com.hexvane.strangematter.entity.EchoingShadowEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class EchoingShadowRenderer
extends EntityRenderer<EchoingShadowEntity> {
    private static final ResourceLocation ICOSAHEDRON_OBJ = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"models/entity/icosahedron.obj");
    private static final ResourceLocation SHADOW_BILLBOARD_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/entity/shadow_billboard.png");
    private static final ResourceLocation ICOSAHEDRON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/entity/echoing_shadow_icosahedron.png");
    private static final ResourceLocation ECHO_RINGS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/entity/echo_rings.png");
    private OBJLoader.OBJModel icosahedronModel;

    public EchoingShadowRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
        try {
            this.icosahedronModel = OBJLoader.loadModel(ICOSAHEDRON_OBJ);
            System.out.println("Custom OBJ model loaded successfully with " + this.icosahedronModel.faces.size() + " faces");
        }
        catch (Exception e) {
            System.err.println("Failed to load custom OBJ model: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public ResourceLocation getTextureLocation(@NotNull EchoingShadowEntity entity) {
        return ICOSAHEDRON_TEXTURE;
    }

    public void render(@NotNull EchoingShadowEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        float rotation = entity.getRotation() + partialTicks * 0.5f;
        float pulseIntensity = entity.getPulseIntensity();
        this.renderShadowBillboard(poseStack, buffer, packedLight, rotation, pulseIntensity);
        this.renderAnimatedIcosahedron(poseStack, buffer, packedLight, rotation, pulseIntensity, partialTicks);
        this.renderRotatingRings(poseStack, buffer, packedLight, pulseIntensity, partialTicks);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void renderShadowBillboard(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float rotation, float pulseIntensity) {
        poseStack.m_85836_();
        poseStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        float scale = 1.5f;
        poseStack.m_85841_(scale, scale, scale);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_234338_((ResourceLocation)SHADOW_BILLBOARD_TEXTURE));
        float halfSize = 3.0f;
        float alpha = 1.0f;
        vertexConsumer.m_252986_(matrix4f, -halfSize, -halfSize, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, -halfSize, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, halfSize, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, halfSize, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        poseStack.m_85849_();
    }

    private void renderAnimatedIcosahedron(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float rotation, float pulseIntensity, float partialTicks) {
        if (this.icosahedronModel == null) {
            System.err.println("Icosahedron model is null, cannot render");
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        float baseScale = 1.2f + pulseIntensity * 0.2f;
        poseStack.m_85841_(baseScale, baseScale, baseScale);
        float time = (float)(System.currentTimeMillis() % 10000L) / 1000.0f;
        this.icosahedronModel.renderWithDistortion(poseStack, buffer, ICOSAHEDRON_TEXTURE, packedLight, 0.0f, 0.0f, 0.0f, 1.0f, time);
        poseStack.m_85849_();
    }

    private void renderRotatingRings(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float pulseIntensity, float partialTicks) {
        float time = (float)(System.currentTimeMillis() % 12000L) / 1000.0f;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 0.1);
        this.renderRingBillboard(poseStack, buffer, packedLight, pulseIntensity, time, 1.0f, 1.0f);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 0.2);
        this.renderRingBillboard(poseStack, buffer, packedLight, pulseIntensity, -time * 1.3f, 0.7f, 0.7f);
        poseStack.m_85849_();
    }

    private void renderRingBillboard(PoseStack poseStack, MultiBufferSource buffer, int packedLight, float pulseIntensity, float rotation, float size, float alpha) {
        poseStack.m_85836_();
        poseStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation * 30.0f));
        float scale = size * (0.8f + pulseIntensity * 0.4f);
        poseStack.m_85841_(scale, scale, scale);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110470_((ResourceLocation)ECHO_RINGS_TEXTURE));
        float halfSize = 1.2f;
        float finalAlpha = alpha * (0.8f + pulseIntensity * 0.2f);
        vertexConsumer.m_252986_(matrix4f, -halfSize, -halfSize, 0.0f).m_85950_(0.8f, 0.2f, 1.0f, finalAlpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, -halfSize, 0.0f).m_85950_(0.8f, 0.2f, 1.0f, finalAlpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, halfSize, halfSize, 0.0f).m_85950_(0.8f, 0.2f, 1.0f, finalAlpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -halfSize, halfSize, 0.0f).m_85950_(0.8f, 0.2f, 1.0f, finalAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        poseStack.m_85849_();
    }
}

