/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.client.EchoVacuumBeamRenderer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class EchoVacuumClientHandler {
    private final EchoVacuumBeamRenderer beamRenderer = new EchoVacuumBeamRenderer();

    @SubscribeEvent
    public void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localPlayer = minecraft.f_91074_;
        if (localPlayer == null) {
            return;
        }
        for (Player player : StrangeMatterMod.getPlayersUsingBeam()) {
            this.renderBeamForPlayer(event, minecraft, player, player == localPlayer);
        }
    }

    private void renderBeamForPlayer(RenderLevelStageEvent event, Minecraft minecraft, Player player, boolean isLocalPlayer) {
        boolean isFirstPerson = isLocalPlayer && minecraft.f_91066_.m_92176_().m_90612_();
        Vec3 gunTipPos = this.calculateGunTipPosition(player, isFirstPerson);
        Vec3 lookAngle = player.m_20154_();
        float maxRange = 8.0f;
        HitResult hitResult = isLocalPlayer ? ((LocalPlayer)player).m_19907_((double)maxRange, 1.0f, false) : new HitResult(Vec3.f_82478_){

            public HitResult.Type m_6662_() {
                return HitResult.Type.MISS;
            }
        };
        Vec3 beamEnd = hitResult.m_6662_() == HitResult.Type.BLOCK ? hitResult.m_82450_() : gunTipPos.m_82549_(lookAngle.m_82490_((double)maxRange));
        event.getPoseStack().m_85836_();
        Vec3 cameraPos = minecraft.f_91063_.m_109153_().m_90583_();
        event.getPoseStack().m_85837_(gunTipPos.f_82479_ - cameraPos.f_82479_, gunTipPos.f_82480_ - cameraPos.f_82480_, gunTipPos.f_82481_ - cameraPos.f_82481_);
        float yaw = player.m_146908_();
        float pitch = player.m_146909_();
        event.getPoseStack().m_252781_(Axis.f_252436_.m_252977_(-yaw));
        event.getPoseStack().m_252781_(Axis.f_252529_.m_252977_(pitch));
        Vec3 localBeamEnd = beamEnd.m_82546_(gunTipPos);
        float cosYaw = (float)Math.cos(Math.toRadians(yaw));
        float sinYaw = (float)Math.sin(Math.toRadians(yaw));
        float cosPitch = (float)Math.cos(Math.toRadians(pitch));
        float sinPitch = (float)Math.sin(Math.toRadians(pitch));
        double localX = localBeamEnd.f_82479_ * (double)cosYaw + localBeamEnd.f_82481_ * (double)sinYaw;
        double localY = localBeamEnd.f_82480_ * (double)cosPitch + (localBeamEnd.f_82479_ * (double)sinYaw - localBeamEnd.f_82481_ * (double)cosYaw) * (double)sinPitch;
        double localZ = -(localBeamEnd.f_82479_ * (double)sinYaw - localBeamEnd.f_82481_ * (double)cosYaw) * (double)cosPitch + localBeamEnd.f_82480_ * (double)sinPitch;
        Vec3 localBeamDirection = new Vec3(localX, localY, localZ);
        Vec3 localBeamEndPos = new Vec3(localX, localY, localZ);
        this.beamRenderer.renderBeam(event.getPoseStack(), (MultiBufferSource)minecraft.m_91269_().m_110104_(), LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)player.m_20183_()), Vec3.f_82478_, localBeamDirection, new Vec3(0.0, 0.0, 1.0), isFirstPerson, hitResult.m_6662_() == HitResult.Type.BLOCK, localBeamEndPos);
        event.getPoseStack().m_85849_();
    }

    private Vec3 calculateGunTipPosition(Player player, boolean isFirstPerson) {
        Vec3 eyePos = player.m_146892_();
        Vec3 lookAngle = player.m_20154_();
        if (isFirstPerson) {
            Vec3 rightSide = Vec3.m_82498_((float)0.0f, (float)(player.m_146908_() + 90.0f)).m_82490_(0.1);
            Vec3 downOffset = new Vec3(0.0, -0.2, 0.0);
            Vec3 forwardOffset = lookAngle.m_82490_(0.6);
            return eyePos.m_82549_(rightSide).m_82549_(downOffset).m_82549_(forwardOffset);
        }
        Vec3 rightSide = Vec3.m_82498_((float)0.0f, (float)(player.m_146908_() + 90.0f)).m_82490_(0.1);
        Vec3 handPos = eyePos.m_82549_(rightSide).m_82549_(new Vec3(1.0, 0.0, 0.0));
        return handPos.m_82549_(lookAngle.m_82490_(0.5));
    }
}

