/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class EchoVacuumBeamRenderer {
    private static final ResourceLocation BEAM_TEXTURE = new ResourceLocation("strangematter", "textures/particle/beam.png");

    public void renderBeam(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Vec3 start, Vec3 end, Vec3 direction, boolean isFirstPerson, boolean hitTarget, Vec3 localBeamEnd) {
        this.renderVacuumConeParticles(poseStack, buffer, packedLight, Vec3.f_82478_, direction, isFirstPerson);
        if (hitTarget) {
            this.renderAnomalyExtractionParticles(poseStack, buffer, packedLight, Vec3.f_82478_, localBeamEnd, direction);
        }
        poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
        this.renderChaoticBeam(poseStack, buffer, packedLight, Vec3.f_82478_, end, direction);
    }

    private void renderChaoticBeam(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Vec3 start, Vec3 end, Vec3 direction) {
        int i;
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_234338_((ResourceLocation)BEAM_TEXTURE));
        int segments = 20;
        float maxThickness = 1.0f;
        float minThickness = 0.025f;
        double totalLength = end.m_82546_(start).m_82553_();
        double[] segmentX = new double[segments];
        double[] segmentY = new double[segments];
        double[] segmentZ = new double[segments];
        float[] segmentThickness = new float[segments];
        for (i = 0; i < segments; ++i) {
            float t = (float)i / (float)(segments - 1);
            double baseX = start.f_82479_ + direction.f_82479_ * ((double)t * totalLength);
            double baseY = start.f_82480_ + direction.f_82480_ * ((double)t * totalLength);
            double baseZ = start.f_82481_ + direction.f_82481_ * ((double)t * totalLength);
            double distanceFromTip = (double)t * totalLength;
            float thicknessFactor = Math.max(0.0f, Math.min(1.0f, (float)(distanceFromTip / 1.0)));
            segmentThickness[i] = minThickness + (maxThickness - minThickness) * thicknessFactor;
            float wobbleDistance = 2.0f;
            float wobbleFactor = Math.min(1.0f, (float)(distanceFromTip / (double)wobbleDistance));
            float zigzagIntensity = 0.3f * wobbleFactor;
            double perpX = -direction.f_82481_;
            double perpY = 1.0;
            double perpZ = direction.f_82479_;
            double perpLength = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
            if (perpLength > 0.0) {
                perpX /= perpLength;
                perpY /= perpLength;
                perpZ /= perpLength;
            }
            float time = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
            float zigzag1 = (float)Math.sin(time * 5.0f + (float)i * 0.5f) * zigzagIntensity;
            float zigzag2 = (float)Math.sin(time * 6.5f + (float)i * 0.7f) * zigzagIntensity * 0.8f;
            segmentX[i] = baseX + perpX * (double)zigzag1;
            segmentY[i] = baseY + perpY * (double)zigzag2;
            segmentZ[i] = baseZ + perpZ * (double)zigzag1;
        }
        for (i = 0; i < segments - 1; ++i) {
            int color = 65535;
            float alpha = 0.8f;
            float avgThickness = (segmentThickness[i] + segmentThickness[i + 1]) / 2.0f;
            this.renderBeamSegment(poseStack, consumer, packedLight, segmentX[i], segmentY[i], segmentZ[i], segmentX[i + 1], segmentY[i + 1], segmentZ[i + 1], color, alpha, avgThickness);
        }
    }

    private void renderBeamSegment(PoseStack poseStack, VertexConsumer consumer, int packedLight, double x1, double y1, double z1, double x2, double y2, double z2, int color, float alpha, float thickness) {
        double perpZ1;
        double perpY1;
        double perpX1;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = alpha;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (length < 0.001) {
            return;
        }
        dx /= length;
        dy /= length;
        dz /= length;
        if (Math.abs(dy) < 0.9) {
            perpX1 = 0.0;
            perpY1 = thickness;
            perpZ1 = 0.0;
        } else {
            perpX1 = -dz * (double)thickness;
            perpY1 = 0.0;
            perpZ1 = dx * (double)thickness;
        }
        double perpX2 = -perpX1;
        double perpY2 = -perpY1;
        double perpZ2 = -perpZ1;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        consumer.m_252986_(matrix, (float)(x1 + perpX1), (float)(y1 + perpY1), (float)(z1 + perpZ1)).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)dx, (float)dy, (float)dz).m_5752_();
        consumer.m_252986_(matrix, (float)(x2 + perpX1), (float)(y2 + perpY1), (float)(z2 + perpZ1)).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)dx, (float)dy, (float)dz).m_5752_();
        consumer.m_252986_(matrix, (float)(x2 + perpX2), (float)(y2 + perpY2), (float)(z2 + perpZ2)).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)dx, (float)dy, (float)dz).m_5752_();
        consumer.m_252986_(matrix, (float)(x1 + perpX2), (float)(y1 + perpY2), (float)(z1 + perpZ2)).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)dx, (float)dy, (float)dz).m_5752_();
    }

    private void renderVacuumConeParticles(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Vec3 vacuumPos, Vec3 direction, boolean isFirstPerson) {
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110470_((ResourceLocation)new ResourceLocation("minecraft", "textures/block/white_concrete.png")));
        int cyanColor = 65535;
        float alpha = 0.8f;
        float spiralRadius = isFirstPerson ? 2.0f : 2.5f;
        for (int i = 0; i < 12; ++i) {
            float time = (float)(System.currentTimeMillis() % 3000L) / 1000.0f;
            float baseAngle = (float)i * 30.0f;
            float particleLife = (time + (float)i * 0.25f) % 1.0f;
            float outerRadius = spiralRadius;
            float innerRadius = 0.1f;
            float currentRadius = outerRadius - particleLife * (outerRadius - innerRadius);
            double coneDistance = 8.0 - (double)particleLife * 7.0;
            double coneRadius = (double)currentRadius * 0.8;
            double x = Math.cos(Math.toRadians(baseAngle)) * coneRadius;
            double y = Math.sin(Math.toRadians(baseAngle)) * coneRadius;
            double z = coneDistance;
            x += Math.sin(time * 6.0f + (float)i) * 0.05;
            z += Math.cos(time * 5.0f + (float)i) * 0.05;
            float deterministicRandom = (float)(Math.sin((float)i * 1.618f) * 0.5 + 0.5);
            float randomStartSize = 0.05f + deterministicRandom * 0.1f;
            float minSize = 0.01f;
            float currentParticleSize = randomStartSize - particleLife * (randomStartSize - minSize);
            float particleAlpha = alpha * (1.0f - particleLife * 0.5f);
            poseStack.m_85836_();
            poseStack.m_85837_(x, y, z);
            Minecraft minecraft = Minecraft.m_91087_();
            this.renderColoredParticle(poseStack, consumer, packedLight, cyanColor, particleAlpha, currentParticleSize);
            poseStack.m_85849_();
        }
    }

    private void renderAnomalyExtractionParticles(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Vec3 start, Vec3 end, Vec3 direction) {
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110470_((ResourceLocation)new ResourceLocation("minecraft", "textures/block/white_concrete.png")));
        int cyanColor = 65535;
        float alpha = 0.8f;
        for (int i = 0; i < 6; ++i) {
            float time = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
            float angleX = (float)(Math.sin((double)(time * 3.0f) + (double)i * 0.8) * Math.PI);
            float angleY = (float)(Math.cos((double)(time * 2.5f) + (double)i * 1.2) * Math.PI * 0.5);
            float angleZ = (float)(Math.sin((double)(time * 2.8f) + (double)i * 0.6) * Math.PI);
            Vec3 particlePos = end.m_82520_(Math.sin(angleX) * Math.cos(angleY) * 0.3, Math.sin(angleY) * 0.3, Math.cos(angleZ) * Math.sin(angleY) * 0.3);
            float outwardSpeed = time % 1.0f * 0.8f;
            particlePos = particlePos.m_82520_(Math.sin(angleX) * Math.cos(angleY) * (double)outwardSpeed, Math.sin(angleY) * (double)outwardSpeed * 0.5, Math.cos(angleZ) * Math.sin(angleY) * (double)outwardSpeed);
            poseStack.m_85836_();
            poseStack.m_85837_(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_);
            this.renderColoredParticle(poseStack, consumer, packedLight, cyanColor, alpha, 0.2f);
            poseStack.m_85849_();
        }
    }

    private void renderColoredParticle(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int color, float alpha, float halfSize) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        vertexConsumer.m_252986_(matrix, -halfSize, -halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfSize, -halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfSize, halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -halfSize, halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -halfSize, halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfSize, halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, halfSize, -halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -halfSize, -halfSize, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
    }
}

