/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.entity.ThoughtwellEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class CognitiveDisguiseRenderer {
    private static final Map<UUID, Entity> disguiseEntityCache = new ConcurrentHashMap<UUID, Entity>();
    private static final String[] DISGUISE_TYPES = new String[]{"minecraft:chicken", "minecraft:cow", "minecraft:pig", "minecraft:sheep", "minecraft:villager", "minecraft:zombie", "minecraft:skeleton", "minecraft:spider", "minecraft:creeper", "minecraft:enderman", "minecraft:witch", "minecraft:slime", "minecraft:husk", "minecraft:stray", "minecraft:cave_spider", "minecraft:silverfish", "minecraft:endermite", "minecraft:magma_cube", "minecraft:blaze"};

    public static boolean renderWithDisguise(Mob mob, EntityRenderDispatcher dispatcher, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        if (!ThoughtwellEntity.hasDisguise(mob.m_20148_())) {
            return false;
        }
        String disguiseTypeString = ThoughtwellEntity.getDisguiseType(mob.m_20148_());
        int disguiseDuration = ThoughtwellEntity.getDisguiseDuration(mob.m_20148_());
        if (disguiseDuration <= 0) {
            ThoughtwellEntity.removeDisguise(mob.m_20148_());
            Entity cachedEntity = disguiseEntityCache.remove(mob.m_20148_());
            if (cachedEntity != null) {
                cachedEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return false;
        }
        Entity disguiseEntity = disguiseEntityCache.get(mob.m_20148_());
        if (disguiseEntity == null) {
            EntityType disguiseType = (EntityType)mob.m_9236_().m_9598_().m_175515_(Registries.f_256939_).m_7745_(ResourceLocation.parse((String)disguiseTypeString));
            if (disguiseType == null) {
                ThoughtwellEntity.removeDisguise(mob.m_20148_());
                return false;
            }
            disguiseEntity = disguiseType.m_20615_(mob.m_9236_());
            if (disguiseEntity == null) {
                ThoughtwellEntity.removeDisguise(mob.m_20148_());
                return false;
            }
            mob.m_9236_().m_7967_(disguiseEntity);
            disguiseEntityCache.put(mob.m_20148_(), disguiseEntity);
        }
        CognitiveDisguiseRenderer.updateDisguiseEntity(disguiseEntity, mob);
        try {
            EntityRenderer disguiseRenderer = dispatcher.m_114382_(disguiseEntity);
            if (disguiseRenderer != null) {
                disguiseRenderer.m_7392_(disguiseEntity, mob.m_146908_(), partialTicks, poseStack, buffer, packedLight);
                return true;
            }
        }
        catch (Exception e) {
            ThoughtwellEntity.removeDisguise(mob.m_20148_());
            Entity cachedEntity = disguiseEntityCache.remove(mob.m_20148_());
            if (cachedEntity != null) {
                cachedEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return false;
        }
        return false;
    }

    private static void updateDisguiseEntity(Entity disguiseEntity, Mob originalMob) {
        disguiseEntity.m_6034_(originalMob.m_20185_(), originalMob.m_20186_(), originalMob.m_20189_());
        disguiseEntity.f_19854_ = originalMob.f_19854_;
        disguiseEntity.f_19855_ = originalMob.f_19855_;
        disguiseEntity.f_19856_ = originalMob.f_19856_;
        float targetYRot = originalMob.m_146908_();
        float targetXRot = originalMob.m_146909_();
        disguiseEntity.m_146922_(targetYRot);
        disguiseEntity.m_146926_(targetXRot);
        disguiseEntity.f_19859_ = originalMob.f_19859_;
        disguiseEntity.f_19860_ = originalMob.f_19860_;
        disguiseEntity.m_20256_(originalMob.m_20184_());
        if (disguiseEntity instanceof LivingEntity) {
            LivingEntity disguiseLiving = (LivingEntity)disguiseEntity;
            disguiseLiving.m_7910_(originalMob.m_6113_());
            disguiseLiving.m_20260_(originalMob.m_6144_());
            disguiseLiving.m_6858_(originalMob.m_20142_());
            disguiseLiving.m_6853_(originalMob.m_20096_());
            disguiseLiving.m_20124_(originalMob.m_20089_());
            disguiseLiving.f_20883_ = originalMob.f_20883_;
            disguiseLiving.f_20884_ = originalMob.f_20884_;
            disguiseLiving.f_20885_ = originalMob.f_20885_;
            disguiseLiving.f_20886_ = originalMob.f_20886_;
            disguiseLiving.f_20900_ = originalMob.f_20900_;
            disguiseLiving.f_20901_ = originalMob.f_20901_;
            disguiseLiving.f_20902_ = originalMob.f_20902_;
            disguiseLiving.f_267362_.m_267771_(originalMob.f_267362_.m_267731_());
            float currentPos = disguiseLiving.f_267362_.m_267756_();
            float targetPos = originalMob.f_267362_.m_267756_();
            float posDiff = targetPos - currentPos;
            if (Math.abs(posDiff) > 0.001f) {
                disguiseLiving.f_267362_.m_267566_(disguiseLiving.f_267362_.m_267731_(), 0.4f);
            }
        }
    }

    public static String getRandomDisguiseType() {
        return DISGUISE_TYPES[(int)(Math.random() * (double)DISGUISE_TYPES.length)];
    }

    public static void cleanupDisguise(UUID mobUUID) {
        Entity cachedEntity = disguiseEntityCache.remove(mobUUID);
        if (cachedEntity != null) {
            cachedEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

