/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.client.ChronoBlisterProjectileRenderer;
import com.hexvane.strangematter.client.EchoVacuumClientHandler;
import com.hexvane.strangematter.client.EchoingShadowRenderer;
import com.hexvane.strangematter.client.EnergeticRiftRenderer;
import com.hexvane.strangematter.client.GravityAnomalyRenderer;
import com.hexvane.strangematter.client.HoverboardRenderer;
import com.hexvane.strangematter.client.MiniWarpGateRenderer;
import com.hexvane.strangematter.client.ResearchMachineRenderer;
import com.hexvane.strangematter.client.ResonanceCondenserRenderer;
import com.hexvane.strangematter.client.ResonantBurnerRenderer;
import com.hexvane.strangematter.client.ResonantConduitRenderer;
import com.hexvane.strangematter.client.RiftStabilizerRenderer;
import com.hexvane.strangematter.client.StasisProjectorRenderer;
import com.hexvane.strangematter.client.TemporalBloomRenderer;
import com.hexvane.strangematter.client.ThoughtwellRenderer;
import com.hexvane.strangematter.client.WarpGateAnomalyRenderer;
import com.hexvane.strangematter.client.WarpProjectileRenderer;
import com.hexvane.strangematter.client.renderer.LevitationPadRenderer;
import com.hexvane.strangematter.client.renderer.ThrowableContainmentCapsuleRenderer;
import com.hexvane.strangematter.client.screen.RealityForgeScreen;
import com.hexvane.strangematter.client.screen.ResonanceCondenserScreen;
import com.hexvane.strangematter.client.screen.ResonantBurnerScreen;
import com.hexvane.strangematter.client.sound.AnomalySoundClientImpl;
import com.hexvane.strangematter.client.sound.CustomSoundManager;
import com.hexvane.strangematter.item.AnomalyResonatorItem;
import com.hexvane.strangematter.particle.EnergyAbsorptionParticle;
import com.hexvane.strangematter.platform.ClientServices;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="strangematter", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModEvents {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Strange Matter client initialized - prepare for reality distortion!");
        LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
        event.enqueueWork(() -> {
            EntityRenderers.m_174036_((EntityType)((EntityType)StrangeMatterMod.GRAVITY_ANOMALY.get()), GravityAnomalyRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)StrangeMatterMod.ENERGETIC_RIFT.get()), EnergeticRiftRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)StrangeMatterMod.ECHOING_SHADOW.get()), EchoingShadowRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)StrangeMatterMod.WARP_GATE_ANOMALY_ENTITY.get()), WarpGateAnomalyRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)StrangeMatterMod.TEMPORAL_BLOOM.get()), TemporalBloomRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)StrangeMatterMod.THOUGHTWELL.get()), ThoughtwellRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)StrangeMatterMod.WARP_PROJECTILE_ENTITY.get()), WarpProjectileRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)StrangeMatterMod.CHRONO_BLISTER_PROJECTILE_ENTITY.get()), ChronoBlisterProjectileRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)StrangeMatterMod.MINI_WARP_GATE_ENTITY.get()), MiniWarpGateRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)StrangeMatterMod.THROWABLE_CONTAINMENT_CAPSULE.get()), ThrowableContainmentCapsuleRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)StrangeMatterMod.HOVERBOARD_ENTITY.get()), HoverboardRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)StrangeMatterMod.RESEARCH_MACHINE_BLOCK_ENTITY.get()), ResearchMachineRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)StrangeMatterMod.STASIS_PROJECTOR_BLOCK_ENTITY.get()), StasisProjectorRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)StrangeMatterMod.RIFT_STABILIZER_BLOCK_ENTITY.get()), RiftStabilizerRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)StrangeMatterMod.RESONANT_CONDUIT_BLOCK_ENTITY.get()), ResonantConduitRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)StrangeMatterMod.LEVITATION_PAD_BLOCK_ENTITY.get()), LevitationPadRenderer::new);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)StrangeMatterMod.RESONITE_TRAPDOOR_BLOCK.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)StrangeMatterMod.RESONITE_DOOR_BLOCK.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)StrangeMatterMod.SHADE_SHARD_CRYSTAL.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)StrangeMatterMod.GRAVITIC_SHARD_CRYSTAL.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)StrangeMatterMod.ENERGETIC_SHARD_CRYSTAL.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)StrangeMatterMod.INSIGHT_SHARD_CRYSTAL.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)StrangeMatterMod.CHRONO_SHARD_CRYSTAL.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)StrangeMatterMod.SPATIAL_SHARD_CRYSTAL.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)StrangeMatterMod.TIME_DILATION_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)StrangeMatterMod.SHADE_SHARD_LANTERN.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)StrangeMatterMod.GRAVITIC_SHARD_LANTERN.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)StrangeMatterMod.ENERGETIC_SHARD_LANTERN.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)StrangeMatterMod.INSIGHT_SHARD_LANTERN.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)StrangeMatterMod.CHRONO_SHARD_LANTERN.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)StrangeMatterMod.SPATIAL_SHARD_LANTERN.get()), (RenderType)RenderType.m_110463_());
            MinecraftForge.EVENT_BUS.register((Object)new EchoVacuumClientHandler());
        });
        event.enqueueWork(() -> {
            CustomSoundManager.getInstance().initialize();
            ClientServices.setAnomalySoundClient(new AnomalySoundClientImpl());
        });
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)StrangeMatterMod.ANOMALY_RESONATOR.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"angle"), (stack, level, entity, seed) -> {
            if (level == null || entity == null) {
                return 0.0f;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                AnomalyResonatorItem resonator = (AnomalyResonatorItem)stack.m_41720_();
                BlockPos targetPos = AnomalyResonatorItem.getTargetPosition(stack, (Level)level, player);
                if (targetPos == null) {
                    return (float)((double)System.currentTimeMillis() * 0.1) % 1.0f;
                }
                double d0 = (double)targetPos.m_123341_() - entity.m_20185_();
                double d1 = (double)targetPos.m_123343_() - entity.m_20189_();
                float targetAngle = (float)(Math.atan2(d1, d0) * 57.29577951308232) - 90.0f;
                float playerYaw = entity.m_146908_();
                float relativeAngle = targetAngle - playerYaw;
                float wrappedAngle = Mth.m_14177_((float)relativeAngle);
                return (wrappedAngle + 180.0f) / 360.0f;
            }
            return 0.0f;
        }));
        event.enqueueWork(() -> Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)StrangeMatterMod.ENERGY_ABSORPTION_PARTICLE.get(), EnergyAbsorptionParticle.Provider::new));
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)StrangeMatterMod.RESONANCE_CONDENSER_MENU.get()), ResonanceCondenserScreen::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)StrangeMatterMod.RESONANCE_CONDENSER_BLOCK_ENTITY.get()), ResonanceCondenserRenderer::new);
            MenuScreens.m_96206_((MenuType)((MenuType)StrangeMatterMod.RESONANT_BURNER_MENU.get()), ResonantBurnerScreen::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)StrangeMatterMod.RESONANT_BURNER_BLOCK_ENTITY.get()), ResonantBurnerRenderer::new);
            MenuScreens.m_96206_((MenuType)((MenuType)StrangeMatterMod.REALITY_FORGE_MENU.get()), RealityForgeScreen::new);
        });
    }
}

