/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.hexvane.strangematter.GravityData;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientGravityHandler {
    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity) == Minecraft.m_91087_().f_91074_ && GravityData.hasPlayerGravityForce(player.m_20148_())) {
            double forceMultiplier = GravityData.getPlayerGravityForce(player.m_20148_());
            Vec3 currentVelocity = player.m_20184_();
            if (currentVelocity.f_82480_ < 0.0) {
                double gravityReduction = 1.0 - forceMultiplier * 0.9;
                Vec3 newVelocity = new Vec3(currentVelocity.f_82479_, currentVelocity.f_82480_ * gravityReduction, currentVelocity.f_82481_);
                double upwardForce = 0.15 * forceMultiplier;
                newVelocity = newVelocity.m_82520_(0.0, upwardForce, 0.0);
                player.m_20256_(newVelocity);
            }
            if (player.f_19789_ > 0.0f) {
                player.f_19789_ *= 1.0f - (float)(forceMultiplier * 0.8);
            }
        }
    }
}

