/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ChronoBlisterRenderer
implements IClientItemExtensions {
    private static final String CHARGING_TAG = "charging";
    private static final String CHARGE_TIME_TAG = "charge_time";
    private static final int MAX_CHARGE_TIME = 20;

    public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
        if (this.isCharging(itemInHand)) {
            int chargeTime = this.getChargeTime(itemInHand);
            float chargeProgress = Math.min(1.0f, (float)chargeTime / 20.0f);
            float forwardMovement = 0.3f + chargeProgress * 0.2f;
            float upMovement = -0.1f + chargeProgress * 0.1f;
            float armOffset = arm == HumanoidArm.RIGHT ? 0.56f : -0.56f;
            poseStack.m_252880_(armOffset, -0.52f + upMovement, -forwardMovement - 0.7f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(15.0f));
            float rotation = -15.0f - chargeProgress * 5.0f;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation));
            float vibration = (float)Math.sin((double)chargeProgress * Math.PI * 4.0) * 0.005f;
            poseStack.m_252880_(vibration, 0.0f, 0.0f);
            return true;
        }
        return false;
    }

    private boolean isCharging(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(CHARGING_TAG);
    }

    private int getChargeTime(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(CHARGE_TIME_TAG) : 0;
    }
}

