/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.TimeDilationData;
import com.hexvane.strangematter.entity.ChronoBlisterProjectileEntity;
import com.hexvane.strangematter.network.NetworkHandler;
import com.hexvane.strangematter.network.TimeDilationSyncPacket;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class TimeDilationBlockEntity
extends BlockEntity {
    private static final double SLOWDOWN_FACTOR = 0.3;
    private static final int MIN_DECAY_TICKS = 200;
    private static final int MAX_DECAY_TICKS = 600;
    private int ageTicks = 0;
    private int decayTimeTicks = -1;
    private Set<Player> affectedPlayers = new HashSet<Player>();

    public TimeDilationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StrangeMatterMod.TIME_DILATION_BLOCK_ENTITY.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TimeDilationBlockEntity blockEntity) {
        blockEntity.tick();
    }

    private void tick() {
        Level level = this.f_58857_;
        if (level == null || level.f_46443_) {
            return;
        }
        if (this.decayTimeTicks < 0) {
            this.decayTimeTicks = 200 + level.m_213780_().m_188503_(401);
        }
        ++this.ageTicks;
        if (this.ageTicks >= this.decayTimeTicks) {
            this.cleanupAllAffectedPlayers();
            level.m_7731_(this.f_58858_, Blocks.f_50016_.m_49966_(), 3);
            return;
        }
        AABB blockAABB = new AABB((double)this.f_58858_.m_123341_() - 0.25, (double)this.f_58858_.m_123342_() - 0.25, (double)this.f_58858_.m_123343_() - 0.25, (double)this.f_58858_.m_123341_() + 1.25, (double)this.f_58858_.m_123342_() + 1.25, (double)this.f_58858_.m_123343_() + 1.25);
        List entities = level.m_6249_((Entity)null, blockAABB, entity -> {
            if (entity instanceof ChronoBlisterProjectileEntity) {
                return false;
            }
            AABB entityAABB = entity.m_20191_();
            AABB exactBlockAABB = new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)this.f_58858_.m_123341_() + 1.0, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 1.0);
            return entityAABB.m_82381_(exactBlockAABB);
        });
        HashSet<Player> currentAffectedPlayers = new HashSet<Player>();
        for (Entity entity2 : entities) {
            Vec3 slowedVelocity;
            Vec3 currentVelocity = entity2.m_20184_();
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                if (!this.affectedPlayers.contains(player)) {
                    this.affectedPlayers.add(player);
                }
                currentAffectedPlayers.add(player);
                TimeDilationData.setPlayerSlowdownFactor(player.m_20148_(), 0.3);
                player.getPersistentData().m_128347_("strangematter.time_dilation_factor", 0.3);
                if (!level.f_46443_ && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new TimeDilationSyncPacket(0.3));
                }
                slowedVelocity = currentVelocity.m_82490_(0.3);
                player.m_20256_(slowedVelocity);
                continue;
            }
            slowedVelocity = currentVelocity.m_82490_(0.3);
            entity2.m_20256_(slowedVelocity);
        }
        HashSet<Player> playersToRemove = new HashSet<Player>(this.affectedPlayers);
        playersToRemove.removeAll(currentAffectedPlayers);
        for (Player player : playersToRemove) {
            this.cleanupPlayerEffect(player);
        }
        this.affectedPlayers = currentAffectedPlayers;
        for (Player player : new HashSet<Player>(this.affectedPlayers)) {
            BlockPos playerBlockPos = player.m_20183_();
            BlockPos playerFeetPos = player.m_20183_().m_7495_();
            boolean isInTimeDilation = level.m_8055_(playerBlockPos).m_60734_() == StrangeMatterMod.TIME_DILATION_BLOCK.get() || level.m_8055_(playerFeetPos).m_60734_() == StrangeMatterMod.TIME_DILATION_BLOCK.get();
            if (isInTimeDilation) continue;
            this.cleanupPlayerEffect(player);
            this.affectedPlayers.remove(player);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Age", this.ageTicks);
        tag.m_128405_("DecayTime", this.decayTimeTicks);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.ageTicks = tag.m_128451_("Age");
        this.decayTimeTicks = tag.m_128451_("DecayTime");
        if (this.decayTimeTicks < 0) {
            this.decayTimeTicks = -1;
        }
    }

    private void cleanupPlayerEffect(Player player) {
        boolean isInAnyTimeDilation;
        if (player == null || !player.m_6084_() || this.f_58857_ == null) {
            return;
        }
        BlockPos playerBlockPos = player.m_20183_();
        BlockPos playerFeetPos = player.m_20183_().m_7495_();
        boolean bl = isInAnyTimeDilation = this.f_58857_.m_8055_(playerBlockPos).m_60734_() == StrangeMatterMod.TIME_DILATION_BLOCK.get() || this.f_58857_.m_8055_(playerFeetPos).m_60734_() == StrangeMatterMod.TIME_DILATION_BLOCK.get();
        if (!isInAnyTimeDilation) {
            TimeDilationData.removePlayerSlowdownFactor(player.m_20148_());
            player.getPersistentData().m_128473_("strangematter.time_dilation_factor");
            if (!this.f_58857_.f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new TimeDilationSyncPacket(1.0));
            }
        }
    }

    public void cleanupAllAffectedPlayers() {
        if (this.f_58857_ == null) {
            return;
        }
        for (Player player : new HashSet<Player>(this.affectedPlayers)) {
            this.cleanupPlayerEffect(player);
        }
        this.affectedPlayers.clear();
    }
}

