/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.StrangeMatterMod;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class StasisProjectorBlockEntity
extends BlockEntity {
    private boolean powered = false;
    private UUID capturedEntityUUID = null;
    private UUID capturedItemEntityUUID = null;
    private Entity cachedEntity = null;
    private ItemEntity cachedItemEntity = null;
    private int fieldColor = 65535;
    private static final double FLOAT_HEIGHT = 0.25;
    private static final double CAPTURE_RADIUS = 0.5;

    public StasisProjectorBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)StrangeMatterMod.STASIS_PROJECTOR_BLOCK_ENTITY.get(), pos, blockState);
    }

    public void togglePower() {
        boolean bl = this.powered = !this.powered;
        if (!this.powered) {
            this.releaseAll();
        }
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    public int getFieldColor() {
        return this.fieldColor;
    }

    public void setFieldColor(int color) {
        this.fieldColor = color;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void releaseAll() {
        if (this.cachedEntity != null && this.f_58857_ != null) {
            Entity entity = this.cachedEntity;
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_21557_(false);
            }
            this.cachedEntity.m_20242_(false);
            this.cachedEntity.m_20331_(false);
            this.cachedEntity = null;
        }
        if (this.cachedItemEntity != null && this.f_58857_ != null) {
            this.cachedItemEntity.m_20242_(false);
            this.cachedItemEntity.m_32010_(10);
            this.cachedItemEntity = null;
        }
        this.capturedEntityUUID = null;
        this.capturedItemEntityUUID = null;
        this.m_6596_();
    }

    public ItemEntity getCapturedItemEntity() {
        return this.cachedItemEntity;
    }

    public Entity getCapturedEntity() {
        return this.cachedEntity;
    }

    public Level m_58904_() {
        return this.f_58857_;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StasisProjectorBlockEntity blockEntity) {
        List nearbyEntities;
        ItemEntity itemEntity;
        ServerLevel serverLevel;
        Entity entity;
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.powered) {
            return;
        }
        Vec3 centerPos = Vec3.m_82512_((Vec3i)pos).m_82520_(0.0, 0.25, 0.0);
        if (blockEntity.capturedEntityUUID != null && blockEntity.cachedEntity == null && level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_(blockEntity.capturedEntityUUID)) != null) {
            blockEntity.cachedEntity = entity;
        }
        if (blockEntity.capturedItemEntityUUID != null && blockEntity.cachedItemEntity == null && level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_(blockEntity.capturedItemEntityUUID)) instanceof ItemEntity) {
            blockEntity.cachedItemEntity = itemEntity = (ItemEntity)entity;
        }
        if (blockEntity.cachedEntity != null) {
            LivingEntity living;
            if (!blockEntity.cachedEntity.m_6084_() || blockEntity.cachedEntity.m_213877_()) {
                blockEntity.cachedEntity = null;
                blockEntity.capturedEntityUUID = null;
                blockEntity.m_6596_();
                return;
            }
            long gameTime = level.m_46467_();
            double bobOffset = Math.sin((double)(gameTime + 0L) / 10.0) * 0.1;
            Vec3 targetPos = new Vec3(centerPos.f_82479_, centerPos.f_82480_ + bobOffset, centerPos.f_82481_);
            blockEntity.cachedEntity.m_146884_(targetPos);
            blockEntity.cachedEntity.m_20256_(Vec3.f_82478_);
            blockEntity.cachedEntity.m_20242_(true);
            blockEntity.cachedEntity.m_20331_(true);
            Vec3 currentPos = blockEntity.cachedEntity.m_20182_();
            double distanceFromTarget = currentPos.m_82554_(targetPos);
            if (distanceFromTarget > 0.2) {
                blockEntity.cachedEntity.m_6021_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
                blockEntity.cachedEntity.m_20256_(Vec3.f_82478_);
            }
            float rotationSpeed = 4.0f;
            Entity entity2 = blockEntity.cachedEntity;
            if (entity2 instanceof LivingEntity) {
                float newYaw;
                living = (LivingEntity)entity2;
                living.f_20883_ = newYaw = (living.f_20883_ + rotationSpeed) % 360.0f;
                living.m_146922_(newYaw);
                living.f_20885_ = newYaw;
                living.m_146926_(0.0f);
            } else {
                float currentYaw = blockEntity.cachedEntity.m_146908_();
                float newYaw = (currentYaw + rotationSpeed) % 360.0f;
                blockEntity.cachedEntity.m_146922_(newYaw);
                blockEntity.cachedEntity.m_146926_(0.0f);
            }
            Entity entity3 = blockEntity.cachedEntity;
            if (entity3 instanceof Mob) {
                Mob mob = (Mob)entity3;
                mob.m_21557_(true);
                mob.m_21530_();
            }
            if ((entity3 = blockEntity.cachedEntity) instanceof LivingEntity) {
                living = (LivingEntity)entity3;
                living.m_20256_(Vec3.f_82478_);
            }
            return;
        }
        if (blockEntity.cachedItemEntity != null) {
            if (!blockEntity.cachedItemEntity.m_6084_() || blockEntity.cachedItemEntity.m_213877_()) {
                blockEntity.cachedItemEntity = null;
                blockEntity.capturedItemEntityUUID = null;
                blockEntity.m_6596_();
                return;
            }
            Vec3 targetPos = new Vec3(centerPos.f_82479_, centerPos.f_82480_, centerPos.f_82481_);
            blockEntity.cachedItemEntity.m_146884_(targetPos);
            blockEntity.cachedItemEntity.m_20256_(Vec3.f_82478_);
            blockEntity.cachedItemEntity.m_20242_(true);
            blockEntity.cachedItemEntity.m_32010_(40);
            blockEntity.cachedItemEntity.m_149678_();
            Vec3 currentPos = blockEntity.cachedItemEntity.m_20182_();
            double distanceFromTarget = currentPos.m_82554_(targetPos);
            if (distanceFromTarget > 0.1) {
                blockEntity.cachedItemEntity.m_6021_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
                blockEntity.cachedItemEntity.m_20256_(Vec3.f_82478_);
            }
            return;
        }
        AABB captureBox = new AABB(centerPos.m_82492_(0.5, 0.5, 0.5), centerPos.m_82520_(0.5, 0.5, 0.5));
        List nearbyItems = level.m_45976_(ItemEntity.class, captureBox);
        if (!nearbyItems.isEmpty()) {
            itemEntity = null;
            for (ItemEntity item : nearbyItems) {
                if (item.m_20068_() && item.m_32059_() >= 5980) continue;
                itemEntity = item;
                break;
            }
            if (itemEntity != null) {
                blockEntity.capturedItemEntityUUID = itemEntity.m_20148_();
                blockEntity.cachedItemEntity = itemEntity;
                itemEntity.m_6021_(centerPos.f_82479_, centerPos.f_82480_, centerPos.f_82481_);
                itemEntity.m_20256_(Vec3.f_82478_);
                itemEntity.m_20242_(true);
                itemEntity.m_32010_(40);
                itemEntity.m_149678_();
                blockEntity.m_6596_();
                return;
            }
        }
        if (!(nearbyEntities = level.m_45976_(Mob.class, captureBox)).isEmpty()) {
            Mob entity4 = null;
            for (Mob mob : nearbyEntities) {
                if (mob.m_20068_() && mob.m_21525_() && mob.m_20147_()) continue;
                entity4 = mob;
                break;
            }
            if (entity4 != null) {
                blockEntity.capturedEntityUUID = entity4.m_20148_();
                blockEntity.cachedEntity = entity4;
                entity4.m_6034_(centerPos.f_82479_, centerPos.f_82480_, centerPos.f_82481_);
                entity4.m_20256_(Vec3.f_82478_);
                entity4.m_20242_(true);
                entity4.m_20331_(true);
                entity4.m_21557_(true);
                entity4.m_21530_();
                blockEntity.m_6596_();
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("Powered", this.powered);
        tag.m_128405_("FieldColor", this.fieldColor);
        if (this.capturedEntityUUID != null) {
            tag.m_128362_("CapturedEntityUUID", this.capturedEntityUUID);
        }
        if (this.capturedItemEntityUUID != null) {
            tag.m_128362_("CapturedItemEntityUUID", this.capturedItemEntityUUID);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.powered = tag.m_128471_("Powered");
        this.fieldColor = tag.m_128451_("FieldColor");
        this.capturedEntityUUID = tag.m_128403_("CapturedEntityUUID") ? tag.m_128342_("CapturedEntityUUID") : null;
        this.capturedItemEntityUUID = tag.m_128403_("CapturedItemEntityUUID") ? tag.m_128342_("CapturedItemEntityUUID") : null;
    }
}

