/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.block.BaseMachineBlockEntity;
import com.hexvane.strangematter.block.RiftStabilizerBlock;
import com.hexvane.strangematter.entity.EnergeticRiftEntity;
import com.hexvane.strangematter.util.AnomalyUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class RiftStabilizerBlockEntity
extends BaseMachineBlockEntity {
    public static double BEAM_OFFSET_X = 0.0;
    public static double BEAM_OFFSET_Y = 0.5;
    public static double BEAM_OFFSET_Z = 0.0;
    private boolean isGenerating = false;
    private int currentPowerGeneration = 0;
    private EnergeticRiftEntity connectedRift = null;
    private int riftCheckCounter = 0;
    private static final int RIFT_CHECK_INTERVAL = 20;

    public RiftStabilizerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StrangeMatterMod.RIFT_STABILIZER_BLOCK_ENTITY.get(), pos, state, 0);
        boolean[] inputSides = new boolean[]{false, false, false, false, false, false};
        boolean[] outputSides = new boolean[]{false, false, false, false, false, false};
        this.energyStorage.setCapacity(Config.riftStabilizerEnergyStorage);
        this.energyStorage.setMaxReceive(Config.riftStabilizerEnergyPerTick * 2);
        this.energyStorage.setMaxExtract(Config.riftStabilizerTransferRate);
        Direction facing = (Direction)state.m_61143_((Property)RiftStabilizerBlock.FACING);
        Direction outputFace = facing.m_122424_();
        outputSides[outputFace.m_122411_()] = true;
        this.energyInputSides = inputSides;
        this.energyOutputSides = outputSides;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RiftStabilizerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        BaseMachineBlockEntity.tick(level, pos, state, blockEntity);
    }

    private void updatePowerGeneration(Level level, BlockPos pos) {
        Optional<EnergeticRiftEntity> riftOptional = AnomalyUtil.findNearestEnergeticRift(level, pos, Config.riftStabilizerRadius);
        boolean wasGenerating = this.isGenerating;
        if (riftOptional.isPresent()) {
            EnergeticRiftEntity rift = riftOptional.get();
            if (!this.isRiftInFrontOfNorthFace(rift, pos)) {
                this.isGenerating = false;
                this.connectedRift = null;
                this.currentPowerGeneration = 0;
            } else {
                int stabilizersConnected = this.countStabilizersConnectedToRift(level, rift);
                if (stabilizersConnected < Config.riftStabilizerMaxPerRift) {
                    this.isGenerating = true;
                    this.connectedRift = rift;
                    this.currentPowerGeneration = Config.riftStabilizerEnergyPerTick;
                } else {
                    this.isGenerating = false;
                    this.connectedRift = null;
                    this.currentPowerGeneration = 0;
                }
            }
        } else {
            this.isGenerating = false;
            this.connectedRift = null;
            this.currentPowerGeneration = 0;
        }
        if (wasGenerating != this.isGenerating) {
            this.m_6596_();
            if (level != null) {
                level.m_7260_(pos, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    private boolean isRiftInFrontOfNorthFace(EnergeticRiftEntity rift, BlockPos pos) {
        Vec3 northFaceDir;
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)RiftStabilizerBlock.FACING);
        Vec3 stabilizerPos = Vec3.m_82512_((Vec3i)pos);
        Vec3 riftPos = rift.m_20182_();
        Vec3 toRift = riftPos.m_82546_(stabilizerPos).m_82541_();
        double dotProduct = toRift.m_82526_(northFaceDir = Vec3.m_82528_((Vec3i)facing.m_122436_()));
        return dotProduct > 0.0;
    }

    private int countStabilizersConnectedToRift(Level level, EnergeticRiftEntity rift) {
        BlockPos riftPos = rift.m_20183_();
        double radius = Config.riftStabilizerRadius;
        int count = 0;
        int x = (int)(-radius);
        while ((double)x <= radius) {
            int y = (int)(-radius);
            while ((double)y <= radius) {
                int z = (int)(-radius);
                while ((double)z <= radius) {
                    BlockEntity be;
                    BlockPos checkPos = riftPos.m_7918_(x, y, z);
                    if (checkPos.m_123331_((Vec3i)riftPos) <= radius * radius && (be = level.m_7702_(checkPos)) instanceof RiftStabilizerBlockEntity) {
                        RiftStabilizerBlockEntity stabilizer = (RiftStabilizerBlockEntity)be;
                        if (stabilizer.connectedRift == rift || stabilizer.isWithinRangeOf(rift)) {
                            ++count;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return count;
    }

    private boolean isWithinRangeOf(EnergeticRiftEntity rift) {
        double distance = Math.sqrt(this.f_58858_.m_123331_((Vec3i)rift.m_20183_()));
        return distance <= Config.riftStabilizerRadius;
    }

    @Override
    protected BaseMachineBlockEntity.MachineEnergyRole getEnergyRole() {
        return BaseMachineBlockEntity.MachineEnergyRole.GENERATOR;
    }

    @Override
    protected void processMachine() {
        int generated;
        if (this.f_58857_ == null) {
            return;
        }
        ++this.riftCheckCounter;
        if (this.riftCheckCounter >= 20) {
            this.riftCheckCounter = 0;
            this.updatePowerGeneration(this.f_58857_, this.f_58858_);
        }
        if (this.isGenerating && this.currentPowerGeneration > 0 && (generated = this.energyStorage.receiveEnergy(this.currentPowerGeneration, false)) > 0) {
            this.m_6596_();
            if (this.riftCheckCounter == 0) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            }
        }
    }

    @Override
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory) {
        return null;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("energy", this.energyStorage.getEnergyStored());
        tag.m_128379_("isGenerating", this.isGenerating);
        tag.m_128405_("currentPowerGeneration", this.currentPowerGeneration);
        tag.m_128405_("riftCheckCounter", this.riftCheckCounter);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energyStorage.setEnergy(tag.m_128451_("energy"));
        this.isGenerating = tag.m_128471_("isGenerating");
        this.currentPowerGeneration = tag.m_128451_("currentPowerGeneration");
        this.riftCheckCounter = tag.m_128451_("riftCheckCounter");
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean isGenerating() {
        return this.isGenerating;
    }

    public int getCurrentPowerGeneration() {
        return this.currentPowerGeneration;
    }

    public EnergeticRiftEntity getConnectedRift() {
        return this.connectedRift;
    }

    public Vec3 getBeamTargetPos() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)RiftStabilizerBlock.FACING);
        double x = (double)this.f_58858_.m_123341_() + 0.5;
        double y = (double)this.f_58858_.m_123342_() + BEAM_OFFSET_Y;
        double z = (double)this.f_58858_.m_123343_() + 0.5;
        Direction northFace = facing;
        switch (northFace) {
            case NORTH: {
                x += BEAM_OFFSET_X;
                z -= 0.25 - BEAM_OFFSET_Z;
                break;
            }
            case SOUTH: {
                x += BEAM_OFFSET_X;
                z += 0.25 + BEAM_OFFSET_Z;
                break;
            }
            case WEST: {
                x -= 0.25 - BEAM_OFFSET_Z;
                z += BEAM_OFFSET_X;
                break;
            }
            case EAST: {
                x += 0.25 + BEAM_OFFSET_Z;
                z += BEAM_OFFSET_X;
                break;
            }
        }
        return new Vec3(x, y, z);
    }
}

