/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.block.BaseMachineBlockEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class ResonantConduitBlockEntity
extends BlockEntity {
    private final boolean[] connectedSides = new boolean[6];
    private final Map<BlockPos, Integer> cachedSources = new HashMap<BlockPos, Integer>();
    private final Map<BlockPos, Integer> cachedSinks = new HashMap<BlockPos, Integer>();
    private boolean networkCacheValid = false;
    private int networkUpdateCounter = 0;

    public ResonantConduitBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StrangeMatterMod.RESONANT_CONDUIT_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ResonantConduitBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        ++blockEntity.networkUpdateCounter;
        if (!blockEntity.networkCacheValid || blockEntity.networkUpdateCounter >= Config.resonantConduitNetworkUpdateInterval) {
            blockEntity.updateNetworkCache();
            blockEntity.networkUpdateCounter = 0;
        }
        blockEntity.performDirectEnergyRouting();
    }

    public void onNeighborChanged() {
        this.networkCacheValid = false;
        this.updateConnections();
    }

    private void updateConnections() {
        if (this.f_58857_ == null) {
            return;
        }
        Arrays.fill(this.connectedSides, false);
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = this.f_58858_.m_121945_(direction);
            BlockEntity adjacentEntity = this.f_58857_.m_7702_(adjacentPos);
            if (adjacentEntity == null || !(adjacentEntity instanceof ResonantConduitBlockEntity) && !adjacentEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).isPresent()) continue;
            this.connectedSides[direction.ordinal()] = true;
        }
        this.m_6596_();
    }

    private void updateNetworkCache() {
        if (this.f_58857_ == null) {
            return;
        }
        this.cachedSources.clear();
        this.cachedSinks.clear();
        this.findNetworkSourcesAndSinks(this.f_58858_, 0, new HashSet<BlockPos>());
        this.networkCacheValid = true;
    }

    private void findNetworkSourcesAndSinks(BlockPos pos, int distance, Set<BlockPos> visited) {
        if (distance > Config.resonantConduitMaxNetworkSize || visited.contains(pos)) {
            return;
        }
        visited.add(pos);
        for (Direction direction : Direction.values()) {
            BlockEntity adjacentEntity;
            BlockPos adjacentPos = pos.m_121945_(direction);
            if (visited.contains(adjacentPos) || (adjacentEntity = this.f_58857_.m_7702_(adjacentPos)) == null) continue;
            if (adjacentEntity instanceof ResonantConduitBlockEntity) {
                this.findNetworkSourcesAndSinks(adjacentPos, distance + 1, visited);
                continue;
            }
            adjacentEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(storage -> {
                if (storage.canExtract() && storage.getEnergyStored() > 0) {
                    this.cachedSources.put(adjacentPos, distance + 1);
                }
                if (storage.canReceive() && storage.getEnergyStored() < storage.getMaxEnergyStored()) {
                    this.cachedSinks.put(adjacentPos, distance + 1);
                }
            });
        }
    }

    private void performDirectEnergyRouting() {
        if (this.f_58857_ == null || !this.networkCacheValid) {
            return;
        }
        for (Map.Entry<BlockPos, Integer> sourceEntry : this.cachedSources.entrySet()) {
            BlockPos sourcePos = sourceEntry.getKey();
            int sourceDistance = sourceEntry.getValue();
            BlockEntity sourceEntity = this.f_58857_.m_7702_(sourcePos);
            if (sourceEntity == null) continue;
            sourceEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(sourceStorage -> {
                if (!sourceStorage.canExtract() || sourceStorage.getEnergyStored() <= 0) {
                    return;
                }
                for (Map.Entry<BlockPos, Integer> sinkEntry : this.cachedSinks.entrySet()) {
                    BlockPos sinkPos = sinkEntry.getKey();
                    int sinkDistance = sinkEntry.getValue();
                    BlockEntity sinkEntity = this.f_58857_.m_7702_(sinkPos);
                    if (sinkEntity == null) continue;
                    sinkEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(sinkStorage -> {
                        int energyReceived;
                        if (!sinkStorage.canReceive() || sinkStorage.getEnergyStored() >= sinkStorage.getMaxEnergyStored()) {
                            return;
                        }
                        if (!this.isRoleCompatibleTransfer(sourceEntity, sinkEntity)) {
                            return;
                        }
                        int totalDistance = sourceDistance + sinkDistance;
                        double distanceMultiplier = Math.max(0.1, 1.0 - (double)totalDistance * Config.resonantConduitDistancePenalty);
                        int transferRate = Math.max(1, (int)((double)Config.resonantConduitTransferRate * distanceMultiplier));
                        int energyToTransfer = Math.min(transferRate, Math.min(sourceStorage.getEnergyStored(), sinkStorage.getMaxEnergyStored() - sinkStorage.getEnergyStored()));
                        if (energyToTransfer > 0 && (energyReceived = sinkStorage.receiveEnergy(energyToTransfer, false)) > 0) {
                            sourceStorage.extractEnergy(energyReceived, false);
                        }
                    });
                }
            });
        }
    }

    public boolean isConnected(Direction direction) {
        return this.connectedSides[direction.ordinal()];
    }

    public List<Direction> getConnectedDirections() {
        ArrayList<Direction> connected = new ArrayList<Direction>();
        for (Direction direction : Direction.values()) {
            if (!this.connectedSides[direction.ordinal()]) continue;
            connected.add(direction);
        }
        return connected;
    }

    public int getConnectionCount() {
        int count = 0;
        for (boolean connected : this.connectedSides) {
            if (!connected) continue;
            ++count;
        }
        return count;
    }

    public boolean hasStraightConnection() {
        for (Direction direction : Direction.values()) {
            Direction opposite = direction.m_122424_();
            if (!this.connectedSides[direction.ordinal()] || !this.connectedSides[opposite.ordinal()]) continue;
            return true;
        }
        return false;
    }

    public boolean hasCornerConnection() {
        int connectionCount = this.getConnectionCount();
        return connectionCount == 2 && !this.hasStraightConnection();
    }

    public boolean hasIntersectionConnection() {
        return this.getConnectionCount() >= 3;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        byte[] connectionBytes = new byte[6];
        for (int i = 0; i < 6; ++i) {
            connectionBytes[i] = (byte)(this.connectedSides[i] ? 1 : 0);
        }
        tag.m_128382_("connections", connectionBytes);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("connections")) {
            byte[] connectionBytes = tag.m_128463_("connections");
            for (int i = 0; i < 6 && i < connectionBytes.length; ++i) {
                this.connectedSides[i] = connectionBytes[i] != 0;
            }
        }
        this.networkCacheValid = false;
    }

    public void forceUpdateConnections() {
        this.networkCacheValid = false;
        this.updateConnections();
    }

    private boolean isRoleCompatibleTransfer(BlockEntity sourceEntity, BlockEntity sinkEntity) {
        if (sourceEntity instanceof BaseMachineBlockEntity) {
            BaseMachineBlockEntity sourceMachine = (BaseMachineBlockEntity)sourceEntity;
            if (sinkEntity instanceof BaseMachineBlockEntity) {
                BaseMachineBlockEntity sinkMachine = (BaseMachineBlockEntity)sinkEntity;
                BaseMachineBlockEntity.MachineEnergyRole sourceRole = sourceMachine.getEnergyRole();
                BaseMachineBlockEntity.MachineEnergyRole sinkRole = sinkMachine.getEnergyRole();
                return sourceRole == BaseMachineBlockEntity.MachineEnergyRole.GENERATOR && sinkRole == BaseMachineBlockEntity.MachineEnergyRole.CONSUMER;
            }
        }
        return true;
    }
}

