/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.block.ResonantConduitBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class ResonantConduitBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    private static final VoxelShape CORE_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)6.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)7.0, (double)7.0, (double)10.0, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)10.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)6.0, (double)9.0, (double)9.0);
    private static final VoxelShape UP_SHAPE = Block.m_49796_((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0);

    public ResonantConduitBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60999_().m_60953_(state -> 3).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.updateConnections(this.m_49966_(), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return this.updateConnections(state, level, pos);
    }

    private BlockState updateConnections(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockState newState = state;
        for (Direction direction : Direction.values()) {
            boolean connected = this.canConnectTo(level, pos.m_121945_(direction), direction);
            newState = (BlockState)newState.m_61124_((Property)this.getPropertyForDirection(direction), (Comparable)Boolean.valueOf(connected));
        }
        return newState;
    }

    private boolean canConnectTo(LevelAccessor level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            return false;
        }
        if (blockEntity instanceof ResonantConduitBlockEntity) {
            return true;
        }
        return blockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).isPresent();
    }

    private BooleanProperty getPropertyForDirection(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = CORE_SHAPE;
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)UP_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DOWN_SHAPE);
        }
        return shape;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, level, pos, context);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7923_(BlockState state) {
        return false;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ResonantConduitBlockEntity) {
            ResonantConduitBlockEntity conduit = (ResonantConduitBlockEntity)blockEntity;
            conduit.onNeighborChanged();
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ResonantConduitBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == StrangeMatterMod.RESONANT_CONDUIT_BLOCK_ENTITY.get() && !level.f_46443_ ? (level1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof ResonantConduitBlockEntity) {
                ResonantConduitBlockEntity conduit = (ResonantConduitBlockEntity)blockEntity;
                ResonantConduitBlockEntity.tick(level1, pos, state1, conduit);
            }
        } : null;
    }

    public boolean isConnected(BlockState state, Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> (Boolean)state.m_61143_((Property)NORTH);
            case Direction.SOUTH -> (Boolean)state.m_61143_((Property)SOUTH);
            case Direction.EAST -> (Boolean)state.m_61143_((Property)EAST);
            case Direction.WEST -> (Boolean)state.m_61143_((Property)WEST);
            case Direction.UP -> (Boolean)state.m_61143_((Property)UP);
            case Direction.DOWN -> (Boolean)state.m_61143_((Property)DOWN);
        };
    }

    public int getConnectionCount(BlockState state) {
        int count = 0;
        for (Direction direction : Direction.values()) {
            if (!this.isConnected(state, direction)) continue;
            ++count;
        }
        return count;
    }

    public boolean hasStraightConnection(BlockState state) {
        for (Direction direction : Direction.values()) {
            if (!this.isConnected(state, direction) || !this.isConnected(state, direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    public boolean hasCornerConnection(BlockState state) {
        int connectionCount = this.getConnectionCount(state);
        return connectionCount == 2 && !this.hasStraightConnection(state);
    }

    public boolean hasIntersectionConnection(BlockState state) {
        return this.getConnectionCount(state) >= 3;
    }
}

