/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.block.BaseMachineBlockEntity;
import com.hexvane.strangematter.menu.ResonantBurnerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;

public class ResonantBurnerBlockEntity
extends BaseMachineBlockEntity {
    private int burnTime = 0;
    private int burnDuration = 0;
    private int fuelSlot = 0;
    private int energyPerTick;
    private int maxEnergyStorage;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private final ContainerData burnDataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ResonantBurnerBlockEntity.this.energyStorage.getEnergyStored();
                case 1 -> ResonantBurnerBlockEntity.this.energyStorage.getMaxEnergyStored();
                case 2 -> {
                    if (ResonantBurnerBlockEntity.this.isActive) {
                        yield 1;
                    }
                    yield 0;
                }
                case 3 -> ResonantBurnerBlockEntity.this.energyPerTick;
                case 4 -> ResonantBurnerBlockEntity.this.maxEnergyStorage;
                case 5 -> ResonantBurnerBlockEntity.this.burnTime;
                case 6 -> ResonantBurnerBlockEntity.this.burnDuration;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ResonantBurnerBlockEntity.this.energyStorage.setEnergy(value);
                    break;
                }
                case 1: {
                    ResonantBurnerBlockEntity.this.energyStorage.setCapacity(value);
                    break;
                }
                case 2: {
                    ResonantBurnerBlockEntity.this.isActive = value != 0;
                    break;
                }
                case 3: {
                    ResonantBurnerBlockEntity.this.energyPerTick = value;
                    break;
                }
                case 4: {
                    ResonantBurnerBlockEntity.this.maxEnergyStorage = value;
                    break;
                }
                case 5: {
                    ResonantBurnerBlockEntity.this.burnTime = value;
                    break;
                }
                case 6: {
                    ResonantBurnerBlockEntity.this.burnDuration = value;
                }
            }
        }

        public int m_6499_() {
            return 7;
        }
    };

    public ResonantBurnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StrangeMatterMod.RESONANT_BURNER_BLOCK_ENTITY.get(), pos, state, 1);
        this.energyPerTick = Config.resonantBurnerEnergyPerTick;
        this.maxEnergyStorage = Config.resonantBurnerEnergyStorage;
        this.energyStorage.setCapacity(this.maxEnergyStorage);
        boolean[] inputSides = new boolean[]{false, false, false, false, false, false};
        this.setEnergyInputSides(inputSides);
        boolean[] outputSides = new boolean[]{true, true, true, true, true, true};
        this.setEnergyOutputSides(outputSides);
    }

    @Override
    protected int getEnergyTransferRate() {
        return Config.resonantBurnerTransferRate;
    }

    @Override
    protected BaseMachineBlockEntity.MachineEnergyRole getEnergyRole() {
        return BaseMachineBlockEntity.MachineEnergyRole.GENERATOR;
    }

    @Override
    protected void processMachine() {
        this.processFuelBurning();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ResonantBurnerBlockEntity blockEntity) {
        BaseMachineBlockEntity.tick(level, pos, state, blockEntity);
    }

    private void processFuelBurning() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ItemStack fuelStack;
            int burnTimeForFuel;
            boolean wasBurning = this.burnTime > 0;
            boolean shouldUpdate = false;
            if (this.burnTime > 0) {
                int energyToAdd;
                --this.burnTime;
                this.setActive(true);
                if (this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored() && (energyToAdd = Math.min(this.energyPerTick, this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored())) > 0) {
                    int oldEnergy = this.energyStorage.getEnergyStored();
                    this.energyStorage.receiveEnergy(energyToAdd, false);
                    shouldUpdate = true;
                    this.syncEnergyToClient();
                }
            } else {
                this.setActive(false);
            }
            if (this.burnTime <= 0 && !((ItemStack)this.items.get(this.fuelSlot)).m_41619_() && (burnTimeForFuel = ForgeHooks.getBurnTime((ItemStack)(fuelStack = (ItemStack)this.items.get(this.fuelSlot)), null)) > 0) {
                this.burnDuration = burnTimeForFuel;
                this.burnTime = burnTimeForFuel;
                if (fuelStack.hasCraftingRemainingItem()) {
                    this.items.set(this.fuelSlot, (Object)fuelStack.getCraftingRemainingItem());
                } else {
                    fuelStack.m_41774_(1);
                    if (fuelStack.m_41619_()) {
                        this.items.set(this.fuelSlot, (Object)ItemStack.f_41583_);
                    }
                }
                shouldUpdate = true;
            }
            if (wasBurning != this.burnTime > 0 || shouldUpdate) {
                this.m_6596_();
                this.syncToClient();
            }
        }
    }

    @Override
    protected void clientTick() {
        if (this.burnTime > 0 && this.f_58857_ != null && this.f_58857_.m_213780_().m_188501_() < 0.1f) {
            double x = (double)this.f_58858_.m_123341_() + 0.5;
            double y = (double)this.f_58858_.m_123342_() + 0.5;
            double z = (double)this.f_58858_.m_123343_() + 0.5;
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + (this.f_58857_.m_213780_().m_188500_() - 0.5) * 0.5, y + 0.1, z + (this.f_58857_.m_213780_().m_188500_() - 0.5) * 0.5, 0.0, 0.1, 0.0);
        }
    }

    @Override
    public int m_6643_() {
        return this.items.size();
    }

    @Override
    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    @Override
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    @Override
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    @Override
    public void m_6836_(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
        this.syncToClient();
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public void m_6211_() {
        this.items.clear();
    }

    @Override
    public boolean m_7013_(int index, ItemStack stack) {
        if (index == this.fuelSlot) {
            return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
        }
        return false;
    }

    @Override
    public Component m_5446_() {
        return Component.m_237115_((String)"block.strangematter.resonant_burner");
    }

    @Override
    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new ResonantBurnerMenu(id, playerInventory, this.m_58899_());
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getBurnDuration() {
        return this.burnDuration;
    }

    public float getBurnProgress() {
        if (this.burnDuration <= 0) {
            return 0.0f;
        }
        return (float)this.burnTime / (float)this.burnDuration;
    }

    @Override
    public ContainerData getDataAccess() {
        return this.burnDataAccess;
    }

    @Override
    protected void writeAdditionalStateData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.burnTime);
        buffer.writeInt(this.burnDuration);
    }

    @Override
    protected void readAdditionalStateData(FriendlyByteBuf buffer) {
        this.burnTime = buffer.readInt();
        this.burnDuration = buffer.readInt();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("burn_time", this.burnTime);
        tag.m_128405_("burn_duration", this.burnDuration);
        tag.m_128405_("fuel_slot", this.fuelSlot);
        tag.m_128405_("energy_per_tick", this.energyPerTick);
        tag.m_128405_("max_energy_storage", this.maxEnergyStorage);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.burnTime = tag.m_128451_("burn_time");
        this.burnDuration = tag.m_128451_("burn_duration");
        this.fuelSlot = tag.m_128451_("fuel_slot");
        this.energyPerTick = tag.m_128451_("energy_per_tick");
        this.maxEnergyStorage = tag.m_128451_("max_energy_storage");
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }
}

