/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.block.BaseMachineBlockEntity;
import com.hexvane.strangematter.entity.BaseAnomalyEntity;
import com.hexvane.strangematter.menu.ResonanceCondenserMenu;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.research.ScannableObject;
import com.hexvane.strangematter.research.ScannableObjectRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ResonanceCondenserBlockEntity
extends BaseMachineBlockEntity {
    private int tickCounter = 0;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private BaseAnomalyEntity cachedAnomaly = null;
    private int anomalyCheckCounter = 0;
    private final IItemHandler machineInventory = new InvWrapper((Container)this);

    public ResonanceCondenserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StrangeMatterMod.RESONANCE_CONDENSER_BLOCK_ENTITY.get(), pos, state, 1);
        this.energyPerTick = Config.resonanceCondenserEnergyPerTick;
        this.maxEnergyStorage = Config.resonanceCondenserEnergyStorage;
        this.energyStorage.setCapacity(this.maxEnergyStorage);
        boolean[] inputSides = new boolean[]{true, true, true, true, true, true};
        this.setEnergyInputSides(inputSides);
        boolean[] outputSides = new boolean[]{false, false, false, false, false, false};
        this.setEnergyOutputSides(outputSides);
    }

    @Override
    protected BaseMachineBlockEntity.MachineEnergyRole getEnergyRole() {
        return BaseMachineBlockEntity.MachineEnergyRole.CONSUMER;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ResonanceCondenserBlockEntity blockEntity) {
        ++blockEntity.tickCounter;
        if (!level.f_46443_) {
            blockEntity.processResonance();
        }
        if (level.f_46443_ && blockEntity.tickCounter % 5 == 0) {
            blockEntity.spawnParticles(level, pos);
        }
    }

    private void processResonance() {
        if (!this.f_58857_.f_46443_) {
            ++this.anomalyCheckCounter;
            if (this.anomalyCheckCounter >= 20 || this.cachedAnomaly == null || !this.cachedAnomaly.m_6084_()) {
                this.anomalyCheckCounter = 0;
                this.findNearbyAnomaly();
            }
            if (this.cachedAnomaly != null && this.cachedAnomaly.m_6084_()) {
                if (!this.hasEnergy() || !this.consumeEnergy(this.energyPerTick)) {
                    this.setActive(false);
                    return;
                }
                this.setActive(true);
                int progressSpeed = Config.resonanceCondenserProgressSpeed;
                if (this.tickCounter >= progressSpeed) {
                    this.tickCounter = 0;
                    if (this.progressLevel < this.maxProgressLevel) {
                        this.progressLevel = Math.min(this.progressLevel + 1, this.maxProgressLevel);
                        this.m_6596_();
                        this.syncToClient();
                    }
                    if (this.progressLevel >= this.maxProgressLevel) {
                        this.generateShardFromNearbyAnomaly();
                        this.progressLevel = 0;
                        this.m_6596_();
                        this.syncToClient();
                    }
                }
            } else {
                this.setActive(false);
                this.cachedAnomaly = null;
            }
        }
    }

    private void findNearbyAnomaly() {
        BlockPos pos = this.m_58899_();
        this.cachedAnomaly = null;
        for (Entity entity : this.f_58857_.m_45976_(Entity.class, AABB.m_165882_((Vec3)pos.m_252807_(), (double)20.0, (double)20.0, (double)20.0))) {
            BaseAnomalyEntity anomaly;
            if (!(entity instanceof BaseAnomalyEntity) || !(anomaly = (BaseAnomalyEntity)entity).m_6084_()) continue;
            this.cachedAnomaly = anomaly;
            break;
        }
    }

    private void spawnParticles(Level level, BlockPos pos) {
        if (level.f_46443_) {
            for (Entity entity : level.m_45976_(Entity.class, AABB.m_165882_((Vec3)pos.m_252807_(), (double)16.0, (double)16.0, (double)16.0))) {
                if (!(entity instanceof BaseAnomalyEntity)) continue;
                this.spawnEnergyParticles(level, entity.m_20182_(), pos);
            }
        }
    }

    private void spawnEnergyParticles(Level level, Vec3 anomalyPos, BlockPos condenserPos) {
        RandomSource random = level.m_213780_();
        for (int i = 0; i < 3; ++i) {
            double angle = random.m_188500_() * Math.PI * 2.0;
            double height = random.m_188500_() * 2.0 - 1.0;
            double radius = 2.0 + random.m_188500_() * 3.0;
            double x = anomalyPos.f_82479_ + Math.cos(angle) * radius;
            double y = anomalyPos.f_82480_ + height;
            double z = anomalyPos.f_82481_ + Math.sin(angle) * radius;
            double targetX = (double)condenserPos.m_123341_() + 0.5;
            double targetY = (double)condenserPos.m_123342_() + 2.0;
            double targetZ = (double)condenserPos.m_123343_() + 0.5;
            level.m_7106_((ParticleOptions)StrangeMatterMod.ENERGY_ABSORPTION_PARTICLE.get(), x, y, z, targetX, targetY, targetZ);
        }
    }

    private void generateShardFromNearbyAnomaly() {
        if (this.f_58857_ == null) {
            System.out.println("generateShardFromNearbyAnomaly: level is null!");
            return;
        }
        if (this.cachedAnomaly == null || !this.cachedAnomaly.m_6084_()) {
            return;
        }
        Item shardItem = null;
        Optional<ScannableObject> scannableOpt = ScannableObjectRegistry.getScannableForEntity(this.cachedAnomaly);
        if (scannableOpt.isPresent()) {
            ResearchType researchType = scannableOpt.get().getResearchType();
            shardItem = this.getShardItemForResearchType(researchType);
        }
        if (shardItem != null) {
            ItemStack shardStack = new ItemStack(shardItem);
            ItemStack currentStack = (ItemStack)this.items.get(0);
            if (currentStack.m_41619_()) {
                this.m_6836_(0, shardStack);
                this.m_6596_();
                this.syncToClient();
            } else if (currentStack.m_150930_(shardItem) && currentStack.m_41613_() < currentStack.m_41741_()) {
                currentStack.m_41769_(1);
                this.m_6596_();
                this.syncToClient();
            }
        }
    }

    private Item getShardItemForResearchType(ResearchType researchType) {
        return switch (researchType) {
            default -> throw new IncompatibleClassChangeError();
            case ResearchType.GRAVITY -> (Item)StrangeMatterMod.GRAVITIC_SHARD.get();
            case ResearchType.TIME -> (Item)StrangeMatterMod.CHRONO_SHARD.get();
            case ResearchType.SPACE -> (Item)StrangeMatterMod.SPATIAL_SHARD.get();
            case ResearchType.SHADOW -> (Item)StrangeMatterMod.SHADE_SHARD.get();
            case ResearchType.COGNITION -> (Item)StrangeMatterMod.INSIGHT_SHARD.get();
            case ResearchType.ENERGY -> (Item)StrangeMatterMod.ENERGETIC_SHARD.get();
        };
    }

    @Override
    public int m_6643_() {
        return this.items.size();
    }

    @Override
    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    @Override
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    @Override
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    @Override
    public void m_6836_(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
        this.syncToClient();
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public void m_6211_() {
        this.items.clear();
    }

    @Override
    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 0) {
            ItemStack currentStack = (ItemStack)this.items.get(0);
            return currentStack.m_41619_() || currentStack.m_150930_(stack.m_41720_()) && currentStack.m_41613_() < currentStack.m_41741_();
        }
        return false;
    }

    @Override
    public void syncToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int getProgressLevel() {
        return this.progressLevel;
    }

    public int getMaxProgressLevel() {
        return this.maxProgressLevel;
    }

    @Override
    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    @Override
    protected void writeAdditionalStateData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.progressLevel);
        buffer.writeInt(this.maxProgressLevel);
    }

    @Override
    protected void readAdditionalStateData(FriendlyByteBuf buffer) {
        this.progressLevel = buffer.readInt();
        this.maxProgressLevel = buffer.readInt();
    }

    public void sendGuiNetworkData(AbstractContainerMenu container, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.sendStatePacket();
        }
    }

    @Override
    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new ResonanceCondenserMenu(id, playerInventory, this.m_58899_());
    }

    @Override
    protected void processMachine() {
        this.processResonance();
    }

    @Override
    public Component m_5446_() {
        return Component.m_237115_((String)"block.strangematter.resonance_condenser");
    }

    public void setProgressLevel(int level) {
        this.progressLevel = Math.max(0, Math.min(level, this.maxProgressLevel));
        this.m_6596_();
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        this.m_6596_();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("progress_level", this.progressLevel);
        tag.m_128379_("is_active", this.isActive);
        tag.m_128405_("tick_counter", this.tickCounter);
        tag.m_128405_("anomaly_check_counter", this.anomalyCheckCounter);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progressLevel = tag.m_128451_("progress_level");
        this.isActive = tag.m_128471_("is_active");
        this.tickCounter = tag.m_128451_("tick_counter");
        this.anomalyCheckCounter = tag.m_128451_("anomaly_check_counter");
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.cachedAnomaly = null;
    }
}

