/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.item.ResearchNoteItem;
import com.hexvane.strangematter.network.NetworkHandler;
import com.hexvane.strangematter.network.ResearchMachineSyncPacket;
import com.hexvane.strangematter.research.ResearchData;
import com.hexvane.strangematter.research.ResearchNode;
import com.hexvane.strangematter.research.ResearchNodeRegistry;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class ResearchMachineBlockEntity
extends BlockEntity {
    private MachineState currentState = MachineState.IDLE;
    private String currentResearchId = "";
    private Set<ResearchType> activeResearchTypes = new HashSet<ResearchType>();
    private float instabilityLevel = 0.5f;
    private int researchTicks = 0;
    private UUID playerId = null;
    private UUID currentPlayerId = null;
    private Map<ResearchType, Map<String, Object>> minigameStates = new HashMap<ResearchType, Map<String, Object>>();

    public ResearchMachineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StrangeMatterMod.RESEARCH_MACHINE_BLOCK_ENTITY.get(), pos, state);
    }

    public boolean insertResearchNote(ItemStack researchNote, Player player) {
        if (this.currentState != MachineState.IDLE) {
            return false;
        }
        if (ResearchNoteItem.isValidResearchNote(researchNote)) {
            this.currentResearchId = ResearchNoteItem.getResearchId(researchNote);
            this.activeResearchTypes = ResearchNoteItem.getResearchTypes(researchNote);
            this.playerId = player.m_20148_();
            if (!Config.enableMinigames) {
                if (!this.f_58857_.f_46443_) {
                    this.handleResearchCompletion();
                }
                return true;
            }
            this.currentState = MachineState.READY;
            this.instabilityLevel = 0.5f;
            this.researchTicks = 0;
            this.m_6596_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_NOTE_INSERT.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
            }
            this.sendSyncPacket();
            return true;
        }
        return false;
    }

    public void beginResearch() {
        if (this.currentState == MachineState.READY) {
            this.currentState = MachineState.RESEARCHING;
            this.researchTicks = 0;
            this.m_6596_();
        }
    }

    public void handleResearchCompletion() {
        Player player;
        if (this.playerId != null && !this.f_58857_.f_46443_ && (player = this.f_58857_.m_46003_(this.playerId)) != null) {
            ResearchData researchData = ResearchData.get(player);
            boolean alreadyUnlocked = researchData.hasUnlockedResearch(this.currentResearchId);
            if (alreadyUnlocked) {
                player.m_213846_((Component)Component.m_237110_((String)"block.strangematter.research_machine.research_already_unlocked", (Object[])new Object[]{ResearchNodeRegistry.getNode(this.currentResearchId).getDisplayName()}));
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_SUCCESS.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
            } else {
                researchData.unlockResearch(this.currentResearchId);
                researchData.syncToClient((ServerPlayer)player);
                ResearchNode researchNode = ResearchNodeRegistry.getNode(this.currentResearchId);
                if (researchNode != null && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    for (ResearchType researchType : researchNode.getResearchCosts().keySet()) {
                        StrangeMatterMod.COMPLETE_RESEARCH_CATEGORY_TRIGGER.trigger(serverPlayer, researchType.getName());
                    }
                }
                player.m_213846_((Component)Component.m_237110_((String)"block.strangematter.research_machine.research_completed_success", (Object[])new Object[]{ResearchNodeRegistry.getNode(this.currentResearchId).getDisplayName()}));
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_SUCCESS.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
            }
            for (int i = 0; i < 20; ++i) {
                double offsetX = (this.f_58857_.m_213780_().m_188500_() - 0.5) * 2.0;
                double offsetY = this.f_58857_.m_213780_().m_188500_() * 1.5;
                double offsetZ = (this.f_58857_.m_213780_().m_188500_() - 0.5) * 2.0;
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)this.f_58858_.m_123341_() + 0.5 + offsetX, (double)this.f_58858_.m_123342_() + 0.5 + offsetY, (double)this.f_58858_.m_123343_() + 0.5 + offsetZ, 0.0, 0.1, 0.0);
            }
        }
        this.currentState = MachineState.COMPLETED;
        this.m_6596_();
        this.sendSyncPacket();
        this.f_58857_.m_7654_().m_6937_((Runnable)new TickTask(100, () -> {
            if (!this.f_58857_.f_46443_) {
                this.clearResearch();
                this.sendSyncPacket();
            }
        }));
    }

    private ItemStack createResearchNoteFromStoredData() {
        if (this.currentResearchId.isEmpty() || this.activeResearchTypes.isEmpty()) {
            return ItemStack.f_41583_;
        }
        HashMap<ResearchType, Integer> researchCosts = new HashMap<ResearchType, Integer>();
        for (ResearchType type : this.activeResearchTypes) {
            researchCosts.put(type, 1);
        }
        return ResearchNoteItem.createResearchNote(researchCosts, this.currentResearchId);
    }

    private void dropResearchNote() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        ItemStack researchNote = this.createResearchNoteFromStoredData();
        if (!researchNote.m_41619_()) {
            ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5, researchNote);
            itemEntity.m_32060_();
            this.f_58857_.m_7967_((Entity)itemEntity);
        }
    }

    public void handleResearchFailure() {
        Player player;
        if (this.playerId != null && !this.f_58857_.f_46443_ && (player = this.f_58857_.m_46003_(this.playerId)) != null) {
            player.m_213846_((Component)Component.m_237115_((String)"block.strangematter.research_machine.research_failed"));
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_FAILURE.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
        }
        this.dropResearchNote();
        this.currentState = MachineState.FAILED;
        this.m_6596_();
        this.sendSyncPacket();
        this.f_58857_.m_7654_().m_6937_((Runnable)new TickTask(60, () -> {
            if (!this.f_58857_.f_46443_) {
                this.clearResearch();
                this.sendSyncPacket();
            }
        }));
    }

    public void clearResearch() {
        this.currentState = MachineState.IDLE;
        this.currentResearchId = "";
        this.activeResearchTypes.clear();
        this.instabilityLevel = 0.5f;
        this.researchTicks = 0;
        this.playerId = null;
        this.m_6596_();
    }

    public MachineState getCurrentState() {
        return this.currentState;
    }

    public String getCurrentResearchId() {
        return this.currentResearchId;
    }

    public Set<ResearchType> getActiveResearchTypes() {
        return this.activeResearchTypes;
    }

    public float getInstabilityLevel() {
        return this.instabilityLevel;
    }

    public int getResearchTicks() {
        return this.researchTicks;
    }

    public boolean canInsertResearchNote() {
        return this.currentState == MachineState.IDLE;
    }

    public boolean canBeginResearch() {
        return this.currentState == MachineState.READY;
    }

    public void setClientInstabilityLevel(float instability) {
        this.instabilityLevel = instability;
    }

    public void deactivateAllMinigames() {
    }

    public void sendSyncPacket() {
        if (!this.f_58857_.f_46443_) {
            ResearchMachineSyncPacket packet = new ResearchMachineSyncPacket(this.f_58858_, this.currentState, this.currentResearchId, this.activeResearchTypes, this.instabilityLevel, this.researchTicks);
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)packet);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("state", this.currentState.name());
        tag.m_128359_("research_id", this.currentResearchId);
        tag.m_128350_("instability", this.instabilityLevel);
        tag.m_128405_("research_ticks", this.researchTicks);
        if (this.playerId != null) {
            tag.m_128362_("player_id", this.playerId);
        }
        if (this.currentPlayerId != null) {
            tag.m_128362_("current_player_id", this.currentPlayerId);
        }
        CompoundTag typesTag = new CompoundTag();
        for (ResearchType type : this.activeResearchTypes) {
            typesTag.m_128379_(type.name(), true);
        }
        tag.m_128365_("active_types", (Tag)typesTag);
        CompoundTag minigameStatesTag = new CompoundTag();
        for (Map.Entry<ResearchType, Map<String, Object>> entry : this.minigameStates.entrySet()) {
            CompoundTag stateTag = new CompoundTag();
            Map<String, Object> state = entry.getValue();
            for (Map.Entry<String, Object> stateEntry : state.entrySet()) {
                Object value = stateEntry.getValue();
                if (value instanceof Boolean) {
                    stateTag.m_128379_(stateEntry.getKey(), ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof String) {
                    stateTag.m_128359_(stateEntry.getKey(), (String)value);
                    continue;
                }
                if (value instanceof Double) {
                    stateTag.m_128347_(stateEntry.getKey(), ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Integer) {
                    stateTag.m_128405_(stateEntry.getKey(), ((Integer)value).intValue());
                    continue;
                }
                stateTag.m_128359_(stateEntry.getKey(), value.toString());
            }
            minigameStatesTag.m_128365_(entry.getKey().name(), (Tag)stateTag);
        }
        tag.m_128365_("minigame_states", (Tag)minigameStatesTag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        try {
            String stateStr = tag.m_128461_("state");
            this.currentState = !stateStr.isEmpty() ? MachineState.valueOf(stateStr) : MachineState.IDLE;
        }
        catch (IllegalArgumentException e) {
            this.currentState = MachineState.IDLE;
        }
        this.currentResearchId = tag.m_128461_("research_id");
        if (this.currentResearchId == null) {
            this.currentResearchId = "";
        }
        this.instabilityLevel = tag.m_128441_("instability") ? tag.m_128457_("instability") : 0.5f;
        this.researchTicks = tag.m_128441_("research_ticks") ? tag.m_128451_("research_ticks") : 0;
        this.playerId = tag.m_128441_("player_id") ? tag.m_128342_("player_id") : null;
        this.currentPlayerId = tag.m_128441_("current_player_id") ? tag.m_128342_("current_player_id") : null;
        this.activeResearchTypes.clear();
        if (tag.m_128441_("active_types")) {
            CompoundTag typesTag = tag.m_128469_("active_types");
            for (String typeName : typesTag.m_128431_()) {
                if (!typesTag.m_128471_(typeName)) continue;
                try {
                    this.activeResearchTypes.add(ResearchType.valueOf(typeName));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        this.minigameStates.clear();
        if (tag.m_128441_("minigame_states")) {
            CompoundTag minigameStatesTag = tag.m_128469_("minigame_states");
            for (String typeName : minigameStatesTag.m_128431_()) {
                try {
                    ResearchType type = ResearchType.valueOf(typeName);
                    CompoundTag stateTag = minigameStatesTag.m_128469_(typeName);
                    HashMap<String, Boolean> state = new HashMap<String, Boolean>();
                    for (String key : stateTag.m_128431_()) {
                        Object value = stateTag.m_128425_(key, 1) ? Boolean.valueOf(stateTag.m_128471_(key)) : (stateTag.m_128425_(key, 8) ? stateTag.m_128461_(key) : (stateTag.m_128425_(key, 6) ? Double.valueOf(stateTag.m_128459_(key)) : (stateTag.m_128425_(key, 3) ? Integer.valueOf(stateTag.m_128451_(key)) : stateTag.m_128461_(key))));
                        state.put(key, (Boolean)value);
                    }
                    this.minigameStates.put(type, state);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (!(this.currentState != MachineState.IDLE || this.currentResearchId.isEmpty() && this.activeResearchTypes.isEmpty())) {
            this.currentState = MachineState.READY;
        } else if (this.currentState != MachineState.IDLE && this.currentResearchId.isEmpty()) {
            this.currentState = MachineState.IDLE;
            this.activeResearchTypes.clear();
        }
    }

    public boolean isPlayerLocked(UUID playerId) {
        return this.currentPlayerId != null && !this.currentPlayerId.equals(playerId);
    }

    public void lockToPlayer(UUID playerId) {
        this.currentPlayerId = playerId;
        this.m_6596_();
    }

    public void unlockPlayer() {
        this.currentPlayerId = null;
        this.m_6596_();
    }

    public UUID getCurrentPlayerId() {
        return this.currentPlayerId;
    }

    public Map<ResearchType, Map<String, Object>> getMinigameStates() {
        return this.minigameStates;
    }

    public void setMinigameStates(Map<ResearchType, Map<String, Object>> states) {
        this.minigameStates = new HashMap<ResearchType, Map<String, Object>>(states);
        this.m_6596_();
    }

    public void setCurrentState(MachineState state) {
        this.currentState = state;
    }

    public void setCurrentResearchId(String researchId) {
        this.currentResearchId = researchId;
    }

    public void setActiveResearchTypes(Set<ResearchType> activeTypes) {
        this.activeResearchTypes = new HashSet<ResearchType>(activeTypes);
    }

    public void setInstabilityLevel(float instabilityLevel) {
        this.instabilityLevel = instabilityLevel;
    }

    public void setResearchTicks(int researchTicks) {
        this.researchTicks = researchTicks;
    }

    public void setClientState(MachineState state, String researchId, Set<ResearchType> activeTypes, float instabilityLevel, int researchTicks) {
        this.currentState = state;
        this.currentResearchId = researchId;
        this.activeResearchTypes = new HashSet<ResearchType>(activeTypes);
        this.instabilityLevel = instabilityLevel;
        this.researchTicks = researchTicks;
    }

    public static enum MachineState {
        IDLE,
        READY,
        RESEARCHING,
        COMPLETED,
        FAILED;

    }
}

