/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.block.ResearchMachineBlockEntity;
import com.hexvane.strangematter.client.ScreenHelper;
import com.hexvane.strangematter.item.ResearchNoteItem;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class ResearchMachineBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public ResearchMachineBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283743_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60999_().m_60953_(state -> 7).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        ItemStack heldItem = player.m_21120_(hand);
        if (!heldItem.m_41619_() && heldItem.m_41720_() instanceof ResearchNoteItem) {
            BlockEntity blockEntity2;
            if (!level.f_46443_ && (blockEntity2 = level.m_7702_(pos)) instanceof ResearchMachineBlockEntity) {
                ResearchMachineBlockEntity researchMachine = (ResearchMachineBlockEntity)blockEntity2;
                if (researchMachine.insertResearchNote(heldItem, player)) {
                    if (!player.m_150110_().f_35937_) {
                        heldItem.m_41774_(1);
                    }
                    player.m_213846_((Component)Component.m_237115_((String)"block.strangematter.research_machine.note_inserted"));
                    return InteractionResult.SUCCESS;
                }
                player.m_213846_((Component)Component.m_237115_((String)"block.strangematter.research_machine.already_has_note"));
                level.m_5594_(null, pos, (SoundEvent)StrangeMatterSounds.RESEARCH_MACHINE_NOTE_REJECT.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
                return InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        if (level.f_46443_ && (blockEntity = level.m_7702_(pos)) != null) {
            BlockEntity finalBlockEntity = blockEntity;
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ScreenHelper.openResearchMachineScreen(finalBlockEntity));
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)StrangeMatterMod.RESEARCH_MACHINE_BLOCK_ENTITY.get()).m_155264_(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == StrangeMatterMod.RESEARCH_MACHINE_BLOCK_ENTITY.get() && !level.f_46443_ ? (level1, pos, state1, blockEntity) -> {} : null;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        ResearchMachineBlockEntity researchMachine;
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof ResearchMachineBlockEntity && (researchMachine = (ResearchMachineBlockEntity)blockEntity).getCurrentState() != ResearchMachineBlockEntity.MachineState.IDLE && !level.f_46443_) {
            String researchId = researchMachine.getCurrentResearchId();
            Set<ResearchType> activeTypes = researchMachine.getActiveResearchTypes();
            if (!researchId.isEmpty() && !activeTypes.isEmpty()) {
                HashMap<ResearchType, Integer> researchCosts = new HashMap<ResearchType, Integer>();
                for (ResearchType type : activeTypes) {
                    researchCosts.put(type, 1);
                }
                ItemStack researchNote = ResearchNoteItem.createResearchNote(researchCosts, researchId);
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, researchNote);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }
}

