/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.block.BaseMachineBlockEntity;
import com.hexvane.strangematter.energy.ResonanceEnergyStorage;
import com.hexvane.strangematter.menu.RealityForgeMenu;
import com.hexvane.strangematter.recipe.RealityForgeRecipe;
import com.hexvane.strangematter.recipe.RealityForgeRecipeRegistry;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RealityForgeBlockEntity
extends BaseMachineBlockEntity {
    private final Map<String, Integer> storedShards = new HashMap<String, Integer>();
    private final List<String> shardOrder = new ArrayList<String>();
    private int totalShardCount = 0;
    private boolean isCrafting = false;
    private int craftTicks = 0;
    private boolean isCoalescing = false;
    private RealityForgeRecipe currentRecipe = null;
    private Player currentPlayer = null;
    private final ContainerData shardDataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> 0;
                case 1 -> 0;
                case 2 -> {
                    if (RealityForgeBlockEntity.this.isActive) {
                        yield 1;
                    }
                    yield 0;
                }
                case 3 -> RealityForgeBlockEntity.this.energyPerTick;
                case 4 -> RealityForgeBlockEntity.this.maxEnergyStorage;
                case 5 -> RealityForgeBlockEntity.this.progressLevel;
                case 6 -> RealityForgeBlockEntity.this.maxProgressLevel;
                case 7 -> RealityForgeBlockEntity.this.storedShards.size();
                case 8 -> RealityForgeBlockEntity.this.totalShardCount;
                case 9 -> {
                    if (RealityForgeBlockEntity.this.isCrafting) {
                        yield 1;
                    }
                    yield 0;
                }
                case 10 -> RealityForgeBlockEntity.this.craftTicks;
                case 11 -> {
                    if (RealityForgeBlockEntity.this.isCoalescing) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    RealityForgeBlockEntity.this.isActive = value != 0;
                    break;
                }
                case 3: {
                    RealityForgeBlockEntity.this.energyPerTick = value;
                    break;
                }
                case 4: {
                    RealityForgeBlockEntity.this.maxEnergyStorage = value;
                    break;
                }
                case 5: {
                    RealityForgeBlockEntity.this.progressLevel = value;
                    break;
                }
                case 6: {
                    RealityForgeBlockEntity.this.maxProgressLevel = value;
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    RealityForgeBlockEntity.this.totalShardCount = value;
                    if (value != 0) break;
                    RealityForgeBlockEntity.this.storedShards.clear();
                    RealityForgeBlockEntity.this.shardOrder.clear();
                    break;
                }
                case 9: {
                    RealityForgeBlockEntity.this.isCrafting = value != 0;
                    break;
                }
                case 10: {
                    RealityForgeBlockEntity.this.craftTicks = value;
                    break;
                }
                case 11: {
                    RealityForgeBlockEntity.this.isCoalescing = value != 0;
                }
            }
        }

        public int m_6499_() {
            return 12;
        }
    };

    private int getCraftTime() {
        return Config.realityForgeCraftTime;
    }

    public RealityForgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StrangeMatterMod.REALITY_FORGE_BLOCK_ENTITY.get(), pos, state, 11);
        boolean[] inputSides = new boolean[]{false, false, false, false, false, false};
        this.setEnergyInputSides(inputSides);
        boolean[] outputSides = new boolean[]{false, false, false, false, false, false};
        this.setEnergyOutputSides(outputSides);
        this.energyStorage.setCapacity(0);
        this.energyStorage.setEnergy(0);
    }

    @Override
    protected BaseMachineBlockEntity.MachineEnergyRole getEnergyRole() {
        return BaseMachineBlockEntity.MachineEnergyRole.ENERGY_INDEPENDENT;
    }

    @Override
    public int getEnergyStored() {
        return 0;
    }

    @Override
    public int getMaxEnergyStored() {
        return 0;
    }

    @Override
    public float getEnergyPercentage() {
        return 0.0f;
    }

    @Override
    public int getEnergyPercentageInt() {
        return 0;
    }

    @Override
    public ResonanceEnergyStorage getEnergyStorage() {
        return new ResonanceEnergyStorage(0, 0, 0);
    }

    @Override
    protected void processMachine() {
        if (this.isCrafting) {
            ++this.craftTicks;
            if (this.craftTicks >= this.getCraftTime()) {
                this.completeCrafting();
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RealityForgeBlockEntity blockEntity) {
        if (blockEntity.isCrafting) {
            int craftTime;
            ++blockEntity.craftTicks;
            if (blockEntity.craftTicks == 1) {
                blockEntity.isCoalescing = true;
                blockEntity.m_6596_();
            }
            if (blockEntity.craftTicks >= (craftTime = blockEntity.getCraftTime())) {
                if (blockEntity.isCrafting && blockEntity.currentRecipe != null) {
                    blockEntity.completeCrafting();
                } else {
                    blockEntity.stopCrafting();
                }
            }
        }
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        super.m_6836_(slot, stack);
        if (slot >= 0 && slot < 9) {
            this.attemptCraft();
        }
    }

    @Override
    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new RealityForgeMenu(id, playerInventory, this.m_58899_());
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("craftTicks", this.craftTicks);
        tag.m_128379_("isCrafting", this.isCrafting);
        CompoundTag shardTag = new CompoundTag();
        for (Map.Entry<String, Integer> entry : this.storedShards.entrySet()) {
            shardTag.m_128405_(entry.getKey(), entry.getValue().intValue());
        }
        tag.m_128365_("storedShards", (Tag)shardTag);
        ListTag shardOrderTag = new ListTag();
        for (String shard : this.shardOrder) {
            shardOrderTag.add((Object)StringTag.m_129297_((String)shard));
        }
        tag.m_128365_("shardOrder", (Tag)shardOrderTag);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.craftTicks = tag.m_128451_("craftTicks");
        this.isCrafting = tag.m_128471_("isCrafting");
        if (tag.m_128441_("storedShards")) {
            CompoundTag shardTag = tag.m_128469_("storedShards");
            this.storedShards.clear();
            for (String key : shardTag.m_128431_()) {
                this.storedShards.put(key, shardTag.m_128451_(key));
            }
        }
        if (tag.m_128441_("shardOrder")) {
            this.shardOrder.clear();
            ListTag shardOrderTag = tag.m_128437_("shardOrder", 8);
            for (int i = 0; i < shardOrderTag.size(); ++i) {
                this.shardOrder.add(shardOrderTag.m_128778_(i));
            }
        }
        this.totalShardCount = 0;
        for (int count : this.storedShards.values()) {
            this.totalShardCount += count;
        }
    }

    public int insertShard(ItemStack shardStack) {
        String shardType = this.getShardType(shardStack);
        if (shardType == null) {
            return 0;
        }
        int maxShards = 6;
        int totalShards = this.storedShards.values().stream().mapToInt(Integer::intValue).sum();
        int availableSlots = maxShards - totalShards;
        if (availableSlots <= 0) {
            return 0;
        }
        int shardsToInsert = Math.min(shardStack.m_41613_(), availableSlots);
        this.storedShards.put(shardType, this.storedShards.getOrDefault(shardType, 0) + shardsToInsert);
        if (!this.shardOrder.contains(shardType)) {
            this.shardOrder.add(shardType);
        }
        this.totalShardCount = this.storedShards.values().stream().mapToInt(Integer::intValue).sum();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && shardsToInsert > 0) {
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)StrangeMatterSounds.REALITY_FORGE_INSERT.get(), SoundSource.BLOCKS, 0.7f, 1.0f);
        }
        if (shardsToInsert > 0 && !this.isCrafting) {
            this.attemptCraft();
        }
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
        }
        return shardsToInsert;
    }

    public void ejectShards(Player player) {
        if (this.isCrafting) {
            this.stopCrafting();
        }
        for (String shardType : new ArrayList<String>(this.shardOrder)) {
            int count = this.storedShards.getOrDefault(shardType, 0);
            if (count <= 0) continue;
            ItemStack shardStack = this.createShardStack(shardType, count);
            if (!player.m_150109_().m_36054_(shardStack)) {
                player.m_36176_(shardStack, false);
            }
            this.storedShards.remove(shardType);
        }
        this.shardOrder.clear();
        this.totalShardCount = 0;
        this.m_6596_();
    }

    public void clearShardsForEject() {
        if (this.isCrafting) {
            this.stopCrafting();
        }
        this.storedShards.clear();
        this.shardOrder.clear();
        this.totalShardCount = 0;
        this.m_6596_();
    }

    private String getShardType(ItemStack stack) {
        if (stack.m_41720_() == StrangeMatterMod.ENERGETIC_SHARD.get()) {
            return "energetic";
        }
        if (stack.m_41720_() == StrangeMatterMod.GRAVITIC_SHARD.get()) {
            return "gravitic";
        }
        if (stack.m_41720_() == StrangeMatterMod.CHRONO_SHARD.get()) {
            return "chrono";
        }
        if (stack.m_41720_() == StrangeMatterMod.SPATIAL_SHARD.get()) {
            return "spatial";
        }
        if (stack.m_41720_() == StrangeMatterMod.SHADE_SHARD.get()) {
            return "shade";
        }
        if (stack.m_41720_() == StrangeMatterMod.INSIGHT_SHARD.get()) {
            return "insight";
        }
        return null;
    }

    private ItemStack createShardStack(String shardType, int count) {
        return switch (shardType) {
            case "energetic" -> new ItemStack((ItemLike)StrangeMatterMod.ENERGETIC_SHARD.get(), count);
            case "gravitic" -> new ItemStack((ItemLike)StrangeMatterMod.GRAVITIC_SHARD.get(), count);
            case "gravity" -> new ItemStack((ItemLike)StrangeMatterMod.GRAVITIC_SHARD.get(), count);
            case "chrono" -> new ItemStack((ItemLike)StrangeMatterMod.CHRONO_SHARD.get(), count);
            case "temporal" -> new ItemStack((ItemLike)StrangeMatterMod.CHRONO_SHARD.get(), count);
            case "spatial" -> new ItemStack((ItemLike)StrangeMatterMod.SPATIAL_SHARD.get(), count);
            case "shade" -> new ItemStack((ItemLike)StrangeMatterMod.SHADE_SHARD.get(), count);
            case "shadow" -> new ItemStack((ItemLike)StrangeMatterMod.SHADE_SHARD.get(), count);
            case "insight" -> new ItemStack((ItemLike)StrangeMatterMod.INSIGHT_SHARD.get(), count);
            case "cognition" -> new ItemStack((ItemLike)StrangeMatterMod.INSIGHT_SHARD.get(), count);
            default -> ItemStack.f_41583_;
        };
    }

    public void attemptCraft() {
        this.attemptCraft(null);
    }

    public void attemptCraft(Player player) {
        if (this.isCrafting) {
            return;
        }
        RealityForgeRecipe recipe = RealityForgeRecipeRegistry.findMatchingRecipe(this);
        if (recipe != null) {
            Player checkPlayer;
            Player player2 = checkPlayer = player != null ? player : this.currentPlayer;
            if (checkPlayer != null && !recipe.canCraftByPlayer(checkPlayer)) {
                return;
            }
            this.startCrafting(recipe);
        }
    }

    public void setCurrentPlayer(Player player) {
        this.currentPlayer = player;
    }

    public Player getCurrentPlayer() {
        return this.currentPlayer;
    }

    private void startCrafting(RealityForgeRecipe recipe) {
        this.isCrafting = true;
        this.craftTicks = 0;
        this.currentRecipe = recipe;
        this.m_6596_();
    }

    private void stopCrafting() {
        this.isCrafting = false;
        this.isCoalescing = false;
        this.craftTicks = 0;
        this.currentRecipe = null;
        this.m_6596_();
    }

    private void completeCrafting() {
        if (this.currentRecipe == null) {
            System.out.println("DEBUG: completeCrafting() called with null currentRecipe!");
            this.stopCrafting();
            return;
        }
        RealityForgeRecipe recipe = this.currentRecipe;
        for (int i = 0; i < 9; ++i) {
            ItemStack currentStack = this.m_8020_(i);
            if (currentStack.m_41619_()) continue;
            currentStack.m_41774_(1);
            if (currentStack.m_41619_()) {
                this.m_6836_(i, ItemStack.f_41583_);
                continue;
            }
            this.m_6836_(i, currentStack);
        }
        for (Map.Entry<String, Integer> requirement : recipe.getShardRequirements().entrySet()) {
            String shardType = requirement.getKey();
            int required = requirement.getValue();
            int current = this.storedShards.getOrDefault(shardType, 0);
            if (current < required) continue;
            this.storedShards.put(shardType, current - required);
            if (this.storedShards.get(shardType) != 0) continue;
            this.storedShards.remove(shardType);
            this.shardOrder.remove(shardType);
        }
        this.m_6836_(10, this.currentRecipe.m_8043_(this.f_58857_.m_9598_()).m_41777_());
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)StrangeMatterSounds.REALITY_FORGE_CRAFT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.isCrafting = false;
        this.isCoalescing = false;
        this.craftTicks = 0;
        this.currentRecipe = null;
        this.storedShards.clear();
        this.shardOrder.clear();
        this.totalShardCount = 0;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
        }
    }

    @Override
    public ContainerData getDataAccess() {
        return this.shardDataAccess;
    }

    @Override
    protected void writeAdditionalStateData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.storedShards.size());
        for (Map.Entry<String, Integer> entry : this.storedShards.entrySet()) {
            buffer.m_130070_(entry.getKey());
            buffer.writeInt(entry.getValue().intValue());
        }
        buffer.writeInt(this.shardOrder.size());
        for (String shardType : this.shardOrder) {
            buffer.m_130070_(shardType);
        }
        buffer.writeBoolean(this.isCrafting);
        buffer.writeInt(this.craftTicks);
        buffer.writeBoolean(this.isCoalescing);
    }

    @Override
    protected void readAdditionalStateData(FriendlyByteBuf buffer) {
        this.storedShards.clear();
        int shardTypeCount = buffer.readInt();
        for (int i = 0; i < shardTypeCount; ++i) {
            String shardType = buffer.m_130277_();
            int count = buffer.readInt();
            this.storedShards.put(shardType, count);
        }
        this.shardOrder.clear();
        int shardOrderSize = buffer.readInt();
        for (int i = 0; i < shardOrderSize; ++i) {
            this.shardOrder.add(buffer.m_130277_());
        }
        this.isCrafting = buffer.readBoolean();
        this.craftTicks = buffer.readInt();
        this.isCoalescing = buffer.readBoolean();
        this.totalShardCount = 0;
        for (int count : this.storedShards.values()) {
            this.totalShardCount += count;
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public Map<String, Integer> getStoredShards() {
        return new HashMap<String, Integer>(this.storedShards);
    }

    public List<String> getShardOrder() {
        return new ArrayList<String>(this.shardOrder);
    }

    public boolean isCrafting() {
        return this.isCrafting;
    }

    public int getCraftProgress() {
        int craftTime = this.getCraftTime();
        return this.isCrafting ? this.craftTicks * 100 / craftTime : 0;
    }

    public boolean isCoalescing() {
        return this.isCoalescing;
    }

    public int getCoalesceProgress() {
        int craftTime = this.getCraftTime();
        return this.isCoalescing ? this.craftTicks * 100 / craftTime : 0;
    }

    public void dropContents() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_() || this.f_58857_ == null) continue;
            ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, stack);
            this.f_58857_.m_7967_((Entity)itemEntity);
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            for (Map.Entry<String, Integer> entry : this.storedShards.entrySet()) {
                ItemStack shardStack;
                String shardType = entry.getKey();
                int count = entry.getValue();
                if (count <= 0 || (shardStack = this.createShardStack(shardType, count)).m_41619_()) continue;
                ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, shardStack);
                this.f_58857_.m_7967_((Entity)itemEntity);
            }
        }
    }
}

