/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.energy.ResonanceEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class ParadoxicalEnergyCellBlockEntity
extends BlockEntity {
    private final ResonanceEnergyStorage energyStorage = new ResonanceEnergyStorage(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private final LazyOptional<IEnergyStorage> energyOptional = LazyOptional.of(() -> this.energyStorage);

    public ParadoxicalEnergyCellBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StrangeMatterMod.PARADOXICAL_ENERGY_CELL_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ParadoxicalEnergyCellBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        blockEntity.distributeEnergy();
    }

    private void distributeEnergy() {
        if (this.f_58857_ == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = this.f_58858_.m_121945_(direction);
            BlockEntity adjacentEntity = this.f_58857_.m_7702_(adjacentPos);
            if (adjacentEntity == null) continue;
            adjacentEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(adjacentStorage -> {
                int energyTransferred;
                int transferRate;
                int energyToTransfer;
                if (adjacentStorage.canReceive() && (energyToTransfer = Math.min(transferRate = Config.paradoxicalCellTransferRate, adjacentStorage.getMaxEnergyStored() - adjacentStorage.getEnergyStored())) > 0 && (energyTransferred = adjacentStorage.receiveEnergy(energyToTransfer, false)) > 0) {
                    this.m_6596_();
                }
            });
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyOptional.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("energy", this.energyStorage.getEnergyStored());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energyStorage.setEnergy(tag.m_128451_("energy"));
    }

    public ResonanceEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }
}

