/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.GravityData;
import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.block.LevitationPadBlock;
import com.hexvane.strangematter.network.GravitySyncPacket;
import com.hexvane.strangematter.network.NetworkHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevitationPadBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(LevitationPadBlockEntity.class);
    private static final int MAX_RANGE = 16;
    private static final double LEVITATION_SPEED = 0.2;
    private static final double LEVITATION_SPEED_DOWN = 0.05;
    private static final int TICK_INTERVAL = 2;
    private boolean levitateUp = true;
    private int tickCounter = 0;
    private Set<ItemEntity> affectedItems = new HashSet<ItemEntity>();
    private Set<Player> affectedPlayers = new HashSet<Player>();

    public LevitationPadBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StrangeMatterMod.LEVITATION_PAD_BLOCK_ENTITY.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, LevitationPadBlockEntity blockEntity) {
        blockEntity.tick();
    }

    private void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter < 2) {
            return;
        }
        this.tickCounter = 0;
        if (this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof LevitationPadBlock) {
            LevitationPadBlock block = (LevitationPadBlock)this.f_58857_.m_8055_(this.f_58858_).m_60734_();
            boolean levitateUp = (Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)LevitationPadBlock.LEVITATE_UP);
            if (levitateUp) {
                this.processLevitationUp();
            } else {
                this.processLevitationDown();
            }
        }
    }

    private void processLevitationUp() {
        if (this.f_58857_ == null) {
            return;
        }
        int maxHeight = this.findMaxHeight();
        AABB detectionBox = new AABB((double)this.f_58858_.m_123341_() - 0.5, (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_() - 0.5, (double)this.f_58858_.m_123341_() + 1.5, (double)(this.f_58858_.m_123342_() + maxHeight), (double)this.f_58858_.m_123343_() + 1.5);
        List entities = this.f_58857_.m_45976_(Entity.class, detectionBox);
        HashSet<ItemEntity> currentAffectedItems = new HashSet<ItemEntity>();
        HashSet<Player> currentAffectedPlayers = new HashSet<Player>();
        for (Entity entity : entities) {
            if (!this.shouldAffectEntity(entity)) continue;
            this.levitateEntityUp(entity, maxHeight);
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                currentAffectedItems.add(itemEntity);
                continue;
            }
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            currentAffectedPlayers.add(player);
        }
        this.affectedItems.removeAll(currentAffectedItems);
        for (ItemEntity item : this.affectedItems) {
            if (!item.m_6084_()) continue;
            item.m_20242_(false);
        }
        this.affectedPlayers.removeAll(currentAffectedPlayers);
        for (Player player : this.affectedPlayers) {
            if (!player.m_6084_()) continue;
            GravityData.removePlayerGravityForce(player.m_20148_());
            player.getPersistentData().m_128473_("strangematter.gravity_force");
            if (this.f_58857_.f_46443_) continue;
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new GravitySyncPacket(0.0));
        }
        this.affectedItems = currentAffectedItems;
        this.affectedPlayers = currentAffectedPlayers;
    }

    private void processLevitationDown() {
        if (this.f_58857_ == null) {
            return;
        }
        AABB detectionBox = new AABB((double)this.f_58858_.m_123341_() - 0.5, (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_() - 0.5, (double)this.f_58858_.m_123341_() + 1.5, (double)(this.f_58858_.m_123342_() + 16), (double)this.f_58858_.m_123343_() + 1.5);
        List entities = this.f_58857_.m_45976_(Entity.class, detectionBox);
        HashSet<ItemEntity> currentAffectedItems = new HashSet<ItemEntity>();
        HashSet<Player> currentAffectedPlayers = new HashSet<Player>();
        for (Entity entity : entities) {
            if (!this.shouldAffectEntity(entity)) continue;
            this.levitateEntityDown(entity);
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                currentAffectedItems.add(itemEntity);
                continue;
            }
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            currentAffectedPlayers.add(player);
        }
        this.affectedItems.removeAll(currentAffectedItems);
        for (ItemEntity item : this.affectedItems) {
            if (!item.m_6084_()) continue;
            item.m_20242_(false);
        }
        this.affectedPlayers.removeAll(currentAffectedPlayers);
        for (Player player : this.affectedPlayers) {
            if (!player.m_6084_()) continue;
            GravityData.removePlayerGravityForce(player.m_20148_());
            player.getPersistentData().m_128473_("strangematter.gravity_force");
            if (this.f_58857_.f_46443_) continue;
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new GravitySyncPacket(0.0));
        }
        this.affectedItems = currentAffectedItems;
        this.affectedPlayers = currentAffectedPlayers;
    }

    private int findMaxHeight() {
        if (this.f_58857_ == null) {
            return Config.levitationPadMaxHeight;
        }
        BlockPos currentPos = this.f_58858_.m_7494_();
        int height = 0;
        int maxRange = Config.levitationPadMaxHeight;
        while (height < maxRange) {
            BlockState blockState = this.f_58857_.m_8055_(currentPos);
            if (blockState.m_60734_() == Blocks.f_50016_ || blockState.m_60734_() == Blocks.f_50627_ || blockState.m_60734_() == Blocks.f_50626_ || blockState.m_60795_()) {
                ++height;
                currentPos = currentPos.m_7494_();
                continue;
            }
            if (!(blockState.m_60734_() instanceof TrapDoorBlock) || !((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue()) break;
            ++height;
            currentPos = currentPos.m_7494_();
        }
        return height;
    }

    private boolean shouldAffectEntity(Entity entity) {
        if (entity.getClass().getSimpleName().contains("BlockEntity")) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.m_150110_().f_35935_;
        }
        return true;
    }

    private void levitateEntityUp(Entity entity, int maxHeight) {
        double targetY;
        if (this.f_58857_ == null) {
            return;
        }
        double entityY = entity.m_20186_();
        if (entityY >= (targetY = (double)(this.f_58858_.m_123342_() + maxHeight + 1))) {
            return;
        }
        double distanceToTarget = targetY - entityY;
        double moveDistance = Math.min(0.2, distanceToTarget);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            double forceMultiplier = Math.min(1.0, moveDistance / 0.2);
            GravityData.setPlayerGravityForce(player.m_20148_(), forceMultiplier);
            player.getPersistentData().m_128347_("strangematter.gravity_force", forceMultiplier);
            if (!this.f_58857_.f_46443_) {
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new GravitySyncPacket(forceMultiplier));
            }
        } else if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            double centerX = (double)this.f_58858_.m_123341_() + 0.5;
            double centerZ = (double)this.f_58858_.m_123343_() + 0.5;
            double deltaX = centerX - entity.m_20185_();
            double deltaZ = centerZ - entity.m_20189_();
            double centeringForce = 0.2;
            double newX = deltaX * centeringForce;
            double newZ = deltaZ * centeringForce;
            double time = (double)(System.currentTimeMillis() % 360000L) / 1000.0;
            double itemId = (double)itemEntity.m_19879_() * 0.1;
            double floatHeight = Math.sin(time * 0.5 + itemId) * 0.02;
            itemEntity.m_20334_(newX, moveDistance + floatHeight, newZ);
            itemEntity.m_20242_(true);
        } else if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Vec3 motion = entity.m_20184_();
            entity.m_20334_(motion.f_82479_, moveDistance, motion.f_82481_);
            livingEntity.f_19789_ = 0.0f;
        } else {
            Vec3 motion = entity.m_20184_();
            entity.m_20334_(motion.f_82479_, moveDistance, motion.f_82481_);
        }
    }

    private void levitateEntityDown(Entity entity) {
        double targetY;
        if (this.f_58857_ == null) {
            return;
        }
        double entityY = entity.m_20186_();
        if (entityY <= (targetY = (double)(this.f_58858_.m_123342_() + 1))) {
            return;
        }
        double distanceToTarget = entityY - targetY;
        double moveDistance = Math.min(0.05, distanceToTarget);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            double forceMultiplier = Math.min(1.0, moveDistance / 0.05);
            GravityData.setPlayerGravityForce(player.m_20148_(), -forceMultiplier);
            player.getPersistentData().m_128347_("strangematter.gravity_force", -forceMultiplier);
            if (!this.f_58857_.f_46443_) {
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new GravitySyncPacket(-forceMultiplier));
            }
        } else if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            double centerX = (double)this.f_58858_.m_123341_() + 0.5;
            double centerZ = (double)this.f_58858_.m_123343_() + 0.5;
            double deltaX = centerX - entity.m_20185_();
            double deltaZ = centerZ - entity.m_20189_();
            double centeringForce = 0.2;
            double newX = deltaX * centeringForce;
            double newZ = deltaZ * centeringForce;
            double time = (double)(System.currentTimeMillis() % 360000L) / 1000.0;
            double itemId = (double)itemEntity.m_19879_() * 0.1;
            double floatHeight = Math.sin(time * 0.5 + itemId) * 0.01;
            itemEntity.m_20334_(newX, -moveDistance + floatHeight, newZ);
            itemEntity.m_20242_(true);
        } else if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Vec3 motion = entity.m_20184_();
            entity.m_20334_(motion.f_82479_, -moveDistance, motion.f_82481_);
            livingEntity.f_19789_ = 0.0f;
        } else {
            Vec3 motion = entity.m_20184_();
            entity.m_20334_(motion.f_82479_, -moveDistance, motion.f_82481_);
        }
    }

    public void setLevitateUp(boolean levitateUp) {
        this.levitateUp = levitateUp;
        this.m_6596_();
    }

    public boolean isLevitateUp() {
        return this.levitateUp;
    }

    public int getMaxHeight() {
        return this.findMaxHeight();
    }

    public AABB getRenderBoundingBox() {
        int maxHeight = this.findMaxHeight();
        return new AABB((double)this.f_58858_.m_123341_() - 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() - 0.5, (double)this.f_58858_.m_123341_() + 1.5, (double)(this.f_58858_.m_123342_() + maxHeight), (double)this.f_58858_.m_123343_() + 1.5);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("levitate_up", this.levitateUp);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.levitateUp = tag.m_128471_("levitate_up");
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("levitate_up", this.levitateUp);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.levitateUp = tag.m_128471_("levitate_up");
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

