/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.block.BaseMachineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class EnergyMachineBlockEntity
extends BaseMachineBlockEntity {
    protected int fuelTime = 0;
    protected int maxFuelTime = 0;
    protected int burnTime = 0;
    protected int maxBurnTime = 0;
    protected int energyPerTick = 1;
    protected int maxEnergyStorage;

    public EnergyMachineBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, int inventorySize) {
        super(blockEntityType, pos, state, inventorySize);
        this.maxEnergyLevel = this.maxEnergyStorage = 1000;
    }

    @Override
    protected void processMachine() {
        if (this.burnTime > 0) {
            --this.burnTime;
            if (this.burnTime <= 0) {
                this.consumeFuel();
            }
        }
        if (this.isActive && this.hasEnergy()) {
            if (this.consumeEnergy(this.energyPerTick)) {
                this.processMachineLogic();
            } else {
                this.setActive(false);
            }
        } else if (this.isActive && !this.hasEnergy()) {
            this.setActive(false);
        }
    }

    protected abstract void processMachineLogic();

    protected void consumeFuel() {
        ItemStack fuelStack = this.m_8020_(this.getFuelSlotIndex());
        if (!fuelStack.m_41619_() && this.isFuel(fuelStack)) {
            fuelStack.m_41774_(1);
            if (fuelStack.m_41619_()) {
                this.m_6836_(this.getFuelSlotIndex(), ItemStack.f_41583_);
            }
            this.maxBurnTime = this.burnTime = this.getBurnTime(fuelStack);
            this.addEnergy(this.burnTime);
            this.m_6596_();
            this.syncToClient();
        }
    }

    protected boolean isFuel(ItemStack stack) {
        return stack.getBurnTime(RecipeType.f_44108_) > 0;
    }

    protected int getBurnTime(ItemStack stack) {
        return stack.getBurnTime(RecipeType.f_44108_);
    }

    protected abstract int getFuelSlotIndex();

    protected abstract int getInputSlotIndex();

    protected abstract int getOutputSlotIndex();

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("fuel_time", this.fuelTime);
        tag.m_128405_("max_fuel_time", this.maxFuelTime);
        tag.m_128405_("burn_time", this.burnTime);
        tag.m_128405_("max_burn_time", this.maxBurnTime);
        tag.m_128405_("energy_per_tick", this.energyPerTick);
        tag.m_128405_("max_energy_storage", this.maxEnergyStorage);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fuelTime = tag.m_128451_("fuel_time");
        this.maxFuelTime = tag.m_128451_("max_fuel_time");
        this.burnTime = tag.m_128451_("burn_time");
        this.maxBurnTime = tag.m_128451_("max_burn_time");
        this.energyPerTick = tag.m_128451_("energy_per_tick");
        this.maxEnergyStorage = tag.m_128451_("max_energy_storage");
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getMaxBurnTime() {
        return this.maxBurnTime;
    }

    public int getFuelTime() {
        return this.fuelTime;
    }

    public int getMaxFuelTime() {
        return this.maxFuelTime;
    }

    public int getEnergyPerTick() {
        return this.energyPerTick;
    }

    public int getMaxEnergyStorage() {
        return this.maxEnergyStorage;
    }
}

