/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.api.block.entity.IPacketHandlerTile;
import com.hexvane.strangematter.energy.ResonanceEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class BaseMachineBlockEntity
extends BlockEntity
implements Container,
MenuProvider,
IPacketHandlerTile {
    protected int energyLevel = 0;
    protected int maxEnergyLevel = 100;
    protected boolean isActive = false;
    protected final ResonanceEnergyStorage energyStorage;
    protected final LazyOptional<IEnergyStorage> energyOptional;
    protected int energyPerTick = 1;
    protected int maxEnergyStorage = 1000;
    protected boolean[] energyInputSides = new boolean[]{true, true, true, true, true, true};
    protected boolean[] energyOutputSides = new boolean[]{false, false, false, false, false, false};
    protected int progressLevel = 0;
    protected int maxProgressLevel = 100;
    protected final NonNullList<ItemStack> items;
    protected final int inventorySize;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> BaseMachineBlockEntity.this.energyStorage.getEnergyStored();
                case 1 -> BaseMachineBlockEntity.this.energyStorage.getMaxEnergyStored();
                case 2 -> {
                    if (BaseMachineBlockEntity.this.isActive) {
                        yield 1;
                    }
                    yield 0;
                }
                case 3 -> BaseMachineBlockEntity.this.energyPerTick;
                case 4 -> BaseMachineBlockEntity.this.maxEnergyStorage;
                case 5 -> BaseMachineBlockEntity.this.progressLevel;
                case 6 -> BaseMachineBlockEntity.this.maxProgressLevel;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    BaseMachineBlockEntity.this.energyStorage.setEnergy(value);
                    break;
                }
                case 1: {
                    BaseMachineBlockEntity.this.energyStorage.setCapacity(value);
                    break;
                }
                case 2: {
                    BaseMachineBlockEntity.this.isActive = value != 0;
                    break;
                }
                case 3: {
                    BaseMachineBlockEntity.this.energyPerTick = value;
                    break;
                }
                case 4: {
                    BaseMachineBlockEntity.this.maxEnergyStorage = value;
                    break;
                }
                case 5: {
                    BaseMachineBlockEntity.this.progressLevel = value;
                    break;
                }
                case 6: {
                    BaseMachineBlockEntity.this.maxProgressLevel = value;
                }
            }
        }

        public int m_6499_() {
            return 7;
        }
    };

    public BaseMachineBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, int inventorySize) {
        super(blockEntityType, pos, state);
        this.inventorySize = inventorySize;
        this.items = NonNullList.m_122780_((int)inventorySize, (Object)ItemStack.f_41583_);
        this.energyStorage = new ResonanceEnergyStorage(this.maxEnergyStorage, 1000, 1000);
        this.energyOptional = LazyOptional.of(() -> this.energyStorage);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BaseMachineBlockEntity blockEntity) {
        if (!level.f_46443_) {
            blockEntity.performRoleBasedEnergyTransfer();
            blockEntity.processMachine();
        }
        if (level.f_46443_) {
            blockEntity.clientTick();
        }
    }

    protected abstract void processMachine();

    protected void performRoleBasedEnergyTransfer() {
        MachineEnergyRole role = this.getEnergyRole();
        switch (role) {
            case GENERATOR: {
                this.trySendEnergy();
                break;
            }
            case CONSUMER: {
                this.tryReceiveEnergy();
                break;
            }
            case ENERGY_INDEPENDENT: {
                break;
            }
            case BOTH: {
                this.tryReceiveEnergy();
                this.trySendEnergy();
            }
        }
    }

    protected MachineEnergyRole getEnergyRole() {
        boolean hasInputSides = false;
        boolean hasOutputSides = false;
        for (boolean input : this.energyInputSides) {
            if (!input) continue;
            hasInputSides = true;
            break;
        }
        for (boolean output : this.energyOutputSides) {
            if (!output) continue;
            hasOutputSides = true;
            break;
        }
        if (hasInputSides && hasOutputSides) {
            return MachineEnergyRole.BOTH;
        }
        if (hasInputSides) {
            return MachineEnergyRole.CONSUMER;
        }
        if (hasOutputSides) {
            return MachineEnergyRole.GENERATOR;
        }
        return MachineEnergyRole.ENERGY_INDEPENDENT;
    }

    protected boolean canReceiveEnergyFrom(BlockEntity adjacentEntity) {
        if (adjacentEntity instanceof BaseMachineBlockEntity) {
            BaseMachineBlockEntity adjacentMachine = (BaseMachineBlockEntity)adjacentEntity;
            MachineEnergyRole adjacentRole = adjacentMachine.getEnergyRole();
            MachineEnergyRole ourRole = this.getEnergyRole();
            return adjacentRole == MachineEnergyRole.GENERATOR || adjacentRole == MachineEnergyRole.BOTH;
        }
        return true;
    }

    protected boolean canSendEnergyTo(BlockEntity adjacentEntity) {
        if (adjacentEntity instanceof BaseMachineBlockEntity) {
            BaseMachineBlockEntity adjacentMachine = (BaseMachineBlockEntity)adjacentEntity;
            MachineEnergyRole adjacentRole = adjacentMachine.getEnergyRole();
            MachineEnergyRole ourRole = this.getEnergyRole();
            return adjacentRole == MachineEnergyRole.CONSUMER || adjacentRole == MachineEnergyRole.BOTH;
        }
        return true;
    }

    protected void clientTick() {
    }

    protected boolean hasEnergy() {
        return this.energyStorage.getEnergyStored() > 0;
    }

    protected boolean consumeEnergy(int amount) {
        if (this.energyStorage.getEnergyStored() >= amount) {
            this.energyStorage.extractEnergy(amount, false);
            this.m_6596_();
            this.syncToClient();
            return true;
        }
        return false;
    }

    protected void addEnergy(int amount) {
        this.energyStorage.receiveEnergy(amount, false);
        this.m_6596_();
        this.syncToClient();
    }

    protected int getEnergyTransferRate() {
        return 1000;
    }

    protected void tryReceiveEnergy() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        boolean[] energyChanged = new boolean[]{false};
        int initialEnergy = this.energyStorage.getEnergyStored();
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos;
            BlockEntity adjacentEntity;
            if (!this.energyInputSides[direction.ordinal()] || (adjacentEntity = this.f_58857_.m_7702_(adjacentPos = this.f_58858_.m_121945_(direction))) == null) continue;
            adjacentEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(adjacentStorage -> {
                if (adjacentStorage.canExtract() && this.energyStorage.canReceive() && this.canReceiveEnergyFrom(adjacentEntity)) {
                    int energyReceived;
                    int transferRate = this.getEnergyTransferRate();
                    int energyToReceive = Math.min(this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored(), transferRate);
                    if (energyToReceive > 0 && (energyReceived = adjacentStorage.extractEnergy(energyToReceive, false)) > 0) {
                        this.energyStorage.receiveEnergy(energyReceived, false);
                        this.m_6596_();
                        energyChanged[0] = true;
                    }
                }
            });
        }
        if (energyChanged[0]) {
            this.syncToClient();
        }
    }

    protected void trySendEnergy() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        boolean[] energyChanged = new boolean[]{false};
        int initialEnergy = this.energyStorage.getEnergyStored();
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos;
            BlockEntity adjacentEntity;
            if (!this.energyOutputSides[direction.ordinal()] || (adjacentEntity = this.f_58857_.m_7702_(adjacentPos = this.f_58858_.m_121945_(direction))) == null) continue;
            adjacentEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(adjacentStorage -> {
                if (adjacentStorage.canReceive() && this.energyStorage.canExtract() && this.canSendEnergyTo(adjacentEntity)) {
                    int energySent;
                    int transferRate = this.getEnergyTransferRate();
                    int energyToSend = Math.min(this.energyStorage.getEnergyStored(), transferRate);
                    if (energyToSend > 0 && (energySent = adjacentStorage.receiveEnergy(energyToSend, false)) > 0) {
                        this.energyStorage.extractEnergy(energySent, false);
                        this.m_6596_();
                        energyChanged[0] = true;
                    }
                }
            });
        }
        if (energyChanged[0]) {
            this.syncToClient();
        }
    }

    protected void setEnergyInputSides(boolean[] sides) {
        this.energyInputSides = (boolean[])sides.clone();
    }

    protected void setEnergyOutputSides(boolean[] sides) {
        this.energyOutputSides = (boolean[])sides.clone();
    }

    protected void setEnergyInputSide(Direction side, boolean canInput) {
        this.energyInputSides[side.ordinal()] = canInput;
    }

    protected void setEnergyOutputSide(Direction side, boolean canOutput) {
        this.energyOutputSides[side.ordinal()] = canOutput;
    }

    protected void setActive(boolean active) {
        if (this.isActive != active) {
            this.isActive = active;
            this.m_6596_();
            this.syncToClient();
        }
    }

    protected void syncToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public int m_6643_() {
        return this.inventorySize;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return true;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return this.createMenu(id, playerInventory);
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2);

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("energy_stored", this.energyStorage.getEnergyStored());
        tag.m_128405_("max_energy_stored", this.energyStorage.getMaxEnergyStored());
        tag.m_128405_("energy_per_tick", this.energyPerTick);
        tag.m_128405_("max_energy_storage", this.maxEnergyStorage);
        tag.m_128379_("is_active", this.isActive);
        tag.m_128405_("progress_level", this.progressLevel);
        tag.m_128405_("max_progress_level", this.maxProgressLevel);
        CompoundTag energySidesTag = new CompoundTag();
        for (int i = 0; i < 6; ++i) {
            energySidesTag.m_128379_("input_" + i, this.energyInputSides[i]);
            energySidesTag.m_128379_("output_" + i, this.energyOutputSides[i]);
        }
        tag.m_128365_("energy_sides", (Tag)energySidesTag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energyStorage.setEnergy(tag.m_128451_("energy_stored"));
        this.energyStorage.setCapacity(tag.m_128451_("max_energy_stored"));
        this.energyPerTick = tag.m_128451_("energy_per_tick");
        this.maxEnergyStorage = tag.m_128451_("max_energy_storage");
        this.isActive = tag.m_128471_("is_active");
        this.progressLevel = tag.m_128451_("progress_level");
        this.maxProgressLevel = tag.m_128451_("max_progress_level");
        if (tag.m_128441_("energy_sides")) {
            CompoundTag energySidesTag = tag.m_128469_("energy_sides");
            for (int i = 0; i < 6; ++i) {
                this.energyInputSides[i] = energySidesTag.m_128471_("input_" + i);
                this.energyOutputSides[i] = energySidesTag.m_128471_("output_" + i);
            }
        }
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    public int getEnergyLevel() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyLevel() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public FriendlyByteBuf getStatePacket(FriendlyByteBuf buffer) {
        buffer.writeInt(this.energyStorage.getEnergyStored());
        buffer.writeInt(this.energyStorage.getMaxEnergyStored());
        buffer.writeBoolean(this.isActive);
        this.writeAdditionalStateData(buffer);
        return buffer;
    }

    @Override
    public void handleStatePacket(FriendlyByteBuf buffer) {
        int storedEnergy = buffer.readInt();
        int maxEnergy = buffer.readInt();
        this.isActive = buffer.readBoolean();
        this.energyStorage.setEnergy(storedEnergy);
        this.energyStorage.setCapacity(maxEnergy);
        this.readAdditionalStateData(buffer);
    }

    protected void writeAdditionalStateData(FriendlyByteBuf buffer) {
    }

    protected void readAdditionalStateData(FriendlyByteBuf buffer) {
    }

    @Override
    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        return this.getStatePacket(buffer);
    }

    @Override
    public void handleGuiPacket(FriendlyByteBuf buffer) {
        this.handleStatePacket(buffer);
    }

    public void sendStatePacket() {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            // empty if block
        }
    }

    protected void syncEnergyToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            if (side != null) {
                boolean canInput = this.energyInputSides[side.ordinal()];
                boolean canOutput = this.energyOutputSides[side.ordinal()];
                if (canInput || canOutput) {
                    return this.energyOptional.cast();
                }
                return LazyOptional.empty();
            }
            return this.energyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyOptional.invalidate();
    }

    public ResonanceEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public float getEnergyPercentage() {
        return this.energyStorage.getEnergyPercentage();
    }

    public int getEnergyPercentageInt() {
        return this.energyStorage.getEnergyPercentageInt();
    }

    protected static enum MachineEnergyRole {
        GENERATOR,
        CONSUMER,
        BOTH,
        ENERGY_INDEPENDENT;

    }
}

