/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.block.AnomalySpawnerMarkerBlock;
import com.hexvane.strangematter.entity.EchoingShadowEntity;
import com.hexvane.strangematter.entity.EnergeticRiftEntity;
import com.hexvane.strangematter.entity.GravityAnomalyEntity;
import com.hexvane.strangematter.entity.TemporalBloomEntity;
import com.hexvane.strangematter.entity.ThoughtwellEntity;
import com.hexvane.strangematter.entity.WarpGateAnomalyEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class AnomalySpawnerMarkerBlockEntity
extends BlockEntity {
    private static final String ENTITY_TYPE_KEY = "EntityType";
    private static final String SPAWN_X_KEY = "SpawnX";
    private static final String SPAWN_Y_KEY = "SpawnY";
    private static final String SPAWN_Z_KEY = "SpawnZ";
    private static final String SPAWN_YAW_KEY = "SpawnYaw";
    private static final String SPAWN_PITCH_KEY = "SpawnPitch";
    private static final String WARP_GATE_ACTIVE_KEY = "WarpGateActive";
    private String entityTypeId;
    private double spawnX;
    private double spawnY;
    private double spawnZ;
    private float spawnYaw;
    private float spawnPitch;
    private boolean warpGateActive;
    private boolean hasSpawned = false;
    private int spawnAttempts = 0;
    private static final int MAX_SPAWN_ATTEMPTS = 3;

    public AnomalySpawnerMarkerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StrangeMatterMod.ANOMALY_SPAWNER_MARKER_BLOCK_ENTITY.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AnomalySpawnerMarkerBlockEntity blockEntity) {
        if (blockEntity.hasSpawned || blockEntity.entityTypeId == null) {
            AnomalySpawnerMarkerBlockEntity.removeMarkerBlock(level, pos);
            return;
        }
        ++blockEntity.spawnAttempts;
        blockEntity.m_6596_();
        boolean spawned = blockEntity.spawnEntity(level);
        if (spawned) {
            blockEntity.hasSpawned = true;
            blockEntity.m_6596_();
            AnomalySpawnerMarkerBlockEntity.removeMarkerBlock(level, pos);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7654_().execute(() -> {
                    BlockState currentState = serverLevel.m_8055_(pos);
                    if (currentState.m_60734_() instanceof AnomalySpawnerMarkerBlock) {
                        serverLevel.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    }
                });
            }
        } else if (blockEntity.spawnAttempts >= 3) {
            StrangeMatterMod.LOGGER.warn("Marker block at {} failed to spawn entity after {} attempts, removing", (Object)pos, (Object)blockEntity.spawnAttempts);
            AnomalySpawnerMarkerBlockEntity.removeMarkerBlock(level, pos);
        }
    }

    private static void removeMarkerBlock(Level level, BlockPos pos) {
        if (level.f_46443_) {
            return;
        }
        level.m_46747_(pos);
        BlockState airState = Blocks.f_50016_.m_49966_();
        level.m_7731_(pos, airState, 3);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().execute(() -> {
                if (level.m_8055_(pos).m_60734_() instanceof AnomalySpawnerMarkerBlock) {
                    level.m_46747_(pos);
                    level.m_7731_(pos, airState, 3);
                }
            });
        }
    }

    private boolean spawnEntity(Level level) {
        if (level.f_46443_ || this.entityTypeId == null) {
            return false;
        }
        try {
            ResourceLocation entityLocation = ResourceLocation.parse((String)this.entityTypeId);
            Entity entity = this.createEntity(entityLocation, level);
            if (entity != null) {
                entity.m_7678_(this.spawnX, this.spawnY, this.spawnZ, this.spawnYaw, this.spawnPitch);
                if (entity instanceof WarpGateAnomalyEntity) {
                    WarpGateAnomalyEntity warpGate = (WarpGateAnomalyEntity)entity;
                    if (this.warpGateActive) {
                        warpGate.setActive(true);
                    }
                }
                return level.m_7967_(entity);
            }
            StrangeMatterMod.LOGGER.warn("Failed to create entity of type {} for marker at {}", (Object)this.entityTypeId, (Object)this.f_58858_);
        }
        catch (Exception e) {
            StrangeMatterMod.LOGGER.error("Failed to spawn entity from marker at {}: {}", new Object[]{this.f_58858_, e.getMessage(), e});
        }
        return false;
    }

    private Entity createEntity(ResourceLocation entityLocation, Level level) {
        String path;
        return switch (path = entityLocation.m_135815_()) {
            case "gravity_anomaly" -> new GravityAnomalyEntity((EntityType)StrangeMatterMod.GRAVITY_ANOMALY.get(), level);
            case "temporal_bloom" -> new TemporalBloomEntity((EntityType)StrangeMatterMod.TEMPORAL_BLOOM.get(), level);
            case "thoughtwell" -> new ThoughtwellEntity((EntityType)StrangeMatterMod.THOUGHTWELL.get(), level);
            case "echoing_shadow" -> new EchoingShadowEntity((EntityType)StrangeMatterMod.ECHOING_SHADOW.get(), level);
            case "energetic_rift" -> new EnergeticRiftEntity((EntityType)StrangeMatterMod.ENERGETIC_RIFT.get(), level);
            case "warp_gate_anomaly" -> new WarpGateAnomalyEntity((EntityType)StrangeMatterMod.WARP_GATE_ANOMALY_ENTITY.get(), level);
            default -> {
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityLocation);
                if (entityType != null) {
                    yield entityType.m_20615_(level);
                }
                StrangeMatterMod.LOGGER.warn("Unknown entity type: {}", (Object)entityLocation);
                yield null;
            }
        };
    }

    public void setEntityData(String entityTypeId, double x, double y, double z, float yaw, float pitch) {
        this.entityTypeId = entityTypeId;
        this.spawnX = x;
        this.spawnY = y;
        this.spawnZ = z;
        this.spawnYaw = yaw;
        this.spawnPitch = pitch;
        this.m_6596_();
    }

    public void setWarpGateActive(boolean active) {
        this.warpGateActive = active;
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.entityTypeId != null) {
            tag.m_128359_(ENTITY_TYPE_KEY, this.entityTypeId);
        }
        tag.m_128347_(SPAWN_X_KEY, this.spawnX);
        tag.m_128347_(SPAWN_Y_KEY, this.spawnY);
        tag.m_128347_(SPAWN_Z_KEY, this.spawnZ);
        tag.m_128350_(SPAWN_YAW_KEY, this.spawnYaw);
        tag.m_128350_(SPAWN_PITCH_KEY, this.spawnPitch);
        tag.m_128379_(WARP_GATE_ACTIVE_KEY, this.warpGateActive);
        tag.m_128379_("HasSpawned", this.hasSpawned);
        tag.m_128405_("SpawnAttempts", this.spawnAttempts);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.entityTypeId = tag.m_128441_(ENTITY_TYPE_KEY) ? tag.m_128461_(ENTITY_TYPE_KEY) : null;
        this.spawnX = tag.m_128459_(SPAWN_X_KEY);
        this.spawnY = tag.m_128459_(SPAWN_Y_KEY);
        this.spawnZ = tag.m_128459_(SPAWN_Z_KEY);
        this.spawnYaw = tag.m_128457_(SPAWN_YAW_KEY);
        this.spawnPitch = tag.m_128457_(SPAWN_PITCH_KEY);
        this.warpGateActive = tag.m_128471_(WARP_GATE_ACTIVE_KEY);
        this.hasSpawned = tag.m_128471_("HasSpawned");
        this.spawnAttempts = tag.m_128441_("SpawnAttempts") ? tag.m_128451_("SpawnAttempts") : 0;
    }
}

