/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.entity.BaseAnomalyEntity;
import com.hexvane.strangematter.entity.EchoingShadowEntity;
import com.hexvane.strangematter.entity.EnergeticRiftEntity;
import com.hexvane.strangematter.entity.GravityAnomalyEntity;
import com.hexvane.strangematter.entity.TemporalBloomEntity;
import com.hexvane.strangematter.entity.ThoughtwellEntity;
import com.hexvane.strangematter.entity.WarpGateAnomalyEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AnomalySpawnerMarkerBlock
extends Block {
    public static final EnumProperty<SpawnType> TYPE = EnumProperty.m_61587_((String)"type", SpawnType.class);
    public static final IntegerProperty ATTEMPTS = IntegerProperty.m_61631_((String)"attempts", (int)0, (int)3);
    private static final int MAX_ATTEMPTS = 3;

    public AnomalySpawnerMarkerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283808_).m_60910_().m_60913_(-1.0f, 3600000.0f).m_222994_().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TYPE, (Comparable)((Object)SpawnType.GRAVITY))).m_61124_((Property)ATTEMPTS, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean m_7923_(BlockState state) {
        return false;
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, ATTEMPTS});
    }

    public void m_213897_(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        int attempts = (Integer)state.m_61143_((Property)ATTEMPTS);
        if (attempts >= 3) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            return;
        }
        boolean spawned = this.spawnEntity(level, pos, (SpawnType)((Object)state.m_61143_(TYPE)));
        if (spawned) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ATTEMPTS, (Comparable)Integer.valueOf(attempts + 1)), 3);
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    private boolean spawnEntity(ServerLevel level, BlockPos pos, SpawnType type) {
        BaseAnomalyEntity entity = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SpawnType.GRAVITY -> new GravityAnomalyEntity((EntityType)StrangeMatterMod.GRAVITY_ANOMALY.get(), (Level)level);
            case SpawnType.TEMPORAL -> new TemporalBloomEntity((EntityType)StrangeMatterMod.TEMPORAL_BLOOM.get(), (Level)level);
            case SpawnType.ENERGETIC -> new EnergeticRiftEntity((EntityType)StrangeMatterMod.ENERGETIC_RIFT.get(), (Level)level);
            case SpawnType.SHADOW -> new EchoingShadowEntity((EntityType)StrangeMatterMod.ECHOING_SHADOW.get(), (Level)level);
            case SpawnType.COGNITIVE -> new ThoughtwellEntity((EntityType)StrangeMatterMod.THOUGHTWELL.get(), (Level)level);
            case SpawnType.WARP_GATE -> {
                WarpGateAnomalyEntity warpGate = new WarpGateAnomalyEntity((EntityType)StrangeMatterMod.WARP_GATE_ANOMALY_ENTITY.get(), (Level)level);
                warpGate.setActive(true);
                yield warpGate;
            }
        };
        entity.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
        return level.m_7967_((Entity)entity);
    }

    public static enum SpawnType implements StringRepresentable
    {
        GRAVITY("gravity"),
        TEMPORAL("temporal"),
        ENERGETIC("energetic"),
        SHADOW("shadow"),
        COGNITIVE("cognitive"),
        WARP_GATE("warp_gate");

        private final String serializedName;

        private SpawnType(String serializedName) {
            this.serializedName = serializedName;
        }

        public String m_7912_() {
            return this.serializedName;
        }
    }
}

