/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.block;

import com.hexvane.strangematter.block.BaseMachineBlockEntity;
import com.hexvane.strangematter.entity.BaseAnomalyEntity;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.research.ScannableObject;
import com.hexvane.strangematter.research.ScannableObjectRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AnomalyMachineBlockEntity
extends BaseMachineBlockEntity {
    protected int detectionRadius = 10;
    protected boolean hasNearbyAnomaly = false;
    protected ResearchType detectedAnomalyType = null;
    protected boolean spawnParticles = true;
    protected int particleSpawnRate = 5;

    public AnomalyMachineBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, int inventorySize) {
        super(blockEntityType, pos, state, inventorySize);
    }

    @Override
    protected void processMachine() {
        this.checkForNearbyAnomalies();
        if (this.hasNearbyAnomaly) {
            this.processAnomalyLogic();
        } else {
            this.setActive(false);
        }
    }

    @Override
    protected void clientTick() {
        if (this.spawnParticles && this.hasNearbyAnomaly && this.f_58857_.m_46467_() % (long)this.particleSpawnRate == 0L) {
            this.spawnAnomalyParticles();
        }
    }

    protected void checkForNearbyAnomalies() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos pos = this.m_58899_();
        boolean foundAnomaly = false;
        ResearchType anomalyType = null;
        for (Entity entity : this.f_58857_.m_45976_(Entity.class, AABB.m_165882_((Vec3)pos.m_252807_(), (double)(this.detectionRadius * 2), (double)(this.detectionRadius * 2), (double)(this.detectionRadius * 2)))) {
            if (!(entity instanceof BaseAnomalyEntity)) continue;
            foundAnomaly = true;
            Optional<ScannableObject> scannableOpt = ScannableObjectRegistry.getScannableForEntity(entity);
            if (!scannableOpt.isPresent()) break;
            anomalyType = scannableOpt.get().getResearchType();
            break;
        }
        if (this.hasNearbyAnomaly != foundAnomaly) {
            this.hasNearbyAnomaly = foundAnomaly;
            this.detectedAnomalyType = anomalyType;
            this.m_6596_();
            this.syncToClient();
        }
    }

    protected abstract void processAnomalyLogic();

    protected abstract void spawnAnomalyParticles();

    protected Vec3 getNearestAnomalyPosition() {
        if (this.f_58857_ == null || !this.hasNearbyAnomaly) {
            return null;
        }
        BlockPos pos = this.m_58899_();
        for (Entity entity : this.f_58857_.m_45976_(Entity.class, AABB.m_165882_((Vec3)pos.m_252807_(), (double)(this.detectionRadius * 2), (double)(this.detectionRadius * 2), (double)(this.detectionRadius * 2)))) {
            if (!(entity instanceof BaseAnomalyEntity)) continue;
            return entity.m_20182_();
        }
        return null;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("detection_radius", this.detectionRadius);
        tag.m_128379_("has_nearby_anomaly", this.hasNearbyAnomaly);
        tag.m_128359_("detected_anomaly_type", this.detectedAnomalyType != null ? this.detectedAnomalyType.name() : "");
        tag.m_128379_("spawn_particles", this.spawnParticles);
        tag.m_128405_("particle_spawn_rate", this.particleSpawnRate);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.detectionRadius = tag.m_128451_("detection_radius");
        this.hasNearbyAnomaly = tag.m_128471_("has_nearby_anomaly");
        String anomalyTypeName = tag.m_128461_("detected_anomaly_type");
        this.detectedAnomalyType = anomalyTypeName.isEmpty() ? null : ResearchType.valueOf(anomalyTypeName);
        this.spawnParticles = tag.m_128471_("spawn_particles");
        this.particleSpawnRate = tag.m_128451_("particle_spawn_rate");
    }

    public boolean hasNearbyAnomaly() {
        return this.hasNearbyAnomaly;
    }

    public ResearchType getDetectedAnomalyType() {
        return this.detectedAnomalyType;
    }

    public int getDetectionRadius() {
        return this.detectionRadius;
    }

    public void setDetectionRadius(int radius) {
        this.detectionRadius = radius;
        this.m_6596_();
        this.syncToClient();
    }

    public boolean isSpawnParticles() {
        return this.spawnParticles;
    }

    public void setSpawnParticles(boolean spawnParticles) {
        this.spawnParticles = spawnParticles;
        this.m_6596_();
        this.syncToClient();
    }
}

