/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.advancement.AnomalyEffectTrigger;
import com.hexvane.strangematter.advancement.CompleteResearchCategoryTrigger;
import com.hexvane.strangematter.advancement.ScanAnomalyTrigger;
import com.hexvane.strangematter.block.AnomalousGrassBlock;
import com.hexvane.strangematter.block.AnomalySpawnerMarkerBlock;
import com.hexvane.strangematter.block.AnomalySpawnerMarkerBlockEntity;
import com.hexvane.strangematter.block.ChronoShardOreBlock;
import com.hexvane.strangematter.block.EnergeticShardOreBlock;
import com.hexvane.strangematter.block.FancyResoniteTileBlock;
import com.hexvane.strangematter.block.GraviticShardOreBlock;
import com.hexvane.strangematter.block.InsightShardOreBlock;
import com.hexvane.strangematter.block.LevitationPadBlock;
import com.hexvane.strangematter.block.LevitationPadBlockEntity;
import com.hexvane.strangematter.block.ParadoxicalEnergyCellBlock;
import com.hexvane.strangematter.block.ParadoxicalEnergyCellBlockEntity;
import com.hexvane.strangematter.block.RealityForgeBlock;
import com.hexvane.strangematter.block.RealityForgeBlockEntity;
import com.hexvane.strangematter.block.ResearchMachineBlock;
import com.hexvane.strangematter.block.ResearchMachineBlockEntity;
import com.hexvane.strangematter.block.ResonanceCondenserBlock;
import com.hexvane.strangematter.block.ResonanceCondenserBlockEntity;
import com.hexvane.strangematter.block.ResonantBurnerBlock;
import com.hexvane.strangematter.block.ResonantBurnerBlockEntity;
import com.hexvane.strangematter.block.ResonantConduitBlock;
import com.hexvane.strangematter.block.ResonantConduitBlockEntity;
import com.hexvane.strangematter.block.ResoniteBlock;
import com.hexvane.strangematter.block.ResoniteDoorBlock;
import com.hexvane.strangematter.block.ResoniteOreBlock;
import com.hexvane.strangematter.block.ResonitePillarBlock;
import com.hexvane.strangematter.block.ResoniteTileBlock;
import com.hexvane.strangematter.block.ResoniteTileSlabBlock;
import com.hexvane.strangematter.block.ResoniteTileStairsBlock;
import com.hexvane.strangematter.block.ResoniteTrapdoorBlock;
import com.hexvane.strangematter.block.RiftStabilizerBlock;
import com.hexvane.strangematter.block.RiftStabilizerBlockEntity;
import com.hexvane.strangematter.block.ShadeShardOreBlock;
import com.hexvane.strangematter.block.ShardCrystalBlock;
import com.hexvane.strangematter.block.ShardLampBlock;
import com.hexvane.strangematter.block.ShardLanternBlock;
import com.hexvane.strangematter.block.SpatialShardOreBlock;
import com.hexvane.strangematter.block.StasisProjectorBlock;
import com.hexvane.strangematter.block.StasisProjectorBlockEntity;
import com.hexvane.strangematter.block.TimeDilationBlock;
import com.hexvane.strangematter.block.TimeDilationBlockEntity;
import com.hexvane.strangematter.command.AnomalyCommand;
import com.hexvane.strangematter.command.ResearchCommand;
import com.hexvane.strangematter.command.ResearchPointsCommand;
import com.hexvane.strangematter.entity.ChronoBlisterProjectileEntity;
import com.hexvane.strangematter.entity.EchoingShadowEntity;
import com.hexvane.strangematter.entity.EnergeticRiftEntity;
import com.hexvane.strangematter.entity.GravityAnomalyEntity;
import com.hexvane.strangematter.entity.HoverboardEntity;
import com.hexvane.strangematter.entity.MiniWarpGateEntity;
import com.hexvane.strangematter.entity.TemporalBloomEntity;
import com.hexvane.strangematter.entity.ThoughtwellEntity;
import com.hexvane.strangematter.entity.ThrowableContainmentCapsuleEntity;
import com.hexvane.strangematter.entity.WarpGateAnomalyEntity;
import com.hexvane.strangematter.entity.WarpProjectileEntity;
import com.hexvane.strangematter.item.AnomalousGrassItem;
import com.hexvane.strangematter.item.AnomalyResonatorItem;
import com.hexvane.strangematter.item.ChronoBlisterItem;
import com.hexvane.strangematter.item.ChronoShardItem;
import com.hexvane.strangematter.item.ContainmentCapsuleItem;
import com.hexvane.strangematter.item.EchoVacuumItem;
import com.hexvane.strangematter.item.EchoformImprinterItem;
import com.hexvane.strangematter.item.EnergeticShardItem;
import com.hexvane.strangematter.item.FieldScannerItem;
import com.hexvane.strangematter.item.GraviticShardItem;
import com.hexvane.strangematter.item.GravitonHammerItem;
import com.hexvane.strangematter.item.HoverboardItem;
import com.hexvane.strangematter.item.InsightShardItem;
import com.hexvane.strangematter.item.ParadoxicalEnergyCellItem;
import com.hexvane.strangematter.item.RawResoniteItem;
import com.hexvane.strangematter.item.ResearchNoteItem;
import com.hexvane.strangematter.item.ResearchTabletItem;
import com.hexvane.strangematter.item.ResonanceCondenserItem;
import com.hexvane.strangematter.item.ResonantCircuitItem;
import com.hexvane.strangematter.item.ResonantCoilItem;
import com.hexvane.strangematter.item.ResonantConduitItem;
import com.hexvane.strangematter.item.ResoniteIngotItem;
import com.hexvane.strangematter.item.ResoniteNuggetItem;
import com.hexvane.strangematter.item.ShadeShardItem;
import com.hexvane.strangematter.item.SpatialShardItem;
import com.hexvane.strangematter.item.StabilizedCoreItem;
import com.hexvane.strangematter.item.TinfoilHatItem;
import com.hexvane.strangematter.item.WarpGunItem;
import com.hexvane.strangematter.menu.RealityForgeMenu;
import com.hexvane.strangematter.menu.ResonanceCondenserMenu;
import com.hexvane.strangematter.menu.ResonantBurnerMenu;
import com.hexvane.strangematter.network.NetworkHandler;
import com.hexvane.strangematter.recipe.RealityForgeRecipe;
import com.hexvane.strangematter.research.ResearchNodeRegistry;
import com.hexvane.strangematter.research.ScannableObjectRegistry;
import com.hexvane.strangematter.sound.StrangeMatterSounds;
import com.hexvane.strangematter.worldgen.ConfiguredBiomeModifier;
import com.hexvane.strangematter.worldgen.ConfiguredCountPlacement;
import com.hexvane.strangematter.worldgen.ConfiguredRarityFilter;
import com.hexvane.strangematter.worldgen.EchoingShadowConfiguredFeature;
import com.hexvane.strangematter.worldgen.EnergeticRiftConfiguredFeature;
import com.hexvane.strangematter.worldgen.GravityAnomalyConfiguredFeature;
import com.hexvane.strangematter.worldgen.TemporalBloomConfiguredFeature;
import com.hexvane.strangematter.worldgen.ThoughtwellConfiguredFeature;
import com.hexvane.strangematter.worldgen.WarpGateAnomalyConfiguredFeature;
import com.hexvane.strangematter.worldgen.WarpGateAnomalyStructure;
import com.hexvane.strangematter.worldgen.WorldGenUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="strangematter")
public class StrangeMatterMod {
    public static final String MODID = "strangematter";
    public static final UUID LOW_GRAVITY_MODIFIER_ID = UUID.fromString("12345678-1234-1234-1234-123456789abc");
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"strangematter");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"strangematter");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"strangematter");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"strangematter");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"strangematter");
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"strangematter");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registries.f_256833_, (String)"strangematter");
    public static final DeferredRegister<PlacementModifierType<?>> PLACEMENT_MODIFIERS = DeferredRegister.create((ResourceKey)Registries.f_256843_, (String)"strangematter");
    public static final RegistryObject<PlacementModifierType<ConfiguredRarityFilter>> CONFIGURED_RARITY_FILTER = PLACEMENT_MODIFIERS.register("configured_rarity_filter", () -> () -> ConfiguredRarityFilter.CODEC);
    public static final RegistryObject<PlacementModifierType<ConfiguredCountPlacement>> CONFIGURED_COUNT_PLACEMENT = PLACEMENT_MODIFIERS.register("configured_count_placement", () -> () -> ConfiguredCountPlacement.CODEC);
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256938_, (String)"strangematter");
    public static final RegistryObject<StructureType<WarpGateAnomalyStructure>> WARP_GATE_ANOMALY_STRUCTURE = STRUCTURE_TYPES.register("warp_gate_anomaly", () -> () -> WarpGateAnomalyStructure.CODEC);
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"strangematter");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"strangematter");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"strangematter");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"strangematter");
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"strangematter");
    public static final DeferredRegister<VillagerProfession> VILLAGER_PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"strangematter");
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"strangematter");
    public static final RegistryObject<Codec<ConfiguredBiomeModifier>> CONFIGURED_BIOME_MODIFIER = BIOME_MODIFIER_SERIALIZERS.register("configured_biome_modifier", () -> ConfiguredBiomeModifier.CODEC);
    public static final RegistryObject<Item> FIELD_SCANNER = ITEMS.register("field_scanner", FieldScannerItem::new);
    public static final RegistryObject<Item> ANOMALY_RESONATOR = ITEMS.register("anomaly_resonator", AnomalyResonatorItem::new);
    public static final RegistryObject<Item> ECHOFORM_IMPRINTER = ITEMS.register("echoform_imprinter", EchoformImprinterItem::new);
    public static final RegistryObject<Item> RESEARCH_NOTES = ITEMS.register("research_notes", () -> new ResearchNoteItem(new Item.Properties()));
    public static final RegistryObject<Block> ANOMALOUS_GRASS_BLOCK = BLOCKS.register("anomalous_grass", AnomalousGrassBlock::new);
    public static final RegistryObject<Item> ANOMALOUS_GRASS_ITEM = ITEMS.register("anomalous_grass", () -> new AnomalousGrassItem((AnomalousGrassBlock)((Object)((Object)ANOMALOUS_GRASS_BLOCK.get()))));
    public static final RegistryObject<Block> RESONITE_ORE_BLOCK = BLOCKS.register("resonite_ore", ResoniteOreBlock::new);
    public static final RegistryObject<Block> RESONITE_BLOCK = BLOCKS.register("resonite_block", ResoniteBlock::new);
    public static final RegistryObject<Item> RESONITE_BLOCK_ITEM = ITEMS.register("resonite_block", () -> new BlockItem((Block)RESONITE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Block> RESONITE_TILE_BLOCK = BLOCKS.register("resonite_tile", ResoniteTileBlock::new);
    public static final RegistryObject<Item> RESONITE_TILE_ITEM = ITEMS.register("resonite_tile", () -> new BlockItem((Block)RESONITE_TILE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Block> RESONITE_TILE_STAIRS_BLOCK = BLOCKS.register("resonite_tile_stairs", ResoniteTileStairsBlock::new);
    public static final RegistryObject<Item> RESONITE_TILE_STAIRS_ITEM = ITEMS.register("resonite_tile_stairs", () -> new BlockItem((Block)RESONITE_TILE_STAIRS_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Block> FANCY_RESONITE_TILE_BLOCK = BLOCKS.register("fancy_resonite_tile", FancyResoniteTileBlock::new);
    public static final RegistryObject<Item> FANCY_RESONITE_TILE_ITEM = ITEMS.register("fancy_resonite_tile", () -> new BlockItem((Block)FANCY_RESONITE_TILE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Block> RESONITE_PILLAR_BLOCK = BLOCKS.register("resonite_pillar", ResonitePillarBlock::new);
    public static final RegistryObject<Item> RESONITE_PILLAR_ITEM = ITEMS.register("resonite_pillar", () -> new BlockItem((Block)RESONITE_PILLAR_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Block> RESONITE_DOOR_BLOCK = BLOCKS.register("resonite_door", ResoniteDoorBlock::new);
    public static final RegistryObject<Item> RESONITE_DOOR_ITEM = ITEMS.register("resonite_door", () -> new DoubleHighBlockItem((Block)RESONITE_DOOR_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Block> RESONITE_TILE_SLAB_BLOCK = BLOCKS.register("resonite_tile_slab", ResoniteTileSlabBlock::new);
    public static final RegistryObject<Item> RESONITE_TILE_SLAB_ITEM = ITEMS.register("resonite_tile_slab", () -> new BlockItem((Block)RESONITE_TILE_SLAB_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Block> RESONITE_TRAPDOOR_BLOCK = BLOCKS.register("resonite_trapdoor", ResoniteTrapdoorBlock::new);
    public static final RegistryObject<Item> RESONITE_TRAPDOOR_ITEM = ITEMS.register("resonite_trapdoor", () -> new BlockItem((Block)RESONITE_TRAPDOOR_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Block> GRAVITIC_SHARD_ORE_BLOCK = BLOCKS.register("gravitic_shard_ore", GraviticShardOreBlock::new);
    public static final RegistryObject<Block> CHRONO_SHARD_ORE_BLOCK = BLOCKS.register("chrono_shard_ore", ChronoShardOreBlock::new);
    public static final RegistryObject<Block> SPATIAL_SHARD_ORE_BLOCK = BLOCKS.register("spatial_shard_ore", SpatialShardOreBlock::new);
    public static final RegistryObject<Block> SHADE_SHARD_ORE_BLOCK = BLOCKS.register("shade_shard_ore", ShadeShardOreBlock::new);
    public static final RegistryObject<Block> INSIGHT_SHARD_ORE_BLOCK = BLOCKS.register("insight_shard_ore", InsightShardOreBlock::new);
    public static final RegistryObject<Block> ENERGETIC_SHARD_ORE_BLOCK = BLOCKS.register("energetic_shard_ore", EnergeticShardOreBlock::new);
    public static final RegistryObject<Block> RESEARCH_MACHINE_BLOCK = BLOCKS.register("research_machine", ResearchMachineBlock::new);
    public static final RegistryObject<Item> RESEARCH_MACHINE_ITEM = ITEMS.register("research_machine", () -> new BlockItem((Block)RESEARCH_MACHINE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<BlockEntityType<ResearchMachineBlockEntity>> RESEARCH_MACHINE_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("research_machine", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new ResearchMachineBlockEntity(pos, state), (Block[])new Block[]{(Block)RESEARCH_MACHINE_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<Item> RESONITE_ORE_ITEM = ITEMS.register("resonite_ore", () -> new BlockItem((Block)RESONITE_ORE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> GRAVITIC_SHARD_ORE_ITEM = ITEMS.register("gravitic_shard_ore", () -> new BlockItem((Block)GRAVITIC_SHARD_ORE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> CHRONO_SHARD_ORE_ITEM = ITEMS.register("chrono_shard_ore", () -> new BlockItem((Block)CHRONO_SHARD_ORE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> SPATIAL_SHARD_ORE_ITEM = ITEMS.register("spatial_shard_ore", () -> new BlockItem((Block)SPATIAL_SHARD_ORE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> SHADE_SHARD_ORE_ITEM = ITEMS.register("shade_shard_ore", () -> new BlockItem((Block)SHADE_SHARD_ORE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> INSIGHT_SHARD_ORE_ITEM = ITEMS.register("insight_shard_ore", () -> new BlockItem((Block)INSIGHT_SHARD_ORE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> ENERGETIC_SHARD_ORE_ITEM = ITEMS.register("energetic_shard_ore", () -> new BlockItem((Block)ENERGETIC_SHARD_ORE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> RAW_RESONITE = ITEMS.register("raw_resonite", RawResoniteItem::new);
    public static final RegistryObject<Item> RESONITE_INGOT = ITEMS.register("resonite_ingot", ResoniteIngotItem::new);
    public static final RegistryObject<Item> RESONITE_NUGGET = ITEMS.register("resonite_nugget", ResoniteNuggetItem::new);
    public static final RegistryObject<Item> RESONANT_COIL = ITEMS.register("resonant_coil", ResonantCoilItem::new);
    public static final RegistryObject<Item> STABILIZED_CORE = ITEMS.register("stabilized_core", StabilizedCoreItem::new);
    public static final RegistryObject<Item> RESONANT_CIRCUIT = ITEMS.register("resonant_circuit", ResonantCircuitItem::new);
    public static final RegistryObject<Item> RESEARCH_TABLET = ITEMS.register("research_tablet", ResearchTabletItem::new);
    public static final RegistryObject<Item> GRAVITIC_SHARD = ITEMS.register("gravitic_shard", GraviticShardItem::new);
    public static final RegistryObject<Item> CHRONO_SHARD = ITEMS.register("chrono_shard", ChronoShardItem::new);
    public static final RegistryObject<Item> SPATIAL_SHARD = ITEMS.register("spatial_shard", SpatialShardItem::new);
    public static final RegistryObject<Item> SHADE_SHARD = ITEMS.register("shade_shard", ShadeShardItem::new);
    public static final RegistryObject<Item> INSIGHT_SHARD = ITEMS.register("insight_shard", InsightShardItem::new);
    public static final RegistryObject<Item> ENERGETIC_SHARD = ITEMS.register("energetic_shard", EnergeticShardItem::new);
    public static final RegistryObject<Block> SHADE_SHARD_CRYSTAL = BLOCKS.register("shade_shard_crystal", ShardCrystalBlock::new);
    public static final RegistryObject<Item> SHADE_SHARD_CRYSTAL_ITEM = ITEMS.register("shade_shard_crystal", () -> new BlockItem((Block)SHADE_SHARD_CRYSTAL.get(), new Item.Properties()));
    public static final RegistryObject<Block> GRAVITIC_SHARD_CRYSTAL = BLOCKS.register("gravitic_shard_crystal", ShardCrystalBlock::new);
    public static final RegistryObject<Item> GRAVITIC_SHARD_CRYSTAL_ITEM = ITEMS.register("gravitic_shard_crystal", () -> new BlockItem((Block)GRAVITIC_SHARD_CRYSTAL.get(), new Item.Properties()));
    public static final RegistryObject<Block> ENERGETIC_SHARD_CRYSTAL = BLOCKS.register("energetic_shard_crystal", ShardCrystalBlock::new);
    public static final RegistryObject<Item> ENERGETIC_SHARD_CRYSTAL_ITEM = ITEMS.register("energetic_shard_crystal", () -> new BlockItem((Block)ENERGETIC_SHARD_CRYSTAL.get(), new Item.Properties()));
    public static final RegistryObject<Block> INSIGHT_SHARD_CRYSTAL = BLOCKS.register("insight_shard_crystal", ShardCrystalBlock::new);
    public static final RegistryObject<Item> INSIGHT_SHARD_CRYSTAL_ITEM = ITEMS.register("insight_shard_crystal", () -> new BlockItem((Block)INSIGHT_SHARD_CRYSTAL.get(), new Item.Properties()));
    public static final RegistryObject<Block> CHRONO_SHARD_CRYSTAL = BLOCKS.register("chrono_shard_crystal", ShardCrystalBlock::new);
    public static final RegistryObject<Item> CHRONO_SHARD_CRYSTAL_ITEM = ITEMS.register("chrono_shard_crystal", () -> new BlockItem((Block)CHRONO_SHARD_CRYSTAL.get(), new Item.Properties()));
    public static final RegistryObject<Block> SPATIAL_SHARD_CRYSTAL = BLOCKS.register("spatial_shard_crystal", ShardCrystalBlock::new);
    public static final RegistryObject<Item> SPATIAL_SHARD_CRYSTAL_ITEM = ITEMS.register("spatial_shard_crystal", () -> new BlockItem((Block)SPATIAL_SHARD_CRYSTAL.get(), new Item.Properties()));
    public static final RegistryObject<Block> SHADE_SHARD_LAMP = BLOCKS.register("shade_shard_lamp", ShardLampBlock::new);
    public static final RegistryObject<Item> SHADE_SHARD_LAMP_ITEM = ITEMS.register("shade_shard_lamp", () -> new BlockItem((Block)SHADE_SHARD_LAMP.get(), new Item.Properties()));
    public static final RegistryObject<Block> GRAVITIC_SHARD_LAMP = BLOCKS.register("gravitic_shard_lamp", ShardLampBlock::new);
    public static final RegistryObject<Item> GRAVITIC_SHARD_LAMP_ITEM = ITEMS.register("gravitic_shard_lamp", () -> new BlockItem((Block)GRAVITIC_SHARD_LAMP.get(), new Item.Properties()));
    public static final RegistryObject<Block> ENERGETIC_SHARD_LAMP = BLOCKS.register("energetic_shard_lamp", ShardLampBlock::new);
    public static final RegistryObject<Item> ENERGETIC_SHARD_LAMP_ITEM = ITEMS.register("energetic_shard_lamp", () -> new BlockItem((Block)ENERGETIC_SHARD_LAMP.get(), new Item.Properties()));
    public static final RegistryObject<Block> INSIGHT_SHARD_LAMP = BLOCKS.register("insight_shard_lamp", ShardLampBlock::new);
    public static final RegistryObject<Item> INSIGHT_SHARD_LAMP_ITEM = ITEMS.register("insight_shard_lamp", () -> new BlockItem((Block)INSIGHT_SHARD_LAMP.get(), new Item.Properties()));
    public static final RegistryObject<Block> CHRONO_SHARD_LAMP = BLOCKS.register("chrono_shard_lamp", ShardLampBlock::new);
    public static final RegistryObject<Item> CHRONO_SHARD_LAMP_ITEM = ITEMS.register("chrono_shard_lamp", () -> new BlockItem((Block)CHRONO_SHARD_LAMP.get(), new Item.Properties()));
    public static final RegistryObject<Block> SPATIAL_SHARD_LAMP = BLOCKS.register("spatial_shard_lamp", ShardLampBlock::new);
    public static final RegistryObject<Item> SPATIAL_SHARD_LAMP_ITEM = ITEMS.register("spatial_shard_lamp", () -> new BlockItem((Block)SPATIAL_SHARD_LAMP.get(), new Item.Properties()));
    public static final RegistryObject<Block> SHADE_SHARD_LANTERN = BLOCKS.register("shade_shard_lantern", ShardLanternBlock::new);
    public static final RegistryObject<Item> SHADE_SHARD_LANTERN_ITEM = ITEMS.register("shade_shard_lantern", () -> new BlockItem((Block)SHADE_SHARD_LANTERN.get(), new Item.Properties()));
    public static final RegistryObject<Block> GRAVITIC_SHARD_LANTERN = BLOCKS.register("gravitic_shard_lantern", ShardLanternBlock::new);
    public static final RegistryObject<Item> GRAVITIC_SHARD_LANTERN_ITEM = ITEMS.register("gravitic_shard_lantern", () -> new BlockItem((Block)GRAVITIC_SHARD_LANTERN.get(), new Item.Properties()));
    public static final RegistryObject<Block> ENERGETIC_SHARD_LANTERN = BLOCKS.register("energetic_shard_lantern", ShardLanternBlock::new);
    public static final RegistryObject<Item> ENERGETIC_SHARD_LANTERN_ITEM = ITEMS.register("energetic_shard_lantern", () -> new BlockItem((Block)ENERGETIC_SHARD_LANTERN.get(), new Item.Properties()));
    public static final RegistryObject<Block> INSIGHT_SHARD_LANTERN = BLOCKS.register("insight_shard_lantern", ShardLanternBlock::new);
    public static final RegistryObject<Item> INSIGHT_SHARD_LANTERN_ITEM = ITEMS.register("insight_shard_lantern", () -> new BlockItem((Block)INSIGHT_SHARD_LANTERN.get(), new Item.Properties()));
    public static final RegistryObject<Block> CHRONO_SHARD_LANTERN = BLOCKS.register("chrono_shard_lantern", ShardLanternBlock::new);
    public static final RegistryObject<Item> CHRONO_SHARD_LANTERN_ITEM = ITEMS.register("chrono_shard_lantern", () -> new BlockItem((Block)CHRONO_SHARD_LANTERN.get(), new Item.Properties()));
    public static final RegistryObject<Block> SPATIAL_SHARD_LANTERN = BLOCKS.register("spatial_shard_lantern", ShardLanternBlock::new);
    public static final RegistryObject<Item> SPATIAL_SHARD_LANTERN_ITEM = ITEMS.register("spatial_shard_lantern", () -> new BlockItem((Block)SPATIAL_SHARD_LANTERN.get(), new Item.Properties()));
    public static final RegistryObject<Item> WARP_GUN = ITEMS.register("warp_gun", WarpGunItem::new);
    public static final RegistryObject<Item> CHRONO_BLISTER = ITEMS.register("chrono_blister", ChronoBlisterItem::new);
    public static final RegistryObject<Item> ECHO_VACUUM = ITEMS.register("echo_vacuum", EchoVacuumItem::new);
    public static final RegistryObject<Item> GRAVITON_HAMMER = ITEMS.register("graviton_hammer", GravitonHammerItem::new);
    public static final RegistryObject<Item> TINFOIL_HAT = ITEMS.register("tinfoil_hat", TinfoilHatItem::new);
    public static final RegistryObject<Item> CONTAINMENT_CAPSULE = ITEMS.register("containment_capsule", () -> new ContainmentCapsuleItem(ContainmentCapsuleItem.AnomalyType.NONE));
    public static final RegistryObject<Item> CONTAINMENT_CAPSULE_GRAVITY = ITEMS.register("containment_capsule_gravity", () -> new ContainmentCapsuleItem(ContainmentCapsuleItem.AnomalyType.GRAVITY));
    public static final RegistryObject<Item> CONTAINMENT_CAPSULE_ENERGETIC = ITEMS.register("containment_capsule_energetic", () -> new ContainmentCapsuleItem(ContainmentCapsuleItem.AnomalyType.ENERGETIC));
    public static final RegistryObject<Item> CONTAINMENT_CAPSULE_ECHOING_SHADOW = ITEMS.register("containment_capsule_echoing_shadow", () -> new ContainmentCapsuleItem(ContainmentCapsuleItem.AnomalyType.ECHOING_SHADOW));
    public static final RegistryObject<Item> CONTAINMENT_CAPSULE_TEMPORAL_BLOOM = ITEMS.register("containment_capsule_temporal_bloom", () -> new ContainmentCapsuleItem(ContainmentCapsuleItem.AnomalyType.TEMPORAL_BLOOM));
    public static final RegistryObject<Item> CONTAINMENT_CAPSULE_THOUGHTWELL = ITEMS.register("containment_capsule_thoughtwell", () -> new ContainmentCapsuleItem(ContainmentCapsuleItem.AnomalyType.THOUGHTWELL));
    public static final RegistryObject<Item> CONTAINMENT_CAPSULE_WARP_GATE = ITEMS.register("containment_capsule_warp_gate", () -> new ContainmentCapsuleItem(ContainmentCapsuleItem.AnomalyType.WARP_GATE));
    public static final RegistryObject<Block> REALITY_FORGE_BLOCK;
    public static final RegistryObject<Item> REALITY_FORGE_ITEM;
    public static final RegistryObject<BlockEntityType<RealityForgeBlockEntity>> REALITY_FORGE_BLOCK_ENTITY;
    public static final RegistryObject<Block> RESONANCE_CONDENSER_BLOCK;
    public static final RegistryObject<Item> RESONANCE_CONDENSER_ITEM;
    public static final RegistryObject<BlockEntityType<ResonanceCondenserBlockEntity>> RESONANCE_CONDENSER_BLOCK_ENTITY;
    public static final RegistryObject<Block> RESONANT_BURNER_BLOCK;
    public static final RegistryObject<Item> RESONANT_BURNER_ITEM;
    public static final RegistryObject<BlockEntityType<ResonantBurnerBlockEntity>> RESONANT_BURNER_BLOCK_ENTITY;
    public static final RegistryObject<Block> PARADOXICAL_ENERGY_CELL_BLOCK;
    public static final RegistryObject<Item> PARADOXICAL_ENERGY_CELL_ITEM;
    public static final RegistryObject<BlockEntityType<ParadoxicalEnergyCellBlockEntity>> PARADOXICAL_ENERGY_CELL_BLOCK_ENTITY;
    public static final RegistryObject<Block> RIFT_STABILIZER_BLOCK;
    public static final RegistryObject<Item> RIFT_STABILIZER_ITEM;
    public static final RegistryObject<BlockEntityType<RiftStabilizerBlockEntity>> RIFT_STABILIZER_BLOCK_ENTITY;
    public static final RegistryObject<Block> STASIS_PROJECTOR_BLOCK;
    public static final RegistryObject<Item> STASIS_PROJECTOR_ITEM;
    public static final RegistryObject<BlockEntityType<StasisProjectorBlockEntity>> STASIS_PROJECTOR_BLOCK_ENTITY;
    public static final RegistryObject<Block> RESONANT_CONDUIT_BLOCK;
    public static final RegistryObject<Item> RESONANT_CONDUIT_ITEM;
    public static final RegistryObject<BlockEntityType<ResonantConduitBlockEntity>> RESONANT_CONDUIT_BLOCK_ENTITY;
    public static final RegistryObject<Block> LEVITATION_PAD_BLOCK;
    public static final RegistryObject<Item> LEVITATION_PAD_ITEM;
    public static final RegistryObject<BlockEntityType<LevitationPadBlockEntity>> LEVITATION_PAD_BLOCK_ENTITY;
    public static final RegistryObject<Block> TIME_DILATION_BLOCK;
    public static final RegistryObject<Item> TIME_DILATION_BLOCK_ITEM;
    public static final RegistryObject<BlockEntityType<TimeDilationBlockEntity>> TIME_DILATION_BLOCK_ENTITY;
    public static final RegistryObject<Block> ANOMALY_SPAWNER_MARKER_BLOCK;
    public static final RegistryObject<BlockEntityType<AnomalySpawnerMarkerBlockEntity>> ANOMALY_SPAWNER_MARKER_BLOCK_ENTITY;
    public static final RegistryObject<PoiType> RESEARCH_MACHINE_POI;
    public static final RegistryObject<VillagerProfession> ANOMALY_SCIENTIST;
    public static final RegistryObject<SimpleParticleType> ENERGY_ABSORPTION_PARTICLE;
    public static final RegistryObject<MenuType<ResonanceCondenserMenu>> RESONANCE_CONDENSER_MENU;
    public static final RegistryObject<MenuType<ResonantBurnerMenu>> RESONANT_BURNER_MENU;
    public static final RegistryObject<MenuType<RealityForgeMenu>> REALITY_FORGE_MENU;
    public static final RegistryObject<RecipeType<RealityForgeRecipe>> REALITY_FORGE_RECIPE_TYPE;
    public static final RegistryObject<RecipeSerializer<RealityForgeRecipe>> REALITY_FORGE_RECIPE_SERIALIZER;
    public static final RegistryObject<Item> HOVERBOARD;
    public static final RegistryObject<EntityType<HoverboardEntity>> HOVERBOARD_ENTITY;
    public static final RegistryObject<Attribute> ENTITY_GRAVITY;
    public static final RegistryObject<EntityType<GravityAnomalyEntity>> GRAVITY_ANOMALY;
    public static final RegistryObject<EntityType<EnergeticRiftEntity>> ENERGETIC_RIFT;
    public static final RegistryObject<EntityType<EchoingShadowEntity>> ECHOING_SHADOW;
    public static final RegistryObject<EntityType<WarpGateAnomalyEntity>> WARP_GATE_ANOMALY_ENTITY;
    public static final RegistryObject<EntityType<TemporalBloomEntity>> TEMPORAL_BLOOM;
    public static final RegistryObject<EntityType<ThoughtwellEntity>> THOUGHTWELL;
    public static final RegistryObject<EntityType<WarpProjectileEntity>> WARP_PROJECTILE_ENTITY;
    public static final RegistryObject<EntityType<ChronoBlisterProjectileEntity>> CHRONO_BLISTER_PROJECTILE_ENTITY;
    public static final RegistryObject<EntityType<MiniWarpGateEntity>> MINI_WARP_GATE_ENTITY;
    public static final RegistryObject<EntityType<ThrowableContainmentCapsuleEntity>> THROWABLE_CONTAINMENT_CAPSULE;
    public static final AnomalyEffectTrigger ANOMALY_EFFECT_TRIGGER;
    public static final ScanAnomalyTrigger SCAN_ANOMALY_TRIGGER;
    public static final CompleteResearchCategoryTrigger COMPLETE_RESEARCH_CATEGORY_TRIGGER;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> GRAVITY_ANOMALY_FEATURE;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> ENERGETIC_RIFT_FEATURE;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> ECHOING_SHADOW_FEATURE;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> TEMPORAL_BLOOM_FEATURE;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> THOUGHTWELL_FEATURE;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> WARP_GATE_ANOMALY_FEATURE;
    public static final RegistryObject<CreativeModeTab> STRANGE_MATTER_TAB;
    private static final Map<Player, Boolean> playerBeamStates;

    public StrangeMatterMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        NetworkHandler.register();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        ENTITY_TYPES.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        StrangeMatterSounds.SOUND_EVENTS.register(modEventBus);
        MENU_TYPES.register(modEventBus);
        RECIPE_TYPES.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        ATTRIBUTES.register(modEventBus);
        FEATURES.register(modEventBus);
        PLACEMENT_MODIFIERS.register(modEventBus);
        STRUCTURE_TYPES.register(modEventBus);
        PARTICLE_TYPES.register(modEventBus);
        BIOME_MODIFIER_SERIALIZERS.register(modEventBus);
        VILLAGER_PROFESSIONS.register(modEventBus);
        POI_TYPES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Strange Matter mod initialized - reality anomalies detected!");
        event.enqueueWork(() -> {
            ScannableObjectRegistry.init();
            ResearchNodeRegistry.initializeDefaultNodes();
            CriteriaTriggers.m_10595_((CriterionTrigger)ANOMALY_EFFECT_TRIGGER);
            CriteriaTriggers.m_10595_((CriterionTrigger)SCAN_ANOMALY_TRIGGER);
            CriteriaTriggers.m_10595_((CriterionTrigger)COMPLETE_RESEARCH_CATEGORY_TRIGGER);
        });
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        try {
            AnomalyCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
        catch (Exception e) {
            System.err.println("Failed to register AnomalyCommand: " + e.getMessage());
            e.printStackTrace();
        }
        ResearchCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ResearchPointsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"test_gravity_anomaly").requires(source -> source.m_6761_(2))).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.m_81372_();
            Vec3 pos = source.m_81371_();
            if (pos != null) {
                BlockState blockState;
                BlockPos surfacePos;
                int surfaceY = level.m_6924_(Heightmap.Types.WORLD_SURFACE, (int)pos.f_82479_, (int)pos.f_82481_);
                BlockPos groundPos = surfacePos = new BlockPos((int)pos.f_82479_, surfaceY, (int)pos.f_82481_);
                while (groundPos.m_123342_() > level.m_141937_() + 10 && (!(blockState = level.m_8055_(groundPos)).m_280296_() || blockState.m_60795_() || blockState.m_60734_().m_7705_().contains("leaves"))) {
                    groundPos = groundPos.m_7495_();
                }
                if (groundPos.m_123342_() <= level.m_141937_() + 10) {
                    source.m_81352_((Component)Component.m_237113_((String)("No solid ground found below surface at " + surfacePos)));
                    return 1;
                }
                int anomalyY = surfaceY + 3;
                BlockPos anomalyPos = new BlockPos((int)pos.f_82479_, anomalyY, (int)pos.f_82481_);
                BlockPos finalGroundPos = groundPos;
                int radius = 3;
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockPos grassPos;
                        double distance = Math.sqrt(x * x + z * z);
                        if (!(distance <= (double)radius) || !(level.f_46441_.m_188501_() < 0.7f) || (grassPos = WorldGenUtils.findAnomalousGrassPosition((WorldGenLevel)level, (int)pos.f_82479_ + x, (int)pos.f_82481_ + z)) == null) continue;
                        level.m_7731_(grassPos, ((Block)ANOMALOUS_GRASS_BLOCK.get()).m_49966_(), 3);
                    }
                }
                GravityAnomalyEntity anomaly = new GravityAnomalyEntity((EntityType)GRAVITY_ANOMALY.get(), (Level)level);
                anomaly.m_7678_((double)anomalyPos.m_123341_() + 0.5, anomalyPos.m_123342_(), (double)anomalyPos.m_123343_() + 0.5, 0.0f, 0.0f);
                if (level.m_7967_((Entity)anomaly)) {
                    source.m_288197_(() -> Component.m_237113_((String)("Test gravity anomaly placed at " + anomalyPos + " (ground at " + finalGroundPos + ")")), true);
                } else {
                    source.m_81352_((Component)Component.m_237113_((String)("Failed to place gravity anomaly at " + anomalyPos)));
                }
            }
            return 1;
        }));
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            event.m_246326_((ItemLike)ANOMALOUS_GRASS_ITEM.get());
            event.m_246326_((ItemLike)RESONANCE_CONDENSER_ITEM.get());
            event.m_246326_((ItemLike)REALITY_FORGE_ITEM.get());
            event.m_246326_((ItemLike)PARADOXICAL_ENERGY_CELL_ITEM.get());
            event.m_246326_((ItemLike)RIFT_STABILIZER_ITEM.get());
        }
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.m_246326_((ItemLike)FIELD_SCANNER.get());
            event.m_246326_((ItemLike)ANOMALY_RESONATOR.get());
            event.m_246326_((ItemLike)ECHOFORM_IMPRINTER.get());
            event.m_246326_((ItemLike)RESEARCH_TABLET.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Strange Matter anomalies are spreading across the server...");
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
    }

    public static void setPlayerBeamState(Player player, boolean isActive) {
        if (isActive) {
            playerBeamStates.put(player, true);
        } else {
            playerBeamStates.remove(player);
        }
    }

    public static boolean isPlayerUsingBeam(Player player) {
        return playerBeamStates.containsKey(player);
    }

    public static Set<Player> getPlayersUsingBeam() {
        return playerBeamStates.keySet();
    }

    static {
        ContainmentCapsuleItem.EMPTY_CAPSULE = CONTAINMENT_CAPSULE;
        ContainmentCapsuleItem.GRAVITY_CAPSULE = CONTAINMENT_CAPSULE_GRAVITY;
        ContainmentCapsuleItem.ENERGETIC_CAPSULE = CONTAINMENT_CAPSULE_ENERGETIC;
        ContainmentCapsuleItem.ECHOING_SHADOW_CAPSULE = CONTAINMENT_CAPSULE_ECHOING_SHADOW;
        ContainmentCapsuleItem.TEMPORAL_BLOOM_CAPSULE = CONTAINMENT_CAPSULE_TEMPORAL_BLOOM;
        ContainmentCapsuleItem.THOUGHTWELL_CAPSULE = CONTAINMENT_CAPSULE_THOUGHTWELL;
        ContainmentCapsuleItem.WARP_GATE_CAPSULE = CONTAINMENT_CAPSULE_WARP_GATE;
        REALITY_FORGE_BLOCK = BLOCKS.register("reality_forge", RealityForgeBlock::new);
        REALITY_FORGE_ITEM = ITEMS.register("reality_forge", () -> new BlockItem((Block)REALITY_FORGE_BLOCK.get(), new Item.Properties()));
        REALITY_FORGE_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("reality_forge", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new RealityForgeBlockEntity(pos, state), (Block[])new Block[]{(Block)REALITY_FORGE_BLOCK.get()}).m_58966_(null));
        RESONANCE_CONDENSER_BLOCK = BLOCKS.register("resonance_condenser", ResonanceCondenserBlock::new);
        RESONANCE_CONDENSER_ITEM = ITEMS.register("resonance_condenser", () -> new ResonanceCondenserItem((ResonanceCondenserBlock)((Object)((Object)RESONANCE_CONDENSER_BLOCK.get()))));
        RESONANCE_CONDENSER_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("resonance_condenser", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new ResonanceCondenserBlockEntity(pos, state), (Block[])new Block[]{(Block)RESONANCE_CONDENSER_BLOCK.get()}).m_58966_(null));
        RESONANT_BURNER_BLOCK = BLOCKS.register("resonant_burner", ResonantBurnerBlock::new);
        RESONANT_BURNER_ITEM = ITEMS.register("resonant_burner", () -> new BlockItem((Block)RESONANT_BURNER_BLOCK.get(), new Item.Properties()));
        RESONANT_BURNER_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("resonant_burner", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new ResonantBurnerBlockEntity(pos, state), (Block[])new Block[]{(Block)RESONANT_BURNER_BLOCK.get()}).m_58966_(null));
        PARADOXICAL_ENERGY_CELL_BLOCK = BLOCKS.register("paradoxical_energy_cell", ParadoxicalEnergyCellBlock::new);
        PARADOXICAL_ENERGY_CELL_ITEM = ITEMS.register("paradoxical_energy_cell", () -> new ParadoxicalEnergyCellItem((ParadoxicalEnergyCellBlock)((Object)((Object)PARADOXICAL_ENERGY_CELL_BLOCK.get()))));
        PARADOXICAL_ENERGY_CELL_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("paradoxical_energy_cell", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new ParadoxicalEnergyCellBlockEntity(pos, state), (Block[])new Block[]{(Block)PARADOXICAL_ENERGY_CELL_BLOCK.get()}).m_58966_(null));
        RIFT_STABILIZER_BLOCK = BLOCKS.register("rift_stabilizer", RiftStabilizerBlock::new);
        RIFT_STABILIZER_ITEM = ITEMS.register("rift_stabilizer", () -> new BlockItem((Block)RIFT_STABILIZER_BLOCK.get(), new Item.Properties()));
        RIFT_STABILIZER_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("rift_stabilizer", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new RiftStabilizerBlockEntity(pos, state), (Block[])new Block[]{(Block)RIFT_STABILIZER_BLOCK.get()}).m_58966_(null));
        STASIS_PROJECTOR_BLOCK = BLOCKS.register("stasis_projector", StasisProjectorBlock::new);
        STASIS_PROJECTOR_ITEM = ITEMS.register("stasis_projector", () -> new BlockItem((Block)STASIS_PROJECTOR_BLOCK.get(), new Item.Properties()));
        STASIS_PROJECTOR_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("stasis_projector", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new StasisProjectorBlockEntity(pos, state), (Block[])new Block[]{(Block)STASIS_PROJECTOR_BLOCK.get()}).m_58966_(null));
        RESONANT_CONDUIT_BLOCK = BLOCKS.register("resonant_conduit", ResonantConduitBlock::new);
        RESONANT_CONDUIT_ITEM = ITEMS.register("resonant_conduit", () -> new ResonantConduitItem((ResonantConduitBlock)((Object)((Object)RESONANT_CONDUIT_BLOCK.get()))));
        RESONANT_CONDUIT_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("resonant_conduit", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new ResonantConduitBlockEntity(pos, state), (Block[])new Block[]{(Block)RESONANT_CONDUIT_BLOCK.get()}).m_58966_(null));
        LEVITATION_PAD_BLOCK = BLOCKS.register("levitation_pad", LevitationPadBlock::new);
        LEVITATION_PAD_ITEM = ITEMS.register("levitation_pad", () -> new BlockItem((Block)LEVITATION_PAD_BLOCK.get(), new Item.Properties()));
        LEVITATION_PAD_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("levitation_pad", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new LevitationPadBlockEntity(pos, state), (Block[])new Block[]{(Block)LEVITATION_PAD_BLOCK.get()}).m_58966_(null));
        TIME_DILATION_BLOCK = BLOCKS.register("time_dilation_block", TimeDilationBlock::new);
        TIME_DILATION_BLOCK_ITEM = ITEMS.register("time_dilation_block", () -> new BlockItem((Block)TIME_DILATION_BLOCK.get(), new Item.Properties()));
        TIME_DILATION_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("time_dilation_block", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new TimeDilationBlockEntity(pos, state), (Block[])new Block[]{(Block)TIME_DILATION_BLOCK.get()}).m_58966_(null));
        ANOMALY_SPAWNER_MARKER_BLOCK = BLOCKS.register("anomaly_spawner_marker", AnomalySpawnerMarkerBlock::new);
        ANOMALY_SPAWNER_MARKER_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("anomaly_spawner_marker", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new AnomalySpawnerMarkerBlockEntity(pos, state), (Block[])new Block[]{(Block)ANOMALY_SPAWNER_MARKER_BLOCK.get()}).m_58966_(null));
        RESEARCH_MACHINE_POI = POI_TYPES.register("research_machine_poi", () -> {
            try {
                ImmutableList blockStates = ((Block)RESEARCH_MACHINE_BLOCK.get()).m_49965_().m_61056_();
                return new PoiType((Set)ImmutableSet.copyOf((Collection)blockStates), 1, 1);
            }
            catch (Exception e) {
                return new PoiType((Set)ImmutableSet.of(), 1, 1);
            }
        });
        ANOMALY_SCIENTIST = VILLAGER_PROFESSIONS.register("anomaly_scientist", () -> {
            ResourceKey poiKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)new ResourceLocation(MODID, "research_machine_poi"));
            return new VillagerProfession("anomaly_scientist", holder -> holder.m_203565_(poiKey), holder -> holder.m_203565_(poiKey), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12566_);
        });
        ENERGY_ABSORPTION_PARTICLE = PARTICLE_TYPES.register("energy_absorption", () -> new SimpleParticleType(true));
        RESONANCE_CONDENSER_MENU = MENU_TYPES.register("resonance_condenser", () -> IForgeMenuType.create((windowId, inv, data) -> new ResonanceCondenserMenu(windowId, inv, data)));
        RESONANT_BURNER_MENU = MENU_TYPES.register("resonant_burner", () -> IForgeMenuType.create((windowId, inv, data) -> new ResonantBurnerMenu(windowId, inv, data)));
        REALITY_FORGE_MENU = MENU_TYPES.register("reality_forge", () -> IForgeMenuType.create((windowId, inv, data) -> new RealityForgeMenu(windowId, inv, data)));
        REALITY_FORGE_RECIPE_TYPE = RECIPE_TYPES.register("reality_forge", () -> new RecipeType<RealityForgeRecipe>(){});
        REALITY_FORGE_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("reality_forge", () -> new RealityForgeRecipe.Serializer());
        HOVERBOARD = ITEMS.register("hoverboard", HoverboardItem::new);
        HOVERBOARD_ENTITY = ENTITY_TYPES.register("hoverboard", () -> EntityType.Builder.m_20704_(HoverboardEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20712_("hoverboard"));
        ENTITY_GRAVITY = ATTRIBUTES.register("entity_gravity", () -> new RangedAttribute("strangematter.entity_gravity", 0.08, -1.0, 1.0).m_22084_(true));
        GRAVITY_ANOMALY = ENTITY_TYPES.register("gravity_anomaly", () -> EntityType.Builder.m_20704_(GravityAnomalyEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20712_("gravity_anomaly"));
        ENERGETIC_RIFT = ENTITY_TYPES.register("energetic_rift", () -> EntityType.Builder.m_20704_((entityType, level) -> new EnergeticRiftEntity(entityType, level), (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20712_("energetic_rift"));
        ECHOING_SHADOW = ENTITY_TYPES.register("echoing_shadow", () -> EntityType.Builder.m_20704_(EchoingShadowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20712_("echoing_shadow"));
        WARP_GATE_ANOMALY_ENTITY = ENTITY_TYPES.register("warp_gate_anomaly", () -> EntityType.Builder.m_20704_(WarpGateAnomalyEntity::new, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 3.0f).m_20712_("warp_gate_anomaly"));
        TEMPORAL_BLOOM = ENTITY_TYPES.register("temporal_bloom", () -> EntityType.Builder.m_20704_((entityType, level) -> new TemporalBloomEntity(entityType, level), (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20712_("temporal_bloom"));
        THOUGHTWELL = ENTITY_TYPES.register("thoughtwell", () -> EntityType.Builder.m_20704_((entityType, level) -> new ThoughtwellEntity(entityType, level), (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20712_("thoughtwell"));
        WARP_PROJECTILE_ENTITY = ENTITY_TYPES.register("warp_projectile", () -> EntityType.Builder.m_20704_(WarpProjectileEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20712_("warp_projectile"));
        CHRONO_BLISTER_PROJECTILE_ENTITY = ENTITY_TYPES.register("chrono_blister_projectile", () -> EntityType.Builder.m_20704_(ChronoBlisterProjectileEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20712_("chrono_blister_projectile"));
        MINI_WARP_GATE_ENTITY = ENTITY_TYPES.register("mini_warp_gate", () -> EntityType.Builder.m_20704_(MiniWarpGateEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 2.0f).m_20712_("mini_warp_gate"));
        THROWABLE_CONTAINMENT_CAPSULE = ENTITY_TYPES.register("throwable_containment_capsule", () -> EntityType.Builder.m_20704_(ThrowableContainmentCapsuleEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20712_("throwable_containment_capsule"));
        ANOMALY_EFFECT_TRIGGER = new AnomalyEffectTrigger();
        SCAN_ANOMALY_TRIGGER = new ScanAnomalyTrigger();
        COMPLETE_RESEARCH_CATEGORY_TRIGGER = new CompleteResearchCategoryTrigger();
        GRAVITY_ANOMALY_FEATURE = FEATURES.register("gravity_anomaly", () -> new GravityAnomalyConfiguredFeature());
        ENERGETIC_RIFT_FEATURE = FEATURES.register("energetic_rift", () -> new EnergeticRiftConfiguredFeature());
        ECHOING_SHADOW_FEATURE = FEATURES.register("echoing_shadow", () -> new EchoingShadowConfiguredFeature());
        TEMPORAL_BLOOM_FEATURE = FEATURES.register("temporal_bloom", () -> new TemporalBloomConfiguredFeature());
        THOUGHTWELL_FEATURE = FEATURES.register("thoughtwell", () -> new ThoughtwellConfiguredFeature());
        WARP_GATE_ANOMALY_FEATURE = FEATURES.register("warp_gate_anomaly", () -> new WarpGateAnomalyConfiguredFeature());
        STRANGE_MATTER_TAB = CREATIVE_MODE_TABS.register("strange_matter_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257941_((Component)Component.m_237115_((String)"itemGroup.strangematter.strange_matter_tab")).m_257737_(() -> ((Item)FIELD_SCANNER.get()).m_7968_()).m_257501_((parameters, output) -> {
            output.m_246326_((ItemLike)FIELD_SCANNER.get());
            output.m_246326_((ItemLike)RESEARCH_TABLET.get());
            output.m_246326_((ItemLike)ANOMALY_RESONATOR.get());
            output.m_246326_((ItemLike)ECHOFORM_IMPRINTER.get());
            output.m_246326_((ItemLike)WARP_GUN.get());
            output.m_246326_((ItemLike)CHRONO_BLISTER.get());
            output.m_246326_((ItemLike)ECHO_VACUUM.get());
            output.m_246326_((ItemLike)GRAVITON_HAMMER.get());
            output.m_246326_((ItemLike)TINFOIL_HAT.get());
            output.m_246326_((ItemLike)HOVERBOARD.get());
            output.m_246326_((ItemLike)CONTAINMENT_CAPSULE.get());
            output.m_246326_((ItemLike)CONTAINMENT_CAPSULE_GRAVITY.get());
            output.m_246326_((ItemLike)CONTAINMENT_CAPSULE_ENERGETIC.get());
            output.m_246326_((ItemLike)CONTAINMENT_CAPSULE_ECHOING_SHADOW.get());
            output.m_246326_((ItemLike)CONTAINMENT_CAPSULE_TEMPORAL_BLOOM.get());
            output.m_246326_((ItemLike)CONTAINMENT_CAPSULE_THOUGHTWELL.get());
            output.m_246326_((ItemLike)CONTAINMENT_CAPSULE_WARP_GATE.get());
            output.m_246326_((ItemLike)ANOMALOUS_GRASS_ITEM.get());
            output.m_246326_((ItemLike)RESEARCH_MACHINE_ITEM.get());
            output.m_246326_((ItemLike)REALITY_FORGE_ITEM.get());
            output.m_246326_((ItemLike)RESONANT_BURNER_ITEM.get());
            output.m_246326_((ItemLike)RESONANCE_CONDENSER_ITEM.get());
            output.m_246326_((ItemLike)PARADOXICAL_ENERGY_CELL_ITEM.get());
            output.m_246326_((ItemLike)RIFT_STABILIZER_ITEM.get());
            output.m_246326_((ItemLike)STASIS_PROJECTOR_ITEM.get());
            output.m_246326_((ItemLike)RESONANT_CONDUIT_ITEM.get());
            output.m_246326_((ItemLike)LEVITATION_PAD_ITEM.get());
            output.m_246326_((ItemLike)TIME_DILATION_BLOCK_ITEM.get());
            output.m_246326_((ItemLike)RESONITE_ORE_ITEM.get());
            output.m_246326_((ItemLike)RESONITE_BLOCK_ITEM.get());
            output.m_246326_((ItemLike)RESONITE_TILE_ITEM.get());
            output.m_246326_((ItemLike)RESONITE_TILE_STAIRS_ITEM.get());
            output.m_246326_((ItemLike)RESONITE_TILE_SLAB_ITEM.get());
            output.m_246326_((ItemLike)FANCY_RESONITE_TILE_ITEM.get());
            output.m_246326_((ItemLike)RESONITE_PILLAR_ITEM.get());
            output.m_246326_((ItemLike)RESONITE_DOOR_ITEM.get());
            output.m_246326_((ItemLike)RESONITE_TRAPDOOR_ITEM.get());
            output.m_246326_((ItemLike)GRAVITIC_SHARD_ORE_ITEM.get());
            output.m_246326_((ItemLike)CHRONO_SHARD_ORE_ITEM.get());
            output.m_246326_((ItemLike)SPATIAL_SHARD_ORE_ITEM.get());
            output.m_246326_((ItemLike)SHADE_SHARD_ORE_ITEM.get());
            output.m_246326_((ItemLike)INSIGHT_SHARD_ORE_ITEM.get());
            output.m_246326_((ItemLike)ENERGETIC_SHARD_ORE_ITEM.get());
            output.m_246326_((ItemLike)SHADE_SHARD_LAMP_ITEM.get());
            output.m_246326_((ItemLike)GRAVITIC_SHARD_LAMP_ITEM.get());
            output.m_246326_((ItemLike)ENERGETIC_SHARD_LAMP_ITEM.get());
            output.m_246326_((ItemLike)INSIGHT_SHARD_LAMP_ITEM.get());
            output.m_246326_((ItemLike)CHRONO_SHARD_LAMP_ITEM.get());
            output.m_246326_((ItemLike)SPATIAL_SHARD_LAMP_ITEM.get());
            output.m_246326_((ItemLike)SHADE_SHARD_LAMP_ITEM.get());
            output.m_246326_((ItemLike)GRAVITIC_SHARD_LAMP_ITEM.get());
            output.m_246326_((ItemLike)ENERGETIC_SHARD_LAMP_ITEM.get());
            output.m_246326_((ItemLike)INSIGHT_SHARD_LAMP_ITEM.get());
            output.m_246326_((ItemLike)CHRONO_SHARD_LAMP_ITEM.get());
            output.m_246326_((ItemLike)SPATIAL_SHARD_LAMP_ITEM.get());
            output.m_246326_((ItemLike)SHADE_SHARD_LANTERN_ITEM.get());
            output.m_246326_((ItemLike)GRAVITIC_SHARD_LANTERN_ITEM.get());
            output.m_246326_((ItemLike)ENERGETIC_SHARD_LANTERN_ITEM.get());
            output.m_246326_((ItemLike)INSIGHT_SHARD_LANTERN_ITEM.get());
            output.m_246326_((ItemLike)CHRONO_SHARD_LANTERN_ITEM.get());
            output.m_246326_((ItemLike)SPATIAL_SHARD_LANTERN_ITEM.get());
            output.m_246326_((ItemLike)RAW_RESONITE.get());
            output.m_246326_((ItemLike)RESONITE_INGOT.get());
            output.m_246326_((ItemLike)RESONITE_NUGGET.get());
            output.m_246326_((ItemLike)RESONANT_COIL.get());
            output.m_246326_((ItemLike)STABILIZED_CORE.get());
            output.m_246326_((ItemLike)RESONANT_CIRCUIT.get());
            output.m_246326_((ItemLike)GRAVITIC_SHARD.get());
            output.m_246326_((ItemLike)CHRONO_SHARD.get());
            output.m_246326_((ItemLike)SPATIAL_SHARD.get());
            output.m_246326_((ItemLike)SHADE_SHARD.get());
            output.m_246326_((ItemLike)INSIGHT_SHARD.get());
            output.m_246326_((ItemLike)ENERGETIC_SHARD.get());
            output.m_246326_((ItemLike)SHADE_SHARD_CRYSTAL_ITEM.get());
            output.m_246326_((ItemLike)GRAVITIC_SHARD_CRYSTAL_ITEM.get());
            output.m_246326_((ItemLike)ENERGETIC_SHARD_CRYSTAL_ITEM.get());
            output.m_246326_((ItemLike)INSIGHT_SHARD_CRYSTAL_ITEM.get());
            output.m_246326_((ItemLike)CHRONO_SHARD_CRYSTAL_ITEM.get());
            output.m_246326_((ItemLike)SPATIAL_SHARD_CRYSTAL_ITEM.get());
            output.m_246326_((ItemLike)RESEARCH_NOTES.get());
        }).m_257652_());
        playerBeamStates = new ConcurrentHashMap<Player, Boolean>();
    }
}

