/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.gui.DisplayNoteScreen;
import com.chaosthedude.notes.gui.NotesButton;
import com.chaosthedude.notes.gui.NotesTextField;
import com.chaosthedude.notes.gui.NotesTitleField;
import com.chaosthedude.notes.note.Note;
import com.chaosthedude.notes.note.Scope;
import com.chaosthedude.notes.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EditNoteScreen
extends Screen {
    private final Screen parentScreen;
    private NotesButton saveButton;
    private NotesButton globalButton;
    private NotesButton insertBiomeButton;
    private NotesButton insertChunkButton;
    private NotesButton insertCoordsButton;
    private NotesButton cancelButton;
    private NotesTitleField noteTitleField;
    private NotesTextField noteTextField;
    private String saveDirName;
    private Note note;
    private Scope scope;
    private boolean pinned;
    private boolean setTextFieldFocused;

    public EditNoteScreen(Screen parentScreen, @Nullable Note note) {
        super((Component)Component.m_237113_((String)(note != null ? I18n.m_118938_((String)"notes.editNote", (Object[])new Object[0]) : I18n.m_118938_((String)"notes.newNote", (Object[])new Object[0]))));
        this.parentScreen = parentScreen;
        this.note = note != null ? note : new Note("New Note", "", Scope.getCurrentScope());
        this.scope = Scope.getCurrentScope();
        this.pinned = this.note.isPinned();
        this.setTextFieldFocused = false;
    }

    public void m_7856_() {
        this.setupTextFields();
        this.setupButtons();
    }

    public void m_86600_() {
        this.noteTitleField.m_94120_();
        this.noteTextField.tick();
        this.insertChunkButton.f_93623_ = this.insertCoordsButton.f_93623_ = this.noteTextField.m_93696_();
        this.insertBiomeButton.f_93623_ = this.insertCoordsButton.f_93623_;
    }

    public boolean m_6375_(double x, double y, int button) {
        boolean ret = super.m_6375_(x, y, button);
        if (this.setTextFieldFocused) {
            this.noteTextField.m_93692_(true);
            this.m_7522_((GuiEventListener)this.noteTextField);
            this.setTextFieldFocused = false;
        }
        return ret;
    }

    public boolean m_7933_(int keyCode, int par2, int par3) {
        boolean ret = super.m_7933_(keyCode, par2, par3);
        this.updateNote();
        return ret;
    }

    public boolean m_7920_(int keyCode, int par2, int par3) {
        boolean ret = super.m_7920_(keyCode, par2, par3);
        this.updateNote();
        return ret;
    }

    public void m_7522_(GuiEventListener listener) {
        super.m_7522_(listener);
        if (listener != this.noteTextField && this.noteTextField != null) {
            this.noteTextField.m_93692_(false);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280137_(this.f_96547_, this.f_96539_.getString(), this.f_96543_ / 2 + 60, 15, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, I18n.m_118938_((String)"notes.saveAs", (Object[])new Object[]{this.note.getUncollidingSaveName(this.note.getTitle())}), this.f_96543_ / 2 + 55, 65, 0x808080);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void setupButtons() {
        this.saveButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 40, 110, 20, (Component)Component.m_237115_((String)"notes.save"), onPress -> {
            this.updateNote();
            this.note.save();
            this.f_96541_.m_91152_((Screen)new DisplayNoteScreen(this.parentScreen, this.note));
            if (this.pinned) {
                Notes.pinnedNote = this.note;
            }
        }));
        this.globalButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 65, 110, 20, (Component)Component.m_237115_((String)"notes.global").m_7220_((Component)Component.m_237113_((String)": ").m_7220_((Component)(this.note.getScope() == Scope.GLOBAL ? Component.m_237115_((String)"notes.on") : Component.m_237115_((String)"notes.off")))), onPress -> {
            this.scope = this.scope == Scope.GLOBAL ? Scope.getCurrentScope() : Scope.GLOBAL;
            this.globalButton.m_93666_((Component)Component.m_237113_((String)(I18n.m_118938_((String)"notes.global", (Object[])new Object[0]) + (this.scope == Scope.GLOBAL ? ": " + I18n.m_118938_((String)"notes.on", (Object[])new Object[0]) : ": " + I18n.m_118938_((String)"notes.off", (Object[])new Object[0])))));
            this.updateNote();
        }));
        this.insertBiomeButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 100, 110, 20, (Component)Component.m_237115_((String)"notes.biome"), onPress -> {
            this.insertBiome();
            this.setTextFieldFocused = true;
        }));
        this.insertChunkButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 125, 110, 20, (Component)Component.m_237115_((String)"notes.chunk"), onPress -> {
            this.insertChunk();
            this.setTextFieldFocused = true;
        }));
        this.insertCoordsButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 150, 110, 20, (Component)Component.m_237115_((String)"notes.coordinates"), onPress -> {
            this.insertCoords();
            this.setTextFieldFocused = true;
        }));
        this.cancelButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, this.f_96544_ - 30, 110, 20, (Component)Component.m_237115_((String)"gui.cancel"), onPress -> this.f_96541_.m_91152_(this.parentScreen)));
        this.insertBiomeButton.f_93623_ = false;
        this.insertChunkButton.f_93623_ = false;
        this.insertCoordsButton.f_93623_ = false;
    }

    private void setupTextFields() {
        this.noteTitleField = (NotesTitleField)this.m_142416_((GuiEventListener)new NotesTitleField(this.f_96547_, 130, 40, this.f_96543_ - 140, 20, (Component)Component.m_237113_((String)"")));
        this.noteTitleField.m_94144_(this.note.getTitle());
        this.m_142416_((GuiEventListener)this.noteTitleField);
        this.noteTitleField.m_93692_(true);
        this.m_7522_((GuiEventListener)this.noteTitleField);
        this.noteTextField = (NotesTextField)this.m_142416_((GuiEventListener)new NotesTextField(this.f_96547_, 130, 85, this.f_96543_ - 140, this.f_96544_ - 95, 5));
        this.noteTextField.setText(this.note.getFilteredText());
        this.m_142416_((GuiEventListener)this.noteTextField);
    }

    private void updateNote() {
        this.note.setTitle(this.noteTitleField.m_94155_());
        this.note.setText(this.noteTextField.getText());
        this.note.setScope(this.scope);
    }

    private void insertBiome() {
        this.noteTextField.insert(StringUtils.fixBiomeName((Level)this.f_96541_.f_91073_, (Biome)this.f_96541_.f_91073_.m_204166_(this.f_96541_.f_91074_.m_20183_()).m_203334_()));
    }

    private void insertChunk() {
        this.noteTextField.insert(this.f_96541_.f_91074_.m_146902_().f_45578_ + ", " + this.f_96541_.f_91074_.m_146902_().f_45579_);
    }

    private void insertCoords() {
        this.noteTextField.insert(this.f_96541_.f_91074_.m_146903_() + ", " + this.f_96541_.f_91074_.m_146904_() + ", " + this.f_96541_.f_91074_.m_146907_());
    }
}

