/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootAgnos;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class ServerResourceData {
    private static final Multimap<TableChecker, LootTable> DIRECT_DROPS = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
    public static final List<ResourceLocation> SHEEP_TABLES;
    public static final List<TableChecker> TABLE_EXCLUSIONS;
    private static final Gson GSON;
    private static final int DIRECT_DROPS_PATH_LENGTH;
    private static final int FILE_SUFFIX_LENGTH;

    public static void loadDirectTables(ResourceManager resourceManager) {
        DIRECT_DROPS.clear();
        resourceManager.m_214159_("direct_drops", path -> path.m_135815_().endsWith(".json")).forEach(ServerResourceData::loadDirectTable);
        resourceManager.m_214159_("emi_loot_data", path -> path.m_135815_().endsWith(".json")).forEach(ServerResourceData::loadTableExclusion);
    }

    private static void loadDirectTable(ResourceLocation id, Resource resource) {
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.info("Reading direct drop table from file: {}", (Object)id.toString());
        }
        String path = id.m_135815_();
        ResourceLocation id2 = new ResourceLocation(id.m_135827_(), path.substring(DIRECT_DROPS_PATH_LENGTH, path.length() - FILE_SUFFIX_LENGTH));
        String path2 = id2.m_135815_();
        if (!(path2.startsWith("blocks/") || path2.startsWith("entities/") || path2.startsWith("chests/"))) {
            EMILoot.LOGGER.error("File path for [{}] not correct; needs a 'blocks', 'entities' or 'chests' subfolder. Skipping.", (Object)id);
            EMILoot.LOGGER.error("Example: [./data/mod_id/direct_drops/blocks/cobblestone.json] is a valid block direct drop table path for a block added by [mod_id].");
            return;
        }
        try {
            BufferedReader reader = resource.m_215508_();
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            TableChecker checker = ServerResourceData.loadTableCheckerFromTable(id2, json);
            LootTable lootTable = EMILootAgnos.loadLootTable(GSON, id2, json);
            if (lootTable != null) {
                DIRECT_DROPS.put((Object)checker, (Object)lootTable);
            } else {
                EMILoot.LOGGER.error("Loot table in file [{}] is empty!", (Object)id);
            }
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to open or read direct drops loot table file: {}", (Object)id);
        }
    }

    private static TableChecker loadTableCheckerFromTable(ResourceLocation id, JsonObject jsonObject) {
        if (!jsonObject.has("match_tables")) {
            return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
        }
        JsonElement matchesElement = jsonObject.get("match_tables");
        if (!matchesElement.isJsonObject()) {
            EMILoot.LOGGER.error("Direct drops table {} has malformed table matcher, needs to be an object", (Object)id);
            return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
        }
        JsonObject matchesObject = matchesElement.getAsJsonObject();
        return ServerResourceData.loadTableChecker(id, jsonObject, "Direct drops table");
    }

    private static TableChecker loadTableChecker(ResourceLocation id, JsonObject matchesObject, String messagePrefix) {
        Optional<Pattern> regexCheck = Optional.empty();
        if (matchesObject.has("regex")) {
            JsonElement regexElement = matchesObject.get("regex");
            if (!regexElement.isJsonPrimitive()) {
                EMILoot.LOGGER.error("{} {} has malformed table matcher. 'regex' key needs a primitive string value", (Object)messagePrefix, (Object)id);
                return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
            }
            JsonPrimitive regexPrimitive = regexElement.getAsJsonPrimitive();
            if (!regexPrimitive.isString()) {
                EMILoot.LOGGER.error("{} {} has malformed table matcher. 'regex' key needs a string value", (Object)messagePrefix, (Object)id);
                return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
            }
            regexCheck = Optional.of(Pattern.compile(regexPrimitive.getAsString()));
        }
        Optional<List<ResourceLocation>> idsCheck = Optional.empty();
        if (matchesObject.has("ids")) {
            JsonElement idsElement = matchesObject.get("ids");
            if (!idsElement.isJsonArray()) {
                EMILoot.LOGGER.error("{} {} has malformed table matcher. 'ids' key needs to be an array of strings", (Object)messagePrefix, (Object)id);
                return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
            }
            JsonArray idsArray = idsElement.getAsJsonArray();
            ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
            for (int i = 0; i < idsArray.size(); ++i) {
                JsonElement idElement = idsArray.get(i);
                if (!idElement.isJsonPrimitive()) {
                    EMILoot.LOGGER.error("{} {} has malformed table matcher. 'id' key has non-primitive-string value at index {}", new Object[]{messagePrefix, id, i});
                    return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
                }
                JsonPrimitive idPrimitive = idElement.getAsJsonPrimitive();
                if (!idPrimitive.isString()) {
                    EMILoot.LOGGER.error("{} {} has malformed table matcher. 'id' key has non-string value at index {}", new Object[]{messagePrefix, id, i});
                    return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
                }
                ResourceLocation idsId = ResourceLocation.m_135820_((String)idPrimitive.getAsString());
                if (idsId == null) {
                    EMILoot.LOGGER.error("{} {} has malformed table matcher. 'id' key has unparsable identifier {} at index {}", new Object[]{messagePrefix, id, idPrimitive.getAsString(), i});
                    return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
                }
                ids.add(idsId);
            }
            idsCheck = Optional.of(ids);
        }
        Optional<LootContextParamSet> typeCheck = Optional.empty();
        if (matchesObject.has("type")) {
            JsonElement typeElement = matchesObject.get("type");
            if (!typeElement.isJsonPrimitive()) {
                EMILoot.LOGGER.error("{} {} has malformed table matcher. 'type' key needs a primitive string value", (Object)messagePrefix, (Object)id);
                return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
            }
            JsonPrimitive typePrimitive = typeElement.getAsJsonPrimitive();
            if (!typePrimitive.isString()) {
                EMILoot.LOGGER.error("{} {} has malformed table matcher. 'type' key needs a string value", (Object)messagePrefix, (Object)id);
                return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
            }
            ResourceLocation typeId = ResourceLocation.m_135820_((String)typePrimitive.getAsString());
            if (typeId == null) {
                EMILoot.LOGGER.error("{} {} has malformed table matcher. 'type' key has unparsable identifier {}", new Object[]{messagePrefix, id, typePrimitive.getAsString()});
                return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
            }
            LootContextParamSet type = LootContextParamSets.m_81431_((ResourceLocation)typeId);
            if (type == null) {
                EMILoot.LOGGER.error("{} {} has malformed table matcher. 'type' key has unregistered context type {}", new Object[]{messagePrefix, id, typeId});
                return new TableChecker(id, Optional.empty(), Optional.empty(), Optional.empty());
            }
            typeCheck = Optional.of(type);
        }
        return new TableChecker(id, regexCheck, idsCheck, typeCheck);
    }

    private static void loadTableExclusion(ResourceLocation id, Resource resource) {
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.info("Reading exclusion table from file: {}", (Object)id.toString());
        }
        try {
            BufferedReader reader = resource.m_215508_();
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonElement list = json.get("exclusions");
            if (list != null && list.isJsonArray()) {
                for (JsonElement element : list.getAsJsonArray()) {
                    if (element.isJsonPrimitive()) {
                        ResourceLocation identifier = new ResourceLocation(element.getAsString());
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Adding exclusion: {}", (Object)identifier);
                        }
                        TABLE_EXCLUSIONS.add(new TableChecker(identifier, Optional.empty(), Optional.empty(), Optional.empty()));
                        continue;
                    }
                    if (element.isJsonObject()) {
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Adding complex exclusion: {}", (Object)element);
                        }
                        TABLE_EXCLUSIONS.add(ServerResourceData.loadTableChecker(id, element.getAsJsonObject(), "Table exclusion"));
                        continue;
                    }
                    EMILoot.LOGGER.error("Exclusion element not properly formatted: {}", (Object)element);
                }
            } else {
                EMILoot.LOGGER.error("Exclusions in file: {} not readable.", (Object)id);
            }
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to open or read table exclusions file: {}", (Object)id);
        }
    }

    public static boolean skipTable(LootTable table, ResourceLocation id) {
        for (TableChecker checker : TABLE_EXCLUSIONS) {
            if (!checker.check(table, id)) continue;
            return true;
        }
        return false;
    }

    public static List<LootTable> getDirectTables(LootTable table, ResourceLocation id, boolean getDirect) {
        if (!getDirect) {
            return List.of();
        }
        ArrayList<LootTable> tables = new ArrayList<LootTable>();
        for (TableChecker checker : DIRECT_DROPS.keySet()) {
            if (!checker.check(table, id)) continue;
            Collection checkedTables = DIRECT_DROPS.get((Object)checker);
            tables.addAll(checkedTables);
        }
        return tables;
    }

    public static Multimap<ResourceLocation, LootTable> getMissedDirectDrops(List<ResourceLocation> parsedList) {
        Multimap missedDrops = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
        for (Map.Entry entry : DIRECT_DROPS.entries()) {
            if (((TableChecker)entry.getKey()).isComplex() || parsedList.contains(((TableChecker)entry.getKey()).idCheck())) continue;
            missedDrops.put((Object)((TableChecker)entry.getKey()).idCheck(), (Object)((LootTable)entry.getValue()));
        }
        return missedDrops;
    }

    static {
        TABLE_EXCLUSIONS = new LinkedList<TableChecker>();
        GSON = Deserializers.m_78800_().create();
        DIRECT_DROPS_PATH_LENGTH = "direct_drops/".length();
        FILE_SUFFIX_LENGTH = ".json".length();
        ResourceLocation[] ids = new ResourceLocation[]{BuiltInLootTables.f_78702_, BuiltInLootTables.f_78703_, BuiltInLootTables.f_78704_, BuiltInLootTables.f_78705_, BuiltInLootTables.f_78706_, BuiltInLootTables.f_78707_, BuiltInLootTables.f_78708_, BuiltInLootTables.f_78709_, BuiltInLootTables.f_78710_, BuiltInLootTables.f_78711_, BuiltInLootTables.f_78714_, BuiltInLootTables.f_78715_, BuiltInLootTables.f_78716_, BuiltInLootTables.f_78717_, BuiltInLootTables.f_78718_, BuiltInLootTables.f_78719_};
        SHEEP_TABLES = Arrays.stream(ids).toList();
    }

    private record TableChecker(ResourceLocation idCheck, Optional<Pattern> regexCheck, Optional<List<ResourceLocation>> idsCheck, Optional<LootContextParamSet> typeCheck) {
        boolean check(LootTable table, ResourceLocation id) {
            if (this.idCheck.equals((Object)id)) {
                return true;
            }
            if (this.regexCheck.map(regex -> regex.matcher(id.toString()).find()).orElse(false).booleanValue()) {
                return true;
            }
            if (this.idsCheck.map(ids -> ids.contains(id)).orElse(false).booleanValue()) {
                return true;
            }
            return this.typeCheck.map(type -> type.equals(table.m_79122_())).orElse(false);
        }

        boolean isComplex() {
            return this.regexCheck.isPresent() || this.idsCheck.isPresent() || this.typeCheck.isPresent();
        }
    }
}

