/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.blocks;

import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import earth.terrarium.chipped.common.menus.WorkbenchMenu;
import earth.terrarium.chipped.common.recipes.ChippedRecipe;
import earth.terrarium.chipped.common.utils.ModUtils;
import java.util.Locale;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class WorkbenchBlock
extends HorizontalDirectionalBlock {
    public static final EnumProperty<WorkbenchModelType> MODEL_TYPE = EnumProperty.m_61587_((String)"model", WorkbenchModelType.class);
    private final RegistryEntry<RecipeType<ChippedRecipe>> recipeType;

    public WorkbenchBlock(RegistryEntry<RecipeType<ChippedRecipe>> recipeType, BlockBehaviour.Properties properties) {
        super(properties);
        this.recipeType = recipeType;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(MODEL_TYPE, (Comparable)((Object)WorkbenchModelType.MAIN)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, MODEL_TYPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos containerPos = state.m_61143_(MODEL_TYPE) == WorkbenchModelType.MAIN ? pos : pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122428_());
        ModUtils.openMenu((ServerPlayer)player, containerPos, new WorkbenchMenuProvider());
        return InteractionResult.CONSUME;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos otherpos;
        BlockState otherstate;
        if (level.f_46443_) {
            super.m_5707_(level, pos, state, player);
            return;
        }
        WorkbenchModelType workbenchModel = (WorkbenchModelType)((Object)state.m_61143_(MODEL_TYPE));
        if (workbenchModel == WorkbenchModelType.MAIN && (otherstate = level.m_8055_(otherpos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122427_()))).m_60734_() == this) {
            level.m_7731_(otherpos, Blocks.f_50016_.m_49966_(), 3);
            level.m_5898_(player, 2001, otherpos, Block.m_49956_((BlockState)otherstate));
        }
        if (workbenchModel == WorkbenchModelType.SIDE && (otherstate = level.m_8055_(otherpos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122428_()))).m_60734_() == this) {
            level.m_7731_(otherpos, Blocks.f_50016_.m_49966_(), 3);
            level.m_5898_(player, 2001, otherpos, Block.m_49956_((BlockState)otherstate));
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.f_46443_) {
            BlockPos blockpos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122427_());
            level.m_7731_(blockpos, (BlockState)state.m_61124_(MODEL_TYPE, (Comparable)((Object)WorkbenchModelType.SIDE)), 3);
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return state.m_61143_(MODEL_TYPE) == WorkbenchModelType.MAIN ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    @Deprecated
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122427_())).m_247087_();
    }

    public RecipeType<ChippedRecipe> recipeType() {
        return (RecipeType)this.recipeType.get();
    }

    public static enum WorkbenchModelType implements StringRepresentable
    {
        MAIN,
        SIDE;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.m_7912_();
        }
    }

    public class WorkbenchMenuProvider
    implements MenuProvider {
        public Component m_5446_() {
            return WorkbenchBlock.this.m_49954_();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return new WorkbenchMenu(id, inventory, WorkbenchBlock.this.recipeType());
        }
    }
}

