/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermalconstruct.modifiers;

import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.DurabilityShieldModifier;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.ToolEnergyCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;

public class FluxShieldModifier
extends DurabilityShieldModifier
implements ToolStatsModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.TOOL_STATS);
        hookBuilder.addModule((HookProvider)ToolEnergyCapability.ENERGY_HANDLER);
    }

    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, @Nullable RegistryAccess access) {
        return this.getDisplayName(entry.getLevel());
    }

    public void addToolStats(IToolContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        int value = 50000;
        if (modifier.intEffectiveLevel() > 1) {
            value += 10000 * modifier.intEffectiveLevel();
        }
        ToolEnergyCapability.MAX_STAT.add(builder, (double)value);
    }

    public int getShieldCapacity(IToolStackView tool, ModifierEntry modifier) {
        return tool.getStats().getInt((IToolStat)ToolEnergyCapability.MAX_STAT);
    }

    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @javax.annotation.Nullable LivingEntity holder) {
        int realAmount = 200;
        int shield = this.getShield(tool);
        if (shield > 0) {
            if (shield >= realAmount) {
                this.setShield(tool, modifier, shield - realAmount);
                return 0;
            }
            amount -= shield;
            this.setShield(tool, modifier, 0);
        }
        return amount;
    }

    @Nullable
    public Boolean showDurabilityBar(IToolStackView tool, ModifierEntry modifier) {
        return this.getShield(tool) > 0 && this.getShield(tool) < this.getShieldCapacity(tool, modifier) ? Boolean.valueOf(true) : null;
    }

    public int getShield(IToolStackView tool) {
        return ToolEnergyCapability.getEnergy((IToolStackView)tool);
    }

    public void setShield(IToolStackView tool, ModifierEntry modifier, int amount) {
        ToolEnergyCapability.setEnergy((IToolStackView)tool, (int)amount);
    }

    public int getDurabilityRGB(IToolStackView tool, ModifierEntry modifier) {
        return 9818086;
    }
}

