/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermalconstruct.init;

import cofh.thermal.core.ThermalCore;
import java.util.Locale;
import java.util.function.Supplier;
import mrthomas20121.thermalconstruct.init.ThermalConstructFluids;
import mrthomas20121.thermalconstruct.init.ThermalConstructTags;
import mrthomas20121.thermalconstruct.item.MetalItem;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.registration.deferred.ItemDeferredRegister;
import slimeknights.mantle.registration.deferred.SynchronizedDeferredRegister;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialIngredient;
import slimeknights.tconstruct.library.tools.part.PartCastItem;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;
import slimeknights.tconstruct.tools.TinkerToolParts;

public class ThermalConstructItems {
    public static ItemDeferredRegister ITEMS = new ItemDeferredRegister("thermalconstruct");
    public static final SynchronizedDeferredRegister<CreativeModeTab> CREATIVE_TABS = SynchronizedDeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"thermalconstruct");
    public static EnumObject<ThermalCast, Item> CASTS = ITEMS.registerEnum("bronze_cast", (Enum[])ThermalCast.VALUES, cast -> cast.getItemInstance().get());
    public static ItemObject<Item> BASALZ_BONE = ITEMS.register("basalz_bone", new Item.Properties());
    public static ItemObject<Item> BLITZ_BONE = ITEMS.register("blitz_bone", new Item.Properties());
    public static ItemObject<Item> BLIZZ_BONE = ITEMS.register("blizz_bone", new Item.Properties());
    public static final MetalItem COBALT = new MetalItem("cobalt", ITEMS);
    public static final MetalItem SLIMESTEEL = new MetalItem("slimesteel", ITEMS);
    public static final MetalItem AMETHYST_BRONZE = new MetalItem("amethyst_bronze", ITEMS);
    public static final MetalItem CINDERSLIME = new MetalItem("cinderslime", ITEMS);
    public static final MetalItem QUEENS_SLIME = new MetalItem("queens_slime", ITEMS);
    public static final MetalItem MANYULLYN = new MetalItem("manyullyn", ITEMS);
    public static final MetalItem HEPATIZON = new MetalItem("hepatizon", ITEMS);
    public static final RegistryObject<CreativeModeTab> tabThermalConstruct = CREATIVE_TABS.register("thermal_construct_tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.thermal_construct")).m_257737_(() -> new ItemStack((ItemLike)CASTS.get((Enum)ThermalCast.GEM))).m_257501_(ThermalConstructItems::addTabItems).withTabsBefore(new ResourceLocation[]{TinkerFluids.tabFluids.getId()}).m_257652_());

    private static void addTabItems(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        output.m_246326_((ItemLike)ThermalConstructFluids.basalzBlood.m_5456_());
        output.m_246326_((ItemLike)ThermalConstructFluids.blitzBlood.m_5456_());
        output.m_246326_((ItemLike)ThermalConstructFluids.blizzBlood.m_5456_());
        output.m_246326_((ItemLike)ThermalConstructFluids.moltenSoulInfused.m_5456_());
        output.m_246326_((ItemLike)ThermalConstructFluids.moltenShellite.m_5456_());
        output.m_246326_((ItemLike)ThermalConstructFluids.moltenTwinite.m_5456_());
        output.m_246326_((ItemLike)ThermalConstructFluids.moltenDragonsteel.m_5456_());
        output.m_246326_((ItemLike)ThermalConstructFluids.moltenAbyssal.m_5456_());
        output.m_246326_(BASALZ_BONE);
        output.m_246326_(BLITZ_BONE);
        output.m_246326_(BLIZZ_BONE);
        ThermalConstructItems.addMetalItem(AMETHYST_BRONZE, output);
        ThermalConstructItems.addMetalItem(CINDERSLIME, output);
        ThermalConstructItems.addMetalItem(COBALT, output);
        ThermalConstructItems.addMetalItem(HEPATIZON, output);
        ThermalConstructItems.addMetalItem(MANYULLYN, output);
        ThermalConstructItems.addMetalItem(QUEENS_SLIME, output);
        ThermalConstructItems.addMetalItem(SLIMESTEEL, output);
        output.m_246326_((ItemLike)ThermalCore.ITEMS.get("chiller_ingot_cast"));
        output.m_246326_((ItemLike)ThermalCore.ITEMS.get("chiller_ball_cast"));
        output.m_246326_((ItemLike)ThermalCore.ITEMS.get("chiller_rod_cast"));
        for (ThermalCast cast : ThermalCast.VALUES) {
            output.m_246326_((ItemLike)CASTS.get((Enum)cast));
        }
    }

    private static void addMetalItem(MetalItem metalItem, CreativeModeTab.Output output) {
        output.m_246326_(metalItem.getDust());
        output.m_246326_(metalItem.getGear());
        output.m_246326_(metalItem.getCoin());
        output.m_246326_(metalItem.getPlate());
    }

    public static enum ThermalCast {
        GEM((TagKey<Item>)Tags.Items.GEMS, "Gem"),
        GEAR(ThermalConstructTags.GEARS, "Gear"),
        COIN(ThermalConstructTags.COINS, "Coin"),
        WIRE(ThermalConstructTags.WIRES, "Wire"),
        PICK_HEAD((Supplier<ToolPartItem>)TinkerToolParts.pickHead, "Pick Head"),
        SMALL_AXE_HEAD((Supplier<ToolPartItem>)TinkerToolParts.smallAxeHead, "Small Axe Head"),
        SMALL_BLADE((Supplier<ToolPartItem>)TinkerToolParts.smallBlade, "Small Blade"),
        ADZE_HEAD((Supplier<ToolPartItem>)TinkerToolParts.adzeHead, "Adze Head"),
        HAMMER_HEAD((Supplier<ToolPartItem>)TinkerToolParts.hammerHead, "Hammer Head"),
        BROAD_BLADE((Supplier<ToolPartItem>)TinkerToolParts.broadBlade, "Broad Blade"),
        BROAD_AXE_HEAD((Supplier<ToolPartItem>)TinkerToolParts.broadAxeHead, "Broad Axe Head"),
        LARGE_PLATE((Supplier<ToolPartItem>)TinkerToolParts.largePlate, "Large Plate"),
        TOOL_BINDING((Supplier<ToolPartItem>)TinkerToolParts.toolBinding, "Tool Binding"),
        TOUGH_BINDING((Supplier<ToolPartItem>)TinkerToolParts.toughBinding, "Tough Binding"),
        TOOL_HANDLE((Supplier<ToolPartItem>)TinkerToolParts.toolHandle, "Tool Handle"),
        TOUGH_HANDLE((Supplier<ToolPartItem>)TinkerToolParts.toughHandle, "Tough Handle"),
        BOW_LIMB((Supplier<ToolPartItem>)TinkerToolParts.bowLimb, "Bow Limb"),
        BOW_GRIP((Supplier<ToolPartItem>)TinkerToolParts.bowGrip, "Bow Grip"),
        HELMET_PLATING(() -> (ToolPartItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.HELMET), "Helmet Plating"),
        CHESTPLATE_PLATING(() -> (ToolPartItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.CHESTPLATE), "Chestplate Plating"),
        LEGGINGS_PLATING(() -> (ToolPartItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.LEGGINGS), "Leggings Plating"),
        BOOTS_PLATING(() -> (ToolPartItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.BOOTS), "Boots Plating"),
        MAILLE((Supplier<ToolPartItem>)TinkerToolParts.maille, "Maille");

        public static final ThermalCast[] VALUES;
        private final String cast_name = this.name().toLowerCase(Locale.ROOT);
        private final String translated_name;
        private final TagKey<Item> tag;
        private final Supplier<Item> itemSupplier;
        private final Supplier<Ingredient> ingredient;

        private ThermalCast(TagKey<Item> tag) {
            this(() -> new Item(new Item.Properties()), () -> Ingredient.m_204132_((TagKey)tag), null);
        }

        private ThermalCast(TagKey<Item> tag, String translated_name) {
            this(() -> new Item(new Item.Properties()), () -> Ingredient.m_204132_((TagKey)tag), translated_name);
        }

        private ThermalCast(Supplier<ToolPartItem> item, String translated_name) {
            this(() -> new PartCastItem(new Item.Properties(), item), () -> MaterialIngredient.of((ItemLike)((ItemLike)item.get())), translated_name);
        }

        private ThermalCast(@Nullable Supplier<Item> createItem, Supplier<Ingredient> ingredient, String translated_name) {
            this.itemSupplier = createItem;
            this.tag = ItemTags.create((ResourceLocation)TConstruct.getResource((String)("casts/multi_use/" + this.cast_name)));
            this.translated_name = translated_name == null ? this.cast_name : translated_name;
            this.ingredient = ingredient;
        }

        public String getName() {
            return this.cast_name;
        }

        public String getTranslatedName() {
            return this.translated_name;
        }

        public Supplier<Item> getItemInstance() {
            return this.itemSupplier;
        }

        public TagKey<Item> getTag() {
            return this.tag;
        }

        public Supplier<Ingredient> getIngredient() {
            return this.ingredient;
        }

        static {
            VALUES = ThermalCast.values();
        }
    }
}

