/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermalconstruct.datagen;

import cofh.lib.init.data.RecipeProviderCoFH;
import cofh.lib.util.crafting.IngredientWithCount;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.init.registries.TCoreEntities;
import java.util.function.Consumer;
import mrthomas20121.thermal_extra.data.thermal_recipe.MachineRecipeBuilder;
import mrthomas20121.thermal_extra.init.ThermalExtraItems;
import mrthomas20121.thermalconstruct.ThermalConstruct;
import mrthomas20121.thermalconstruct.ThermalConstructMaterialIds;
import mrthomas20121.thermalconstruct.ThermalConstructModifierIds;
import mrthomas20121.thermalconstruct.init.ThermalConstructFluids;
import mrthomas20121.thermalconstruct.init.ThermalConstructItems;
import mrthomas20121.thermalconstruct.item.MetalItem;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import slimeknights.mantle.recipe.data.ICommonRecipeHelper;
import slimeknights.mantle.recipe.data.ItemNameIngredient;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.registration.object.MetalItemObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.ISmelteryRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.IToolRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.SmelteryRecipeBuilder;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipeBuilder;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.data.material.MaterialIds;

public class ThermalConstructRecipeProvider
extends RecipeProviderCoFH
implements IMaterialRecipeHelper,
IToolRecipeHelper,
ISmelteryRecipeHelper,
ICommonRecipeHelper {
    public ThermalConstructRecipeProvider(PackOutput output) {
        super(output, "thermalconstruct");
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        String materialFolder = "materials/";
        String castFolder = "casting/";
        String smelteryFolder = "smeltery/";
        String upgradeFolder = "tools/modifiers/upgrade/";
        String abilityFolder = "tools/modifiers/ability/";
        String slotlessFolder = "tools/modifiers/slotless/";
        String upgradeSalvage = "tools/modifiers/salvage/upgrade/";
        String abilitySalvage = "tools/modifiers/salvage/ability/";
        String defenseFolder = "tools/modifiers/defense/";
        String defenseSalvage = "tools/modifiers/salvage/defense/";
        String compatFolder = "tools/modifiers/compat/";
        String compatSalvage = "tools/modifiers/salvage/compat/";
        String worktableFolder = "tools/modifiers/worktable/";
        this.extraCompat(smelteryFolder, materialFolder, this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("thermal_extra")}));
        this.thermalCast(consumer, smelteryFolder, new ResourceLocation("thermal:chiller_rod_cast"), 360);
        this.thermalCast(consumer, smelteryFolder, new ResourceLocation("thermal:chiller_ball_cast"), 360);
        this.thermalCast(consumer, smelteryFolder, new ResourceLocation("thermal:chiller_ingot_cast"), 360);
        for (ThermalConstructItems.ThermalCast thermalCast : ThermalConstructItems.ThermalCast.VALUES) {
            Item cast = (Item)ThermalConstructItems.CASTS.get((Enum)thermalCast);
            this.castRecipe(consumer, (ItemLike)cast, thermalCast.getIngredient().get(), castFolder, thermalCast.getName());
        }
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ThermalConstructMaterialIds.ENDERIUM, materialFolder, "enderium", false);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ThermalConstructMaterialIds.LUMIUM, materialFolder, "lumium", false);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ThermalConstructMaterialIds.SIGNALUM, materialFolder, "signalum", false);
        this.materialRecipe(consumer, (MaterialVariantId)ThermalConstructMaterialIds.BASALZ, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ThermalConstructItems.BASALZ_BONE}), 1, 1, materialFolder + "basalz");
        this.materialRecipe(consumer, (MaterialVariantId)ThermalConstructMaterialIds.BLITZ, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ThermalConstructItems.BLITZ_BONE}), 1, 1, materialFolder + "blitz");
        this.materialRecipe(consumer, (MaterialVariantId)ThermalConstructMaterialIds.BLIZZ, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ThermalConstructItems.BLIZZ_BONE}), 1, 1, materialFolder + "blizz");
        this.materialComposite(consumer, (MaterialVariantId)MaterialIds.bone, (MaterialVariantId)ThermalConstructMaterialIds.BASALZ, (FluidObject)ThermalConstructFluids.basalzBlood, 100, castFolder + "composite/");
        this.materialComposite(consumer, (MaterialVariantId)MaterialIds.bone, (MaterialVariantId)ThermalConstructMaterialIds.BLITZ, (FluidObject)ThermalConstructFluids.blitzBlood, 100, castFolder + "composite/");
        this.materialComposite(consumer, (MaterialVariantId)MaterialIds.bone, (MaterialVariantId)ThermalConstructMaterialIds.BLIZZ, (FluidObject)ThermalConstructFluids.blizzBlood, 100, castFolder + "composite/");
        ItemCastingRecipeBuilder.tableRecipe(ThermalConstructItems.BASALZ_BONE).setFluidAndTime(ThermalConstructFluids.basalzBlood, 100).setCast(Tags.Items.BONES, true).save(consumer, this.location(castFolder + "composite/basalz_bone"));
        ItemCastingRecipeBuilder.tableRecipe(ThermalConstructItems.BLITZ_BONE).setFluidAndTime(ThermalConstructFluids.blitzBlood, 100).setCast(Tags.Items.BONES, true).save(consumer, this.location(castFolder + "composite/blitz_bone"));
        ItemCastingRecipeBuilder.tableRecipe(ThermalConstructItems.BLIZZ_BONE).setFluidAndTime(ThermalConstructFluids.blizzBlood, 100).setCast(Tags.Items.BONES, true).save(consumer, this.location(castFolder + "composite/blizz_bone"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ThermalCore.ITEMS.get("basalz_rod")}), ThermalConstructFluids.basalzBlood, (int)100, (float)10.0f).save(consumer, this.location("smeltery/basalz_rod"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ThermalCore.ITEMS.get("blitz_rod")}), ThermalConstructFluids.blitzBlood, (int)100, (float)10.0f).save(consumer, this.location("smeltery/blitz_rod"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ThermalCore.ITEMS.get("blizz_rod")}), ThermalConstructFluids.blizzBlood, (int)100, (float)10.0f).save(consumer, this.location("smeltery/blizz_rod"));
        this.castingWithCast(consumer, (FluidObject)ThermalConstructFluids.basalzBlood, 100, TinkerSmeltery.rodCast, (ItemLike)ThermalCore.ITEMS.get("basalz_rod"), castFolder + "basaltz");
        this.castingWithCast(consumer, (FluidObject)ThermalConstructFluids.blitzBlood, 100, TinkerSmeltery.rodCast, (ItemLike)ThermalCore.ITEMS.get("blitz_rod"), castFolder + "blitz");
        this.castingWithCast(consumer, (FluidObject)ThermalConstructFluids.blizzBlood, 100, TinkerSmeltery.rodCast, (ItemLike)ThermalCore.ITEMS.get("blizz_rod"), castFolder + "blizz");
        EntityMeltingRecipeBuilder.melting((EntityIngredient)EntityIngredient.of((EntityType[])new EntityType[]{(EntityType)TCoreEntities.BASALZ.get()}), (FluidOutput)ThermalConstructFluids.basalzBlood.result(20), (int)2).save(consumer, this.location("smeltery/entity_melting/basalz"));
        EntityMeltingRecipeBuilder.melting((EntityIngredient)EntityIngredient.of((EntityType[])new EntityType[]{(EntityType)TCoreEntities.BLITZ.get()}), (FluidOutput)ThermalConstructFluids.blitzBlood.result(20), (int)2).save(consumer, this.location("smeltery/entity_melting/blitz"));
        EntityMeltingRecipeBuilder.melting((EntityIngredient)EntityIngredient.of((EntityType[])new EntityType[]{(EntityType)TCoreEntities.BLIZZ.get()}), (FluidOutput)ThermalConstructFluids.blizzBlood.result(20), (int)2).save(consumer, this.location("smeltery/entity_melting/blizz"));
        this.materialMeltingCasting(consumer, (MaterialVariantId)ThermalConstructMaterialIds.ENDERIUM, (FluidObject)TinkerFluids.moltenEnderium, smelteryFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ThermalConstructMaterialIds.LUMIUM, (FluidObject)TinkerFluids.moltenLumium, smelteryFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ThermalConstructMaterialIds.SIGNALUM, (FluidObject)TinkerFluids.moltenSignalum, smelteryFolder);
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)ThermalConstructModifierIds.INTEGRAL).setTools(TinkerTags.Items.BONUS_SLOTS)).addInput((ItemLike)ThermalCore.ITEMS.get("upgrade_augment_3")).setMaxLevel(1)).save(this.withCondition(consumer, new ICondition[]{new NotCondition((ICondition)new ModLoadedCondition("thermal_extra"))}), this.prefix((ResourceLocation)ThermalConstructModifierIds.INTEGRAL, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)ThermalConstructModifierIds.INTEGRAL).setTools(TinkerTags.Items.BONUS_SLOTS)).addInput((ItemLike)ThermalExtraItems.ABYSSAL_INTEGRAL_COMPONENT.get()).setMaxLevel(1)).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("thermal_extra")}), this.prefix(this.merge((ResourceLocation)ThermalConstructModifierIds.INTEGRAL, "_extra"), upgradeFolder));
        this.machineRecipe(consumer, TinkerMaterials.amethystBronze, ThermalConstructItems.AMETHYST_BRONZE);
        this.machineRecipe(consumer, TinkerMaterials.cobalt, ThermalConstructItems.COBALT);
        this.machineRecipe(consumer, TinkerMaterials.cinderslime, ThermalConstructItems.CINDERSLIME);
        this.machineRecipe(consumer, TinkerMaterials.hepatizon, ThermalConstructItems.HEPATIZON);
        this.machineRecipe(consumer, TinkerMaterials.manyullyn, ThermalConstructItems.MANYULLYN);
        this.machineRecipe(consumer, TinkerMaterials.queensSlime, ThermalConstructItems.QUEENS_SLIME);
        this.machineRecipe(consumer, TinkerMaterials.slimesteel, ThermalConstructItems.SLIMESTEEL);
    }

    protected void smeltingRecipe(Consumer<FinishedRecipe> p_176740_, ItemLike p_176741_, ItemLike p_176742_) {
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_176742_}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)p_176741_, (float)0.1f, (int)200).m_126132_(ThermalConstructRecipeProvider.m_176602_((ItemLike)p_176742_), (CriterionTriggerInstance)ThermalConstructRecipeProvider.m_125977_((ItemLike)p_176742_)).m_176498_(p_176740_);
    }

    public void machineRecipe(Consumer<FinishedRecipe> consumer, MetalItemObject object, MetalItem metalItem) {
        String type = metalItem.getName();
        Item gear = metalItem.getGear().m_5456_();
        Item ingot = object.getIngot();
        TagKey ingotTag = object.getIngotTag();
        this.smeltingRecipe(consumer, (ItemLike)ingot, (ItemLike)metalItem.getDust());
        MachineRecipeBuilder.pulverizer().input(ingotTag).output(metalItem.getDust()).energy(5000).save(consumer, ThermalConstruct.getResource("machine/pulverizer" + type + "_dust").toString());
        MachineRecipeBuilder.press().energy(3000).input(ingotTag).input((Item)ThermalCore.ITEMS.get("press_coin_die")).output(metalItem.getCoin(), 3).save(consumer, ThermalConstruct.getResource("machine/press/" + type + "_coin").toString());
        MachineRecipeBuilder.press().energy(3000).input(object.getNuggetTag()).input((Item)ThermalCore.ITEMS.get("press_coin_die")).output(metalItem.getCoin(), 1).save(consumer, ThermalConstruct.getResource("machine/press/" + type + "_nugget_to_coin").toString());
        MachineRecipeBuilder.press().input(ingotTag).output(metalItem.getPlate()).energy(5000).save(consumer, ThermalConstruct.getResource("machine/press" + type + "_plate").toString());
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)gear).m_206416_(Character.valueOf('#'), ingotTag).m_206416_(Character.valueOf('i'), Tags.Items.NUGGETS_IRON).m_126130_(" # ").m_126130_("#i#").m_126130_(" # ").m_126132_("has_" + ThermalConstructRecipeProvider.name((Item)ingot), (CriterionTriggerInstance)ThermalConstructRecipeProvider.m_206406_((TagKey)ingotTag)).m_176500_(consumer, this.modid + ":parts/" + ThermalConstructRecipeProvider.name((Item)gear));
        MachineRecipeBuilder.press().input((Ingredient)new IngredientWithCount(Ingredient.m_204132_((TagKey)ingotTag), 4)).input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ThermalCore.ITEMS.get("press_gear_die")})).output((ItemLike)gear).save(consumer, "thermal_extra:machine/press/" + type + "_gear");
    }

    public void extraCompat(String smelteryFolder, String materialFolder, Consumer<FinishedRecipe> consumer) {
        this.metal(consumer, (FluidObject<?>)ThermalConstructFluids.moltenSoulInfused).metal().dust().plate().gear().coin().sheetmetal().rod();
        this.metal(consumer, (FluidObject<?>)ThermalConstructFluids.moltenTwinite).metal().dust().plate().gear().coin().sheetmetal().rod();
        this.metal(consumer, (FluidObject<?>)ThermalConstructFluids.moltenShellite).metal().dust().plate().gear().coin().sheetmetal().rod();
        this.metal(consumer, (FluidObject<?>)ThermalConstructFluids.moltenDragonsteel).metal().dust().plate().gear().coin().sheetmetal().rod();
        this.metal(consumer, (FluidObject<?>)ThermalConstructFluids.moltenAbyssal).metal().dust().plate().gear().coin().sheetmetal().rod();
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ThermalConstructMaterialIds.SOUL_INFUSED, materialFolder, "soul_infused", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ThermalConstructMaterialIds.TWINITE, materialFolder, "twinite", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ThermalConstructMaterialIds.SHELLITE, materialFolder, "shellite", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ThermalConstructMaterialIds.DRAGONSTEEL, materialFolder, "dragonsteel", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ThermalConstructMaterialIds.ABYSSAL, materialFolder, "abyssal", true);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ThermalConstructMaterialIds.SOUL_INFUSED, (FluidObject)ThermalConstructFluids.moltenSoulInfused, smelteryFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ThermalConstructMaterialIds.TWINITE, (FluidObject)ThermalConstructFluids.moltenTwinite, smelteryFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ThermalConstructMaterialIds.SHELLITE, (FluidObject)ThermalConstructFluids.moltenShellite, smelteryFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ThermalConstructMaterialIds.DRAGONSTEEL, (FluidObject)ThermalConstructFluids.moltenDragonsteel, smelteryFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ThermalConstructMaterialIds.ABYSSAL, (FluidObject)ThermalConstructFluids.moltenAbyssal, smelteryFolder);
        this.thermalCast(consumer, smelteryFolder, new ResourceLocation("thermal_extra:chiller_plate_cast"), 450);
    }

    protected void thermalCast(Consumer<FinishedRecipe> consumer, String folder, ResourceLocation castName, int output) {
        MeltingRecipeBuilder.melting((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{castName}), (FluidOutput)FluidOutput.fromFluid((Fluid)TinkerFluids.moltenBronze.get(), (int)output), (int)TinkerFluids.moltenBronze.getType().getTemperature(), (int)15).save(consumer, new ResourceLocation("thermalconstruct", folder + castName.m_135815_()));
    }

    protected SmelteryRecipeBuilder smelteryBuilder(Consumer<FinishedRecipe> consumer, String folder, Fluid fluid, String materialName) {
        return SmelteryRecipeBuilder.fluid(consumer, (ResourceLocation)this.location(materialName), (Fluid)fluid).meltingFolder(folder);
    }

    public SmelteryRecipeBuilder metal(Consumer<FinishedRecipe> consumer, String name, TagKey<Fluid> fluid) {
        return SmelteryRecipeBuilder.fluid(consumer, (ResourceLocation)this.location(name), fluid).castingFolder("smeltery/casting/metal").meltingFolder("smeltery/melting/metal");
    }

    public SmelteryRecipeBuilder metal(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid) {
        return this.molten(consumer, fluid).castingFolder("smeltery/casting/metal").meltingFolder("smeltery/melting/metal");
    }

    public ResourceLocation merge(ResourceLocation loc, String toAdd) {
        return new ResourceLocation(loc.m_135827_(), loc.m_135815_() + toAdd);
    }

    public void castRecipe(Consumer<FinishedRecipe> consumer, ItemLike cast, Ingredient input, String folder, String name) {
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)cast).setFluidAndTime((FluidObject)TinkerFluids.moltenBronze, 360).setCast(input, true).setSwitchSlots().save(consumer, this.location(folder + "gold/" + name));
    }

    public String getModId() {
        return this.modid;
    }
}

